using System;
using MonoTouch.Foundation;
using MonoTouch.UIKit;
using System.CodeDom.Compiler;
using System.Collections.Generic;

namespace ConfAppiOS
{
	partial class SessionsViewController : UITableViewController
	{
		public List<Session> Sessions { get; set; }

		public SessionsViewController (IntPtr handle) : base (handle)
		{
		}

		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			this.TableView.Source = new SessionsTableViewSource(this.Sessions);
		}

		public override void PrepareForSegue (UIStoryboardSegue segue, NSObject sender)
		{
			base.PrepareForSegue (segue, sender);
			if (segue.Identifier == "sessionDetailsSegue")
			{
				var source = TableView.Source as SessionsTableViewSource;
				var rowPath = TableView.IndexPathForSelectedRow;
				var item = this.Sessions[rowPath.Row];
				((SessionDetailsViewController)segue.DestinationViewController).Session = item;
			}
		}
	}

	public class SessionsTableViewSource : UITableViewSource
	{
		private List<Session> _sessions;

		public SessionsTableViewSource (List<Session> sessions)
		{
			_sessions = sessions;
		}

		public override UITableViewCell GetCell (UITableView tableView, NSIndexPath indexPath)
		{
			UITableViewCell cell = tableView.DequeueReusableCell ("sessionCell");
			cell.TextLabel.Text = _sessions [indexPath.Row].Title;
			cell.TextLabel.Font = UIFont.SystemFontOfSize (10f);
			cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
			return cell;
		}

		public override int RowsInSection (UITableView tableview, int section)
		{
			return _sessions.Count;
		}
	}
}
