﻿using ConferenceApp.Controls;
using ConferenceApp.iOS;
using MonoTouch.UIKit;
using Xamarin.Forms;
using Xamarin.Forms.Platform.iOS;

[assembly: ExportRenderer(typeof(DisclosureIndicatorViewCell), typeof(DisclosureIndicatorViewCellRenderer))]
namespace ConferenceApp.iOS
{
    public class DisclosureIndicatorViewCellRenderer : ViewCellRenderer
    {
        public override UITableViewCell GetCell(Cell item, UITableView tv)
        {
            var cell = base.GetCell(item, tv);
            cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
            return cell;
        }
    }
}