// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#ifndef __PUBSUB_H_
#define __PUBSUB_H_

#include <memory>
#include "Variant.h"

class Publisher;

class Subscriber {
public:
  virtual void update(
    const Variant &message = Variant(),
    Publisher *sender = nullptr) = 0;
};


class PublisherPrivate;

class Publisher {
public:
  Publisher(void);
  void subscribe(Subscriber*);
  void unsubscribe(Subscriber*);
  void broadcast(const Variant &,
    Subscriber *ignoredSubscriber = nullptr);
  void block(bool);
  bool isBlocked(void) const;

private:
  std::shared_ptr<PublisherPrivate> d;
};

#endif // __PUBSUB_H_
