﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Data.Entity;
using System.Linq;

namespace KontaktVerwaltung
{
  internal class Program
  {
    static void Main(string[] args)
    {
      using(var db = new KontaktDb()) {
        db.Database.Log = Console.WriteLine;

        for(int i = 0; i < 10; i++) {
          db.Kontakte.Add(new Kontakt {
            Vorname = "Christian",
            Nachname = "Giesswein" + i.ToString()
          });
        }
        db.SaveChanges();

        var kontakt = db.Kontakte.FirstOrDefault(x => x.Id == 1);
        if(kontakt != null) {
          kontakt.Vorname = "EinAndererVorname";
        }
        db.SaveChanges();

        if(kontakt != null) {
          db.Kontakte.Remove(kontakt);
        }
        db.SaveChanges();

        foreach(var notiz in db.Notizen) {
          Console.WriteLine(notiz.Kontakt.Vorname);
        }

        foreach(var notiz in db.Notizen.Include(x => x.Kontakt)) {
          Console.WriteLine(notiz.Kontakt.Vorname);
        }
      }
    }
  }

  public class KontaktDb : DbContext
  {
    public DbSet<Notiz> Notizen { get; set; }
    public DbSet<Kontakt> Kontakte { get; set; }
  }

  public class Notiz
  {
    // optional: [Key]
    public int Id { get; set; }
    public string Text { get; set; }

    [Required]
    public virtual Kontakt Kontakt { get; set; }
  }

  public class Kontakt
  {
    public int Id { get; set; }
    public string Vorname { get; set; }
    public string Nachname { get; set; }
    public string Geburtsdatum { get; set; }
    public string PLZ { get; set; }
    public string Wohnort { get; set; }
    public string Straße { get; set; }

    public virtual ICollection<Notiz> Notiz { get; set; }
  }
}
