﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;
using Windows.Web.Syndication;

namespace FeedReaderUAP.Model
{
    [DataContract]
    [KnownType(typeof(FeedItem))]
    public class Feed
    {
        public Feed(SyndicationFeed feed)
        {
            Title = feed.Title.Text;
            Items = new List<FeedItem>();
            foreach (var item in feed.Items)
            {
                Items.Add(FeedItem.Import(item));
            }
        }


        [DataMember(Name = "Title")]
        public String Title { get; set; }

        [DataMember(Name = "Items")]
        public List<FeedItem> Items
        {
            get;
            set;
        }

        public static Feed Import(SyndicationFeed feed)
        {
            return new Feed(feed);
        }

    }
}
