/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.app.Activity;
import android.content.Context;
import android.nfc.NdefMessage;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.vrtoolkit.cardboard.CardboardDeviceParams;
import com.google.vrtoolkit.cardboard.CardboardView;
import com.google.vrtoolkit.cardboard.sensors.MagnetSensor;
import com.google.vrtoolkit.cardboard.sensors.NfcSensor;

public class CardboardActivity
extends Activity {
    private static final int NAVIGATION_BAR_TIMEOUT_MS = 2000;
    private CardboardView mCardboardView;
    private MagnetSensor mMagnetSensor;
    private NfcSensor mNfcSensor;
    private SensorListener sensorListener = new SensorListener();
    private int mVolumeKeysMode;

    public void setCardboardView(CardboardView cardboardView) {
        this.mCardboardView = cardboardView;
        if (cardboardView == null) {
            return;
        }
        NdefMessage tagContents = this.mNfcSensor.getTagContents();
        if (tagContents != null) {
            this.updateCardboardDeviceParams(CardboardDeviceParams.createFromNfcContents(tagContents));
        }
    }

    public CardboardView getCardboardView() {
        return this.mCardboardView;
    }

    public NfcSensor getNfcSensor() {
        return this.mNfcSensor;
    }

    public void setVolumeKeysMode(int mode) {
        this.mVolumeKeysMode = mode;
    }

    public int getVolumeKeysMode() {
        return this.mVolumeKeysMode;
    }

    public boolean areVolumeKeysDisabled() {
        switch (this.mVolumeKeysMode) {
            case 0: {
                return false;
            }
            case 2: {
                return this.mNfcSensor.isDeviceInCardboard();
            }
            case 1: {
                return true;
            }
        }
        int n = this.mVolumeKeysMode;
        throw new IllegalStateException(new StringBuilder(36).append("Invalid volume keys mode ").append(n).toString());
    }

    public void onInsertedIntoCardboard(CardboardDeviceParams cardboardDeviceParams) {
        this.updateCardboardDeviceParams(cardboardDeviceParams);
    }

    public void onRemovedFromCardboard() {
    }

    public void onCardboardTrigger() {
    }

    protected void updateCardboardDeviceParams(CardboardDeviceParams newParams) {
        if (this.mCardboardView != null) {
            this.mCardboardView.updateCardboardDeviceParams(newParams);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().addFlags(128);
        this.mMagnetSensor = new MagnetSensor((Context)this);
        this.mMagnetSensor.setOnCardboardTriggerListener(this.sensorListener);
        this.mNfcSensor = NfcSensor.getInstance((Context)this);
        this.mNfcSensor.addOnCardboardNfcListener(this.sensorListener);
        this.mNfcSensor.onNfcIntent(this.getIntent());
        this.setVolumeKeysMode(2);
        if (Build.VERSION.SDK_INT < 19) {
            final Handler handler = new Handler();
            this.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if ((visibility & 2) == 0) {
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                CardboardActivity.this.setFullscreenMode();
                            }
                        }, 2000L);
                    }
                }
            });
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mCardboardView != null) {
            this.mCardboardView.onResume();
        }
        this.mMagnetSensor.start();
        this.mNfcSensor.onResume(this);
    }

    protected void onPause() {
        super.onPause();
        if (this.mCardboardView != null) {
            this.mCardboardView.onPause();
        }
        this.mMagnetSensor.stop();
        this.mNfcSensor.onPause(this);
    }

    protected void onDestroy() {
        this.mNfcSensor.removeOnCardboardNfcListener(this.sensorListener);
        super.onDestroy();
    }

    public void setContentView(View view) {
        if (view instanceof CardboardView) {
            this.setCardboardView((CardboardView)view);
        }
        super.setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (view instanceof CardboardView) {
            this.setCardboardView((CardboardView)view);
        }
        super.setContentView(view, params);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if ((keyCode == 24 || keyCode == 25) && this.areVolumeKeysDisabled()) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if ((keyCode == 24 || keyCode == 25) && this.areVolumeKeysDisabled()) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            this.setFullscreenMode();
        }
    }

    private void setFullscreenMode() {
        this.getWindow().getDecorView().setSystemUiVisibility(5894);
    }

    private class SensorListener
    implements MagnetSensor.OnCardboardTriggerListener,
    NfcSensor.OnCardboardNfcListener {
        private SensorListener() {
        }

        @Override
        public void onInsertedIntoCardboard(CardboardDeviceParams deviceParams) {
            CardboardActivity.this.onInsertedIntoCardboard(deviceParams);
        }

        @Override
        public void onRemovedFromCardboard() {
            CardboardActivity.this.onRemovedFromCardboard();
        }

        @Override
        public void onCardboardTrigger() {
            CardboardActivity.this.onCardboardTrigger();
        }
    }

    public static abstract class VolumeKeys {
        public static final int NOT_DISABLED = 0;
        public static final int DISABLED = 1;
        public static final int DISABLED_WHILE_IN_CARDBOARD = 2;
    }
}

