/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.util.DisplayMetrics;
import android.view.Display;
import com.google.vrtoolkit.cardboard.PhoneParams;
import com.google.vrtoolkit.cardboard.proto.Phone;
import java.io.InputStream;

public class ScreenParams {
    private static final float METERS_PER_INCH = 0.0254f;
    private static final float DEFAULT_BORDER_SIZE_METERS = 0.003f;
    private int mWidth;
    private int mHeight;
    private float mXMetersPerPixel;
    private float mYMetersPerPixel;
    private float mBorderSizeMeters;

    public ScreenParams(Display display) {
        DisplayMetrics metrics = new DisplayMetrics();
        try {
            display.getRealMetrics(metrics);
        }
        catch (NoSuchMethodError e) {
            display.getMetrics(metrics);
        }
        this.mXMetersPerPixel = 0.0254f / metrics.xdpi;
        this.mYMetersPerPixel = 0.0254f / metrics.ydpi;
        this.mWidth = metrics.widthPixels;
        this.mHeight = metrics.heightPixels;
        this.mBorderSizeMeters = 0.003f;
        if (this.mHeight > this.mWidth) {
            int tempPx = this.mWidth;
            this.mWidth = this.mHeight;
            this.mHeight = tempPx;
            float tempMetersPerPixel = this.mXMetersPerPixel;
            this.mXMetersPerPixel = this.mYMetersPerPixel;
            this.mYMetersPerPixel = tempMetersPerPixel;
        }
    }

    public static ScreenParams fromProto(Display display, Phone.PhoneParams params) {
        if (params == null) {
            return null;
        }
        ScreenParams screenParams = new ScreenParams(display);
        if (params.hasXPpi()) {
            screenParams.mXMetersPerPixel = 0.0254f / params.getXPpi();
        }
        if (params.hasYPpi()) {
            screenParams.mYMetersPerPixel = 0.0254f / params.getYPpi();
        }
        if (params.hasBottomBezelHeight()) {
            screenParams.mBorderSizeMeters = params.getBottomBezelHeight();
        }
        return screenParams;
    }

    public ScreenParams(ScreenParams params) {
        this.mWidth = params.mWidth;
        this.mHeight = params.mHeight;
        this.mXMetersPerPixel = params.mXMetersPerPixel;
        this.mYMetersPerPixel = params.mYMetersPerPixel;
        this.mBorderSizeMeters = params.mBorderSizeMeters;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public float getWidthMeters() {
        return (float)this.mWidth * this.mXMetersPerPixel;
    }

    public float getHeightMeters() {
        return (float)this.mHeight * this.mYMetersPerPixel;
    }

    public void setBorderSizeMeters(float screenBorderSize) {
        this.mBorderSizeMeters = screenBorderSize;
    }

    public float getBorderSizeMeters() {
        return this.mBorderSizeMeters;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ScreenParams)) {
            return false;
        }
        ScreenParams o = (ScreenParams)other;
        return this.mWidth == o.mWidth && this.mHeight == o.mHeight && this.mXMetersPerPixel == o.mXMetersPerPixel && this.mYMetersPerPixel == o.mYMetersPerPixel && this.mBorderSizeMeters == o.mBorderSizeMeters;
    }

    public String toString() {
        int n = this.mWidth;
        int n2 = this.mHeight;
        float f = this.mXMetersPerPixel;
        float f2 = this.mYMetersPerPixel;
        float f3 = this.mBorderSizeMeters;
        return "{\n" + new StringBuilder(22).append("  width: ").append(n).append(",\n").toString() + new StringBuilder(23).append("  height: ").append(n2).append(",\n").toString() + new StringBuilder(39).append("  x_meters_per_pixel: ").append(f).append(",\n").toString() + new StringBuilder(39).append("  y_meters_per_pixel: ").append(f2).append(",\n").toString() + new StringBuilder(39).append("  border_size_meters: ").append(f3).append(",\n").toString() + "}";
    }

    public static ScreenParams createFromInputStream(Display display, InputStream inputStream) {
        Phone.PhoneParams phoneParams = PhoneParams.readFromInputStream(inputStream);
        if (phoneParams == null) {
            return null;
        }
        return ScreenParams.fromProto(display, phoneParams);
    }
}

