/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import android.view.MotionEvent;
import com.google.vrtoolkit.cardboard.GLStateBackup;
import com.google.vrtoolkit.cardboard.UiUtils;
import com.google.vrtoolkit.cardboard.Viewport;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

class UiLayer {
    private static final String TAG = UiLayer.class.getSimpleName();
    private static final int NORMAL_COLOR = -3355444;
    private static final int PRESSED_COLOR = -12303292;
    private static final float CENTER_LINE_THICKNESS_DP = 4.0f;
    private static final int BUTTON_WIDTH_DP = 28;
    private static final float TOUCH_SLOP_FACTOR = 1.5f;
    private final int mTouchWidthPx;
    private volatile Rect mTouchRect = new Rect();
    private boolean mDownWithinBounds;
    private Context mContext;
    private final GLStateBackup mGlStateBackup;
    private final ShaderProgram mShader;
    private final SettingsButtonRenderer mSettingsButtonRenderer;
    private final AlignmentMarkerRenderer mAlignmentMarkerRenderer;
    private Viewport mViewport;
    private boolean mShouldUpdateViewport = true;
    private boolean mSettingsButtonEnabled = true;
    private boolean mAlignmentMarkerEnabled = true;
    private boolean initialized;

    UiLayer(Context context) {
        this.mContext = context;
        float density = context.getResources().getDisplayMetrics().density;
        int buttonWidthPx = (int)(28.0f * density);
        this.mTouchWidthPx = (int)((float)buttonWidthPx * 1.5f);
        this.mGlStateBackup = new GLStateBackup();
        this.mShader = new ShaderProgram();
        this.mSettingsButtonRenderer = new SettingsButtonRenderer(this.mShader, buttonWidthPx);
        this.mAlignmentMarkerRenderer = new AlignmentMarkerRenderer(this.mShader, this.mTouchWidthPx, 4.0f * density);
        this.mViewport = new Viewport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateViewport(Viewport viewport) {
        UiLayer uiLayer = this;
        synchronized (uiLayer) {
            if (this.mViewport.equals(viewport)) {
                return;
            }
            int w = viewport.width;
            int h = viewport.height;
            this.mTouchRect = new Rect((w - this.mTouchWidthPx) / 2, h - this.mTouchWidthPx, (w + this.mTouchWidthPx) / 2, h);
            this.mViewport.setViewport(viewport.x, viewport.y, viewport.width, viewport.height);
            this.mShouldUpdateViewport = true;
        }
    }

    void initializeGl() {
        this.mShader.initializeGl();
        this.mGlStateBackup.clearTrackedVertexAttributes();
        this.mGlStateBackup.addTrackedVertexAttribute(this.mShader.aPosition);
        this.mGlStateBackup.readFromGL();
        this.mSettingsButtonRenderer.initializeGl();
        this.mAlignmentMarkerRenderer.initializeGl();
        this.mGlStateBackup.writeToGL();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw() {
        if (!this.getSettingsButtonEnabled() && !this.getAlignmentMarkerEnabled()) {
            return;
        }
        if (!this.initialized) {
            this.initializeGl();
        }
        this.mGlStateBackup.readFromGL();
        UiLayer uiLayer = this;
        synchronized (uiLayer) {
            if (this.mShouldUpdateViewport) {
                this.mShouldUpdateViewport = false;
                this.mSettingsButtonRenderer.updateViewport(this.mViewport);
                this.mAlignmentMarkerRenderer.updateViewport(this.mViewport);
            }
            this.mViewport.setGLViewport();
        }
        if (this.getSettingsButtonEnabled()) {
            this.mSettingsButtonRenderer.draw();
        }
        if (this.getAlignmentMarkerEnabled()) {
            this.mAlignmentMarkerRenderer.draw();
        }
        this.mGlStateBackup.writeToGL();
    }

    synchronized void setAlignmentMarkerEnabled(boolean enabled) {
        if (this.mAlignmentMarkerEnabled != enabled) {
            this.mAlignmentMarkerEnabled = enabled;
            this.mShouldUpdateViewport = true;
        }
    }

    synchronized boolean getAlignmentMarkerEnabled() {
        return this.mAlignmentMarkerEnabled;
    }

    synchronized void setSettingsButtonEnabled(boolean enabled) {
        if (this.mSettingsButtonEnabled != enabled) {
            this.mSettingsButtonEnabled = enabled;
            this.mShouldUpdateViewport = true;
        }
    }

    synchronized boolean getSettingsButtonEnabled() {
        return this.mSettingsButtonEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onTouchEvent(MotionEvent e) {
        boolean touchWithinBounds = false;
        UiLayer uiLayer = this;
        synchronized (uiLayer) {
            if (!this.mSettingsButtonEnabled) {
                return false;
            }
            touchWithinBounds = this.mTouchRect.contains((int)e.getX(), (int)e.getY());
        }
        if (e.getActionMasked() == 0 && touchWithinBounds) {
            this.mDownWithinBounds = true;
        }
        if (!this.mDownWithinBounds) {
            return false;
        }
        if (e.getActionMasked() == 1) {
            if (touchWithinBounds) {
                UiUtils.launchOrInstallCardboard(this.mContext);
            }
            this.mDownWithinBounds = false;
        } else if (e.getActionMasked() == 3) {
            this.mDownWithinBounds = false;
        }
        this.setPressed(this.mDownWithinBounds && touchWithinBounds);
        return true;
    }

    private void setPressed(boolean pressed) {
        if (this.mSettingsButtonRenderer != null) {
            this.mSettingsButtonRenderer.setColor(pressed ? -12303292 : -3355444);
        }
    }

    private static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String string = String.valueOf(String.valueOf(op));
            int n = error;
            Log.e((String)TAG, (String)new StringBuilder(21 + string.length()).append(string).append(": glError ").append(n).toString());
            String string2 = String.valueOf(String.valueOf(op));
            int n2 = error;
            throw new RuntimeException(new StringBuilder(21 + string2.length()).append(string2).append(": glError ").append(n2).toString());
        }
    }

    private static float lerp(float a, float b, float t) {
        return a * (1.0f - t) + b * t;
    }

    private static class SettingsButtonRenderer
    extends MeshRenderer {
        private static final int DEGREES_PER_GEAR_SECTION = 60;
        private static final int OUTER_RIM_END_DEG = 12;
        private static final int INNER_RIM_BEGIN_DEG = 20;
        private static final float OUTER_RADIUS = 1.0f;
        private static final float MIDDLE_RADIUS = 0.75f;
        private static final float INNER_RADIUS = 0.3125f;
        private static final int NUM_VERTICES = 60;
        private int mButtonWidthPx;
        private int mColor = -3355444;

        SettingsButtonRenderer(ShaderProgram shader, int buttonWidthPx) {
            super(shader);
            this.mButtonWidthPx = buttonWidthPx;
        }

        void initializeGl() {
            float[] vertexData = new float[120];
            int numVerticesPerRim = 30;
            float lerpInterval = 8.0f;
            for (int i = 0; i < numVerticesPerRim; ++i) {
                float theta = (float)i / (float)numVerticesPerRim * 360.0f;
                float mod = theta % 60.0f;
                float r = mod <= 12.0f ? 1.0f : (mod <= 20.0f ? UiLayer.lerp(1.0f, 0.75f, (mod - 12.0f) / lerpInterval) : (mod <= 40.0f ? 0.75f : (mod <= 48.0f ? UiLayer.lerp(0.75f, 1.0f, (mod - 60.0f + 20.0f) / lerpInterval) : 1.0f)));
                vertexData[2 * i] = r * (float)Math.cos(Math.toRadians(90.0f - theta));
                vertexData[2 * i + 1] = r * (float)Math.sin(Math.toRadians(90.0f - theta));
            }
            int innerStartingIndex = 2 * numVerticesPerRim;
            for (int i = 0; i < numVerticesPerRim; ++i) {
                float theta = (float)i / (float)numVerticesPerRim * 360.0f;
                vertexData[innerStartingIndex + 2 * i] = 0.3125f * (float)Math.cos(Math.toRadians(90.0f - theta));
                vertexData[innerStartingIndex + 2 * i + 1] = 0.3125f * (float)Math.sin(Math.toRadians(90.0f - theta));
            }
            short[] indexData = new short[62];
            for (int i = 0; i < numVerticesPerRim; ++i) {
                indexData[2 * i] = (short)i;
                indexData[2 * i + 1] = (short)(numVerticesPerRim + i);
            }
            indexData[indexData.length - 2] = 0;
            indexData[indexData.length - 1] = (short)numVerticesPerRim;
            this.genAndBindBuffers(vertexData, indexData);
        }

        synchronized void setColor(int color) {
            this.mColor = color;
        }

        @Override
        void updateViewport(Viewport viewport) {
            Matrix.setIdentityM((float[])this.mMvp, (int)0);
            float yScale = (float)this.mButtonWidthPx / (float)viewport.height;
            float xScale = yScale * (float)viewport.height / (float)viewport.width;
            Matrix.translateM((float[])this.mMvp, (int)0, (float)0.0f, (float)(yScale - 1.0f), (float)0.0f);
            Matrix.scaleM((float[])this.mMvp, (int)0, (float)xScale, (float)yScale, (float)1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void draw() {
            GLES20.glUseProgram((int)this.mShader.program);
            SettingsButtonRenderer settingsButtonRenderer = this;
            synchronized (settingsButtonRenderer) {
                GLES20.glUniform4f((int)this.mShader.uColor, (float)((float)Color.red((int)this.mColor) / 255.0f), (float)((float)Color.green((int)this.mColor) / 255.0f), (float)((float)Color.blue((int)this.mColor) / 255.0f), (float)((float)Color.alpha((int)this.mColor) / 255.0f));
            }
            super.draw();
        }
    }

    private static class AlignmentMarkerRenderer
    extends MeshRenderer {
        private static final int COLOR = Color.argb((int)255, (int)50, (int)50, (int)50);
        private float mVerticalBorderPaddingPx;
        private float mLineThicknessPx;

        AlignmentMarkerRenderer(ShaderProgram shader, float verticalBorderPaddingPx, float lineThicknessPx) {
            super(shader);
            this.mVerticalBorderPaddingPx = verticalBorderPaddingPx;
            this.mLineThicknessPx = lineThicknessPx;
        }

        void initializeGl() {
            float[] vertexData = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
            short[] indexData = new short[vertexData.length / 2];
            for (int i = 0; i < indexData.length; ++i) {
                indexData[i] = (short)i;
            }
            this.genAndBindBuffers(vertexData, indexData);
        }

        @Override
        void updateViewport(Viewport viewport) {
            Matrix.setIdentityM((float[])this.mMvp, (int)0);
            float xScale = this.mLineThicknessPx / (float)viewport.width;
            float yScale = 1.0f - 2.0f * this.mVerticalBorderPaddingPx / (float)viewport.height;
            Matrix.scaleM((float[])this.mMvp, (int)0, (float)xScale, (float)yScale, (float)1.0f);
        }

        @Override
        void draw() {
            GLES20.glUseProgram((int)this.mShader.program);
            GLES20.glUniform4f((int)this.mShader.uColor, (float)((float)Color.red((int)COLOR) / 255.0f), (float)((float)Color.green((int)COLOR) / 255.0f), (float)((float)Color.blue((int)COLOR) / 255.0f), (float)((float)Color.alpha((int)COLOR) / 255.0f));
            super.draw();
        }
    }

    private static class MeshRenderer {
        private static final int BYTES_PER_FLOAT = 4;
        private static final int BYTES_PER_SHORT = 4;
        protected static final int COMPONENTS_PER_VERT = 2;
        private static final int DATA_STRIDE_BYTES = 8;
        private static final int DATA_POS_OFFSET = 0;
        protected int mArrayBufferId = -1;
        protected int mElementBufferId = -1;
        protected ShaderProgram mShader;
        protected float[] mMvp = new float[16];
        private int mNumIndices;

        MeshRenderer(ShaderProgram shader) {
            this.mShader = shader;
        }

        void genAndBindBuffers(float[] vertexData, short[] indexData) {
            FloatBuffer vertexBuffer = ByteBuffer.allocateDirect(vertexData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertexBuffer.put(vertexData).position(0);
            this.mNumIndices = indexData.length;
            ShortBuffer indexBuffer = ByteBuffer.allocateDirect(this.mNumIndices * 4).order(ByteOrder.nativeOrder()).asShortBuffer();
            indexBuffer.put(indexData).position(0);
            int[] bufferIds = new int[2];
            GLES20.glGenBuffers((int)2, (int[])bufferIds, (int)0);
            this.mArrayBufferId = bufferIds[0];
            this.mElementBufferId = bufferIds[1];
            GLES20.glBindBuffer((int)34962, (int)this.mArrayBufferId);
            GLES20.glBufferData((int)34962, (int)(vertexData.length * 4), (Buffer)vertexBuffer, (int)35044);
            GLES20.glBindBuffer((int)34963, (int)this.mElementBufferId);
            GLES20.glBufferData((int)34963, (int)(indexData.length * 4), (Buffer)indexBuffer, (int)35044);
            UiLayer.checkGlError("genAndBindBuffers");
        }

        void updateViewport(Viewport viewport) {
            Matrix.setIdentityM((float[])this.mMvp, (int)0);
        }

        void draw() {
            GLES20.glDisable((int)2929);
            GLES20.glDisable((int)2884);
            GLES20.glUseProgram((int)this.mShader.program);
            GLES20.glUniformMatrix4fv((int)this.mShader.uMvpMatrix, (int)1, (boolean)false, (float[])this.mMvp, (int)0);
            GLES20.glBindBuffer((int)34962, (int)this.mArrayBufferId);
            GLES20.glVertexAttribPointer((int)this.mShader.aPosition, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
            GLES20.glEnableVertexAttribArray((int)this.mShader.aPosition);
            GLES20.glBindBuffer((int)34963, (int)this.mElementBufferId);
            GLES20.glDrawElements((int)5, (int)this.mNumIndices, (int)5123, (int)0);
        }
    }

    private static class ShaderProgram {
        private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nattribute vec2 aPosition;\nvoid main() {\n    gl_Position = uMVPMatrix * vec4(aPosition, 0.0, 1.0);\n}\n";
        private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform vec4 uColor;\nvoid main() {\n    gl_FragColor = uColor;\n}\n";
        public int program;
        public int aPosition;
        public int uMvpMatrix;
        public int uColor;

        private ShaderProgram() {
        }

        void initializeGl() {
            this.program = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
            if (this.program == 0) {
                throw new RuntimeException("Could not create program");
            }
            this.aPosition = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
            UiLayer.checkGlError("glGetAttribLocation aPosition");
            if (this.aPosition == -1) {
                throw new RuntimeException("Could not get attrib location for aPosition");
            }
            this.uMvpMatrix = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
            if (this.uMvpMatrix == -1) {
                throw new RuntimeException("Could not get uniform location for uMVPMatrix");
            }
            this.uColor = GLES20.glGetUniformLocation((int)this.program, (String)"uColor");
            if (this.uColor == -1) {
                throw new RuntimeException("Could not get uniform location for uColor");
            }
        }

        private int loadShader(int shaderType, String source) {
            int shader = GLES20.glCreateShader((int)shaderType);
            if (shader != 0) {
                GLES20.glShaderSource((int)shader, (String)source);
                GLES20.glCompileShader((int)shader);
                int[] compiled = new int[1];
                GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
                if (compiled[0] == 0) {
                    int n = shaderType;
                    Log.e((String)TAG, (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                    Log.e((String)TAG, (String)GLES20.glGetShaderInfoLog((int)shader));
                    GLES20.glDeleteShader((int)shader);
                    shader = 0;
                }
            }
            return shader;
        }

        private int createProgram(String vertexSource, String fragmentSource) {
            int vertexShader = this.loadShader(35633, vertexSource);
            if (vertexShader == 0) {
                return 0;
            }
            int pixelShader = this.loadShader(35632, fragmentSource);
            if (pixelShader == 0) {
                return 0;
            }
            int program = GLES20.glCreateProgram();
            if (program != 0) {
                GLES20.glAttachShader((int)program, (int)vertexShader);
                UiLayer.checkGlError("glAttachShader");
                GLES20.glAttachShader((int)program, (int)pixelShader);
                UiLayer.checkGlError("glAttachShader");
                GLES20.glLinkProgram((int)program);
                int[] linkStatus = new int[1];
                GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
                if (linkStatus[0] != 1) {
                    Log.e((String)TAG, (String)"Could not link program: ");
                    Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
                    GLES20.glDeleteProgram((int)program);
                    program = 0;
                }
                UiLayer.checkGlError("glLinkProgram");
            }
            return program;
        }
    }
}

