/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;

class UiUtils {
    private static final String CARDBOARD_WEBSITE = "http://google.com/cardboard/cfg?vrtoolkit_version=0.5.1";
    private static final String CARDBOARD_CONFIGURE_ACTION = "com.google.vrtoolkit.cardboard.CONFIGURE";
    private static final String INTENT_EXTRAS_VERSION_KEY = "VERSION";
    private static final String NO_BROWSER_TEXT = "No browser to open website.";

    UiUtils() {
    }

    static void launchOrInstallCardboard(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent settingsIntent = new Intent();
        settingsIntent.setAction(CARDBOARD_CONFIGURE_ACTION);
        settingsIntent.putExtra(INTENT_EXTRAS_VERSION_KEY, "0.5.1");
        List resolveInfos = pm.queryIntentActivities(settingsIntent, 0);
        ArrayList<Intent> intentsToGoogleCardboard = new ArrayList<Intent>();
        for (ResolveInfo info : resolveInfos) {
            String pkgName = info.activityInfo.packageName;
            if (!pkgName.startsWith("com.google.")) continue;
            Intent intent = new Intent(settingsIntent);
            intent.setClassName(pkgName, info.activityInfo.name);
            intentsToGoogleCardboard.add(intent);
        }
        if (intentsToGoogleCardboard.isEmpty()) {
            UiUtils.showInstallDialog(context);
        } else if (intentsToGoogleCardboard.size() == 1) {
            UiUtils.showConfigureDialog(context, (Intent)intentsToGoogleCardboard.get(0));
        } else {
            UiUtils.showConfigureDialog(context, settingsIntent);
        }
    }

    private static void showInstallDialog(final Context context) {
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                try {
                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)UiUtils.CARDBOARD_WEBSITE)));
                }
                catch (ActivityNotFoundException e) {
                    Toast.makeText((Context)context.getApplicationContext(), (CharSequence)UiUtils.NO_BROWSER_TEXT, (int)1).show();
                }
            }
        };
        FragmentManager fragmentManager = ((Activity)context).getFragmentManager();
        SettingsDialogFragment dialog = new SettingsDialogFragment(new InstallDialogStrings(), listener);
        dialog.show(fragmentManager, "InstallCardboardDialog");
    }

    private static void showConfigureDialog(final Context context, final Intent intent) {
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                try {
                    context.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    UiUtils.showInstallDialog(context);
                }
            }
        };
        FragmentManager fragmentManager = ((Activity)context).getFragmentManager();
        SettingsDialogFragment dialog = new SettingsDialogFragment(new ConfigureDialogStrings(), listener);
        dialog.show(fragmentManager, "ConfigureCardboardDialog");
    }

    private static class SettingsDialogFragment
    extends DialogFragment {
        private DialogStrings mDialogStrings;
        private DialogInterface.OnClickListener mPositiveButtonListener;

        private SettingsDialogFragment(DialogStrings dialogStrings, DialogInterface.OnClickListener positiveButtonListener) {
            this.mDialogStrings = dialogStrings;
            this.mPositiveButtonListener = positiveButtonListener;
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
            builder.setTitle((CharSequence)this.mDialogStrings.mTitle).setMessage((CharSequence)this.mDialogStrings.mMessage).setPositiveButton((CharSequence)this.mDialogStrings.mPositiveButtonText, this.mPositiveButtonListener).setNegativeButton((CharSequence)this.mDialogStrings.mNegativeButtonText, null);
            return builder.create();
        }
    }

    private static class ConfigureDialogStrings
    extends DialogStrings {
        ConfigureDialogStrings() {
            this.mTitle = "Configure";
            this.mMessage = "Set up your viewer for the best experience.";
            this.mPositiveButtonText = "Setup";
            this.mNegativeButtonText = "Cancel";
        }
    }

    private static class InstallDialogStrings
    extends DialogStrings {
        InstallDialogStrings() {
            this.mTitle = "Configure";
            this.mMessage = "Get the Cardboard app in order to configure your viewer.";
            this.mPositiveButtonText = "Go to Play Store";
            this.mNegativeButtonText = "Cancel";
        }
    }

    private static class DialogStrings {
        String mTitle;
        String mMessage;
        String mPositiveButtonText;
        String mNegativeButtonText;

        private DialogStrings() {
        }
    }
}

