/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.nano;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.Extension;
import com.google.protobuf.nano.FieldArray;
import com.google.protobuf.nano.FieldData;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.UnknownFieldData;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public abstract class ExtendableMessageNano<M extends ExtendableMessageNano<M>>
extends MessageNano {
    protected FieldArray unknownFieldData;

    @Override
    protected int computeSerializedSize() {
        int size = 0;
        if (this.unknownFieldData != null) {
            for (int i = 0; i < this.unknownFieldData.size(); ++i) {
                FieldData field = this.unknownFieldData.dataAt(i);
                size += field.computeSerializedSize();
            }
        }
        return size;
    }

    @Override
    public void writeTo(CodedOutputByteBufferNano output) throws IOException {
        if (this.unknownFieldData == null) {
            return;
        }
        for (int i = 0; i < this.unknownFieldData.size(); ++i) {
            FieldData field = this.unknownFieldData.dataAt(i);
            field.writeTo(output);
        }
    }

    public final boolean hasExtension(Extension<M, ?> extension) {
        if (this.unknownFieldData == null) {
            return false;
        }
        FieldData field = this.unknownFieldData.get(WireFormatNano.getTagFieldNumber(extension.tag));
        return field != null;
    }

    public final <T> T getExtension(Extension<M, T> extension) {
        if (this.unknownFieldData == null) {
            return null;
        }
        FieldData field = this.unknownFieldData.get(WireFormatNano.getTagFieldNumber(extension.tag));
        return field == null ? null : (T)field.getValue(extension);
    }

    public final <T> M setExtension(Extension<M, T> extension, T value) {
        int fieldNumber = WireFormatNano.getTagFieldNumber(extension.tag);
        if (value == null) {
            if (this.unknownFieldData != null) {
                this.unknownFieldData.remove(fieldNumber);
                if (this.unknownFieldData.isEmpty()) {
                    this.unknownFieldData = null;
                }
            }
        } else {
            FieldData field = null;
            if (this.unknownFieldData == null) {
                this.unknownFieldData = new FieldArray();
            } else {
                field = this.unknownFieldData.get(fieldNumber);
            }
            if (field == null) {
                this.unknownFieldData.put(fieldNumber, new FieldData(extension, value));
            } else {
                field.setValue(extension, value);
            }
        }
        ExtendableMessageNano typedThis = this;
        return (M)typedThis;
    }

    protected final boolean storeUnknownField(CodedInputByteBufferNano input, int tag) throws IOException {
        int startPos = input.getPosition();
        if (!input.skipField(tag)) {
            return false;
        }
        int fieldNumber = WireFormatNano.getTagFieldNumber(tag);
        int endPos = input.getPosition();
        byte[] bytes = input.getData(startPos, endPos - startPos);
        UnknownFieldData unknownField = new UnknownFieldData(tag, bytes);
        FieldData field = null;
        if (this.unknownFieldData == null) {
            this.unknownFieldData = new FieldArray();
        } else {
            field = this.unknownFieldData.get(fieldNumber);
        }
        if (field == null) {
            field = new FieldData();
            this.unknownFieldData.put(fieldNumber, field);
        }
        field.addUnknownField(unknownField);
        return true;
    }

    protected final boolean unknownFieldDataEquals(M other) {
        if (this.unknownFieldData == null || this.unknownFieldData.isEmpty()) {
            return ((ExtendableMessageNano)other).unknownFieldData == null || ((ExtendableMessageNano)other).unknownFieldData.isEmpty();
        }
        return this.unknownFieldData.equals(((ExtendableMessageNano)other).unknownFieldData);
    }

    protected final int unknownFieldDataHashCode() {
        return this.unknownFieldData == null || this.unknownFieldData.isEmpty() ? 0 : this.unknownFieldData.hashCode();
    }
}

