/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.util.Base64;
import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.vrtoolkit.cardboard.Distortion;
import com.google.vrtoolkit.cardboard.FieldOfView;
import com.google.vrtoolkit.cardboard.proto.CardboardDevice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class CardboardDeviceParams {
    private static final String TAG = "CardboardDeviceParams";
    private static final String HTTP_SCHEME = "http";
    private static final String URI_HOST_GOOGLE_SHORT = "g.co";
    private static final String URI_HOST_GOOGLE = "google.com";
    private static final String URI_PATH_CARDBOARD_HOME = "cardboard";
    private static final String URI_PATH_CARDBOARD_CONFIG = "cardboard/cfg";
    private static final String URI_SCHEME_LEGACY_CARDBOARD = "cardboard";
    private static final String URI_HOST_LEGACY_CARDBOARD = "v1.0.0";
    private static final Uri URI_ORIGINAL_CARDBOARD_NFC = new Uri.Builder().scheme("cardboard").authority("v1.0.0").build();
    private static final Uri URI_ORIGINAL_CARDBOARD_QR_CODE = new Uri.Builder().scheme("http").authority("g.co").appendEncodedPath("cardboard").build();
    private static final String URI_KEY_PARAMS = "p";
    private static final int STREAM_SENTINEL = 894990891;
    private static final String DEFAULT_VENDOR = "Google, Inc.";
    private static final String DEFAULT_MODEL = "Cardboard v1";
    private static final float DEFAULT_INTER_LENS_DISTANCE = 0.06f;
    private static final float DEFAULT_VERTICAL_DISTANCE_TO_LENS_CENTER = 0.035f;
    private static final float DEFAULT_SCREEN_TO_LENS_DISTANCE = 0.042f;
    private String mVendor;
    private String mModel;
    private float mInterLensDistance;
    private float mVerticalDistanceToLensCenter;
    private float mScreenToLensDistance;
    private FieldOfView mLeftEyeMaxFov;
    private boolean mHasMagnet;
    private Distortion mDistortion;

    public CardboardDeviceParams() {
        this.setDefaultValues();
    }

    public CardboardDeviceParams(CardboardDeviceParams params) {
        this.copyFrom(params);
    }

    public CardboardDeviceParams(CardboardDevice.DeviceParams params) {
        this.setDefaultValues();
        if (params == null) {
            return;
        }
        this.mVendor = params.getVendor();
        this.mModel = params.getModel();
        this.mInterLensDistance = params.getInterLensDistance();
        this.mVerticalDistanceToLensCenter = params.getTrayBottomToLensHeight();
        this.mScreenToLensDistance = params.getScreenToLensDistance();
        this.mLeftEyeMaxFov = FieldOfView.parseFromProtobuf(params.leftEyeFieldOfViewAngles);
        if (this.mLeftEyeMaxFov == null) {
            this.mLeftEyeMaxFov = new FieldOfView();
        }
        this.mDistortion = Distortion.parseFromProtobuf(params.distortionCoefficients);
        if (this.mDistortion == null) {
            this.mDistortion = new Distortion();
        }
        this.mHasMagnet = params.getHasMagnet();
    }

    public static boolean isOriginalCardboardDeviceUri(Uri uri) {
        return URI_ORIGINAL_CARDBOARD_QR_CODE.equals((Object)uri) || URI_ORIGINAL_CARDBOARD_NFC.getScheme().equals(uri.getScheme()) && URI_ORIGINAL_CARDBOARD_NFC.getAuthority().equals(uri.getAuthority());
    }

    private static boolean isCardboardDeviceUri(Uri uri) {
        return HTTP_SCHEME.equals(uri.getScheme()) && URI_HOST_GOOGLE.equals(uri.getAuthority()) && "/cardboard/cfg".equals(uri.getPath());
    }

    public static boolean isCardboardUri(Uri uri) {
        return CardboardDeviceParams.isOriginalCardboardDeviceUri(uri) || CardboardDeviceParams.isCardboardDeviceUri(uri);
    }

    public static CardboardDeviceParams createFromUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        if (CardboardDeviceParams.isOriginalCardboardDeviceUri(uri)) {
            Log.d((String)TAG, (String)"URI recognized as original cardboard device.");
            CardboardDeviceParams deviceParams = new CardboardDeviceParams();
            deviceParams.setDefaultValues();
            return deviceParams;
        }
        if (!CardboardDeviceParams.isCardboardDeviceUri(uri)) {
            Log.w((String)TAG, (String)String.format("URI \"%s\" not recognized as cardboard device.", uri));
            return null;
        }
        CardboardDevice.DeviceParams params = null;
        String paramsEncoded = uri.getQueryParameter(URI_KEY_PARAMS);
        if (paramsEncoded != null) {
            try {
                byte[] bytes = Base64.decode((String)paramsEncoded, (int)11);
                params = (CardboardDevice.DeviceParams)MessageNano.mergeFrom((MessageNano)new CardboardDevice.DeviceParams(), (byte[])bytes);
                Log.d((String)TAG, (String)"Read cardboard params from URI.");
            }
            catch (Exception e) {
                String string = String.valueOf(e.toString());
                Log.w((String)TAG, (String)(string.length() != 0 ? "Parsing cardboard parameters from URI failed: ".concat(string) : new String("Parsing cardboard parameters from URI failed: ")));
            }
        } else {
            Log.w((String)TAG, (String)"No cardboard parameters in URI.");
        }
        return new CardboardDeviceParams(params);
    }

    public static CardboardDeviceParams createFromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            ByteBuffer header = ByteBuffer.allocate(8);
            if (inputStream.read(header.array(), 0, header.array().length) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            int sentinel = header.getInt();
            int length = header.getInt();
            if (sentinel != 894990891) {
                Log.e((String)TAG, (String)"Error parsing param record: incorrect sentinel.");
                return null;
            }
            byte[] protoBytes = new byte[length];
            if (inputStream.read(protoBytes, 0, protoBytes.length) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            return new CardboardDeviceParams((CardboardDevice.DeviceParams)MessageNano.mergeFrom((MessageNano)new CardboardDevice.DeviceParams(), (byte[])protoBytes));
        }
        catch (InvalidProtocolBufferNanoException e) {
            String string = String.valueOf(e.toString());
            Log.w((String)TAG, (String)(string.length() != 0 ? "Error parsing protocol buffer: ".concat(string) : new String("Error parsing protocol buffer: ")));
        }
        catch (IOException e) {
            String string = String.valueOf(e.toString());
            Log.w((String)TAG, (String)(string.length() != 0 ? "Error reading Cardboard parameters: ".concat(string) : new String("Error reading Cardboard parameters: ")));
        }
        return null;
    }

    public boolean writeToOutputStream(OutputStream outputStream) {
        try {
            byte[] paramBytes = this.toByteArray();
            ByteBuffer header = ByteBuffer.allocate(8);
            header.putInt(894990891);
            header.putInt(paramBytes.length);
            outputStream.write(header.array());
            outputStream.write(paramBytes);
            return true;
        }
        catch (IOException e) {
            String string = String.valueOf(e.toString());
            Log.w((String)TAG, (String)(string.length() != 0 ? "Error writing Cardboard parameters: ".concat(string) : new String("Error writing Cardboard parameters: ")));
            return false;
        }
    }

    public static CardboardDeviceParams createFromNfcContents(NdefMessage tagContents) {
        if (tagContents == null) {
            Log.w((String)TAG, (String)"Could not get contents from NFC tag.");
            return null;
        }
        for (NdefRecord record : tagContents.getRecords()) {
            CardboardDeviceParams params = CardboardDeviceParams.createFromUri(record.toUri());
            if (params == null) continue;
            return params;
        }
        return null;
    }

    private byte[] toByteArray() {
        CardboardDevice.DeviceParams params = new CardboardDevice.DeviceParams();
        params.setVendor(this.mVendor);
        params.setModel(this.mModel);
        params.setInterLensDistance(this.mInterLensDistance);
        params.setTrayBottomToLensHeight(this.mVerticalDistanceToLensCenter);
        params.setScreenToLensDistance(this.mScreenToLensDistance);
        params.leftEyeFieldOfViewAngles = this.mLeftEyeMaxFov.toProtobuf();
        params.distortionCoefficients = this.mDistortion.toProtobuf();
        if (this.mHasMagnet) {
            params.setHasMagnet(this.mHasMagnet);
        }
        return MessageNano.toByteArray((MessageNano)params);
    }

    public Uri toUri() {
        byte[] paramsData = this.toByteArray();
        int paramsSize = paramsData.length;
        return new Uri.Builder().scheme(HTTP_SCHEME).authority(URI_HOST_GOOGLE).appendEncodedPath(URI_PATH_CARDBOARD_CONFIG).appendQueryParameter(URI_KEY_PARAMS, Base64.encodeToString((byte[])paramsData, (int)0, (int)paramsSize, (int)11)).build();
    }

    public void setVendor(String vendor) {
        this.mVendor = vendor != null ? vendor : "";
    }

    public String getVendor() {
        return this.mVendor;
    }

    public void setModel(String model) {
        this.mModel = model != null ? model : "";
    }

    public String getModel() {
        return this.mModel;
    }

    public void setInterLensDistance(float interLensDistance) {
        this.mInterLensDistance = interLensDistance;
    }

    public float getInterLensDistance() {
        return this.mInterLensDistance;
    }

    public void setVerticalDistanceToLensCenter(float verticalDistanceToLensCenter) {
        this.mVerticalDistanceToLensCenter = verticalDistanceToLensCenter;
    }

    public float getVerticalDistanceToLensCenter() {
        return this.mVerticalDistanceToLensCenter;
    }

    public void setScreenToLensDistance(float screenToLensDistance) {
        this.mScreenToLensDistance = screenToLensDistance;
    }

    public float getScreenToLensDistance() {
        return this.mScreenToLensDistance;
    }

    public Distortion getDistortion() {
        return this.mDistortion;
    }

    public FieldOfView getLeftEyeMaxFov() {
        return this.mLeftEyeMaxFov;
    }

    public boolean getHasMagnet() {
        return this.mHasMagnet;
    }

    public void setHasMagnet(boolean magnet) {
        this.mHasMagnet = magnet;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof CardboardDeviceParams)) {
            return false;
        }
        CardboardDeviceParams o = (CardboardDeviceParams)other;
        return this.mVendor.equals(o.mVendor) && this.mModel.equals(o.mModel) && this.mInterLensDistance == o.mInterLensDistance && this.mVerticalDistanceToLensCenter == o.mVerticalDistanceToLensCenter && this.mScreenToLensDistance == o.mScreenToLensDistance && this.mLeftEyeMaxFov.equals(o.mLeftEyeMaxFov) && this.mDistortion.equals(o.mDistortion) && this.mHasMagnet == o.mHasMagnet;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.mVendor));
        String string2 = String.valueOf(String.valueOf(this.mModel));
        float f = this.mInterLensDistance;
        float f2 = this.mVerticalDistanceToLensCenter;
        float f3 = this.mScreenToLensDistance;
        String string3 = String.valueOf(String.valueOf(this.mLeftEyeMaxFov.toString().replace("\n", "\n  ")));
        String string4 = String.valueOf(String.valueOf(this.mDistortion.toString().replace("\n", "\n  ")));
        boolean bl = this.mHasMagnet;
        return "{\n" + new StringBuilder(12 + string.length()).append("  vendor: ").append(string).append(",\n").toString() + new StringBuilder(11 + string2.length()).append("  model: ").append(string2).append(",\n").toString() + new StringBuilder(40).append("  inter_lens_distance: ").append(f).append(",\n").toString() + new StringBuilder(53).append("  vertical_distance_to_lens_center: ").append(f2).append(",\n").toString() + new StringBuilder(44).append("  screen_to_lens_distance: ").append(f3).append(",\n").toString() + new StringBuilder(22 + string3.length()).append("  left_eye_max_fov: ").append(string3).append(",\n").toString() + new StringBuilder(16 + string4.length()).append("  distortion: ").append(string4).append(",\n").toString() + new StringBuilder(17).append("  magnet: ").append(bl).append(",\n").toString() + "}\n";
    }

    private void setDefaultValues() {
        this.mVendor = DEFAULT_VENDOR;
        this.mModel = DEFAULT_MODEL;
        this.mInterLensDistance = 0.06f;
        this.mVerticalDistanceToLensCenter = 0.035f;
        this.mScreenToLensDistance = 0.042f;
        this.mLeftEyeMaxFov = new FieldOfView();
        this.mHasMagnet = true;
        this.mDistortion = new Distortion();
    }

    private void copyFrom(CardboardDeviceParams params) {
        this.mVendor = params.mVendor;
        this.mModel = params.mModel;
        this.mInterLensDistance = params.mInterLensDistance;
        this.mVerticalDistanceToLensCenter = params.mVerticalDistanceToLensCenter;
        this.mScreenToLensDistance = params.mScreenToLensDistance;
        this.mLeftEyeMaxFov = new FieldOfView(params.mLeftEyeMaxFov);
        this.mHasMagnet = params.mHasMagnet;
        this.mDistortion = new Distortion(params.mDistortion);
    }
}

