/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import com.google.vrtoolkit.cardboard.CardboardDeviceParams;
import com.google.vrtoolkit.cardboard.Distortion;
import com.google.vrtoolkit.cardboard.DistortionRenderer;
import com.google.vrtoolkit.cardboard.Eye;
import com.google.vrtoolkit.cardboard.FieldOfView;
import com.google.vrtoolkit.cardboard.HeadMountedDisplay;
import com.google.vrtoolkit.cardboard.HeadMountedDisplayManager;
import com.google.vrtoolkit.cardboard.HeadTransform;
import com.google.vrtoolkit.cardboard.PhoneParams;
import com.google.vrtoolkit.cardboard.ScreenParams;
import com.google.vrtoolkit.cardboard.UiLayer;
import com.google.vrtoolkit.cardboard.Viewport;
import com.google.vrtoolkit.cardboard.proto.Phone;
import com.google.vrtoolkit.cardboard.sensors.HeadTracker;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class CardboardView
extends GLSurfaceView {
    private static final String TAG = "CardboardView";
    private RendererHelper mRendererHelper;
    private HeadTracker mHeadTracker;
    private HeadMountedDisplayManager mHmdManager;
    private UiLayer mUiLayer;
    private CountDownLatch mShutdownLatch;
    private boolean mVRMode = true;
    private boolean mRendererSet = false;
    private volatile boolean mRestoreGLStateEnabled = true;
    private volatile boolean mDistortionCorrectionEnabled = true;
    private volatile boolean mChromaticAberrationCorrectionEnabled = false;
    private volatile boolean mVignetteEnabled = true;

    public CardboardView(Context context) {
        super(context);
        this.init(context);
    }

    public CardboardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void setRenderer(Renderer renderer) {
        if (renderer == null) {
            return;
        }
        this.mRendererHelper.setRenderer(renderer);
        super.setRenderer((GLSurfaceView.Renderer)this.mRendererHelper);
        this.mRendererSet = true;
    }

    public void setRenderer(StereoRenderer renderer) {
        this.setRenderer(renderer != null ? new StereoRendererHelper(renderer) : (Renderer)null);
    }

    public void getCurrentEyeParams(HeadTransform head, Eye leftEye, Eye rightEye, Eye monocular) {
        this.mRendererHelper.getCurrentEyeParams(head, leftEye, rightEye, monocular);
    }

    public void setVRModeEnabled(boolean enabled) {
        this.mVRMode = enabled;
        this.mRendererHelper.setVRModeEnabled(enabled);
    }

    public boolean getVRMode() {
        return this.mVRMode;
    }

    public void setAlignmentMarkerEnabled(boolean enabled) {
        this.mUiLayer.setAlignmentMarkerEnabled(enabled);
    }

    public boolean getAlignmentMarkerEnabled() {
        return this.mUiLayer.getAlignmentMarkerEnabled();
    }

    public void setSettingsButtonEnabled(boolean enabled) {
        this.mUiLayer.setSettingsButtonEnabled(enabled);
    }

    public boolean getSettingsButtonEnabled() {
        return this.mUiLayer.getSettingsButtonEnabled();
    }

    public HeadMountedDisplay getHeadMountedDisplay() {
        return this.mHmdManager.getHeadMountedDisplay();
    }

    public void setRestoreGLStateEnabled(boolean enabled) {
        this.mRestoreGLStateEnabled = enabled;
        this.mRendererHelper.setRestoreGLStateEnabled(enabled);
    }

    public boolean getRestoreGLStateEnabled() {
        return this.mRestoreGLStateEnabled;
    }

    public void setChromaticAberrationCorrectionEnabled(boolean enabled) {
        this.mChromaticAberrationCorrectionEnabled = enabled;
        this.mRendererHelper.setChromaticAberrationCorrectionEnabled(enabled);
    }

    public boolean getChromaticAberrationCorrectionEnabled() {
        return this.mChromaticAberrationCorrectionEnabled;
    }

    public void setVignetteEnabled(boolean enabled) {
        this.mVignetteEnabled = enabled;
        this.mRendererHelper.setVignetteEnabled(enabled);
    }

    public boolean getVignetteEnabled() {
        return this.mVignetteEnabled;
    }

    public void setNeckModelEnabled(boolean enabled) {
        this.mHeadTracker.setNeckModelEnabled(enabled);
    }

    public void updateCardboardDeviceParams(CardboardDeviceParams cardboardDeviceParams) {
        if (this.mHmdManager.updateCardboardDeviceParams(cardboardDeviceParams)) {
            this.mRendererHelper.setCardboardDeviceParams(this.getCardboardDeviceParams());
        }
    }

    public CardboardDeviceParams getCardboardDeviceParams() {
        return this.mHmdManager.getHeadMountedDisplay().getCardboardDeviceParams();
    }

    public void updateScreenParams(ScreenParams screenParams) {
        if (this.mHmdManager.updateScreenParams(screenParams)) {
            this.mRendererHelper.setScreenParams(this.getScreenParams());
        }
    }

    public ScreenParams getScreenParams() {
        return this.mHmdManager.getHeadMountedDisplay().getScreenParams();
    }

    public float getInterpupillaryDistance() {
        return this.getCardboardDeviceParams().getInterLensDistance();
    }

    public void setDistortionCorrectionEnabled(boolean enabled) {
        this.mDistortionCorrectionEnabled = enabled;
        this.mRendererHelper.setDistortionCorrectionEnabled(enabled);
    }

    public boolean getDistortionCorrectionEnabled() {
        return this.mDistortionCorrectionEnabled;
    }

    public void setDistortionCorrectionTextureFormat(int textureFormat, int textureType) {
        this.mRendererHelper.setDistortionCorrectionTextureFormat(textureFormat, textureType);
    }

    public void undistortTexture(int inputTexture) {
        this.mRendererHelper.undistortTexture(inputTexture);
    }

    public void renderUiLayer() {
        this.mRendererHelper.renderUiLayer();
    }

    public void setDistortionCorrectionScale(float scale) {
        this.mRendererHelper.setDistortionCorrectionScale(scale);
    }

    public void onResume() {
        Phone.PhoneParams phoneParams;
        this.mHmdManager.onResume();
        this.mRendererHelper.setCardboardDeviceParams(this.getCardboardDeviceParams());
        if (this.mRendererSet) {
            super.onResume();
        }
        if ((phoneParams = PhoneParams.readFromExternalStorage()) != null) {
            this.mHeadTracker.setGyroBias(phoneParams.gyroBias);
        }
        this.mHeadTracker.startTracking();
    }

    public void onPause() {
        this.mHmdManager.onPause();
        if (this.mRendererSet) {
            super.onPause();
        }
        this.mHeadTracker.stopTracking();
    }

    public void queueEvent(Runnable r) {
        if (!this.mRendererSet) {
            r.run();
            return;
        }
        super.queueEvent(r);
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        throw new RuntimeException("Please use the CardboardView renderer interfaces");
    }

    public void onDetachedFromWindow() {
        if (this.mRendererSet && this.mShutdownLatch == null) {
            this.mShutdownLatch = new CountDownLatch(1);
            this.mRendererHelper.shutdown();
            try {
                this.mShutdownLatch.await();
            }
            catch (InterruptedException e) {
                String string = String.valueOf(e.toString());
                Log.e((String)TAG, (String)(string.length() != 0 ? "Interrupted during shutdown: ".concat(string) : new String("Interrupted during shutdown: ")));
            }
            this.mShutdownLatch = null;
        }
        super.onDetachedFromWindow();
    }

    private void init(Context context) {
        this.setEGLContextClientVersion(2);
        this.setPreserveEGLContextOnPause(true);
        this.mHeadTracker = HeadTracker.createFromContext(context);
        this.mHmdManager = new HeadMountedDisplayManager(context);
        this.mRendererHelper = new RendererHelper();
        this.mUiLayer = new UiLayer(context);
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.mUiLayer.onTouchEvent(e)) {
            return true;
        }
        return super.onTouchEvent(e);
    }

    private class StereoRendererHelper
    implements Renderer {
        private final StereoRenderer mStereoRenderer;
        private boolean mVRMode;

        public StereoRendererHelper(StereoRenderer stereoRenderer) {
            this.mStereoRenderer = stereoRenderer;
            this.mVRMode = CardboardView.this.mVRMode;
        }

        public void setVRModeEnabled(final boolean enabled) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    StereoRendererHelper.this.mVRMode = enabled;
                }
            });
        }

        @Override
        public void onDrawFrame(HeadTransform head, Eye leftEye, Eye rightEye) {
            this.mStereoRenderer.onNewFrame(head);
            GLES20.glEnable((int)3089);
            leftEye.getViewport().setGLViewport();
            leftEye.getViewport().setGLScissor();
            this.mStereoRenderer.onDrawEye(leftEye);
            if (rightEye == null) {
                return;
            }
            rightEye.getViewport().setGLViewport();
            rightEye.getViewport().setGLScissor();
            this.mStereoRenderer.onDrawEye(rightEye);
        }

        @Override
        public void onFinishFrame(Viewport viewport) {
            viewport.setGLViewport();
            viewport.setGLScissor();
            this.mStereoRenderer.onFinishFrame(viewport);
        }

        @Override
        public void onSurfaceChanged(int width, int height) {
            if (this.mVRMode) {
                this.mStereoRenderer.onSurfaceChanged(width / 2, height);
            } else {
                this.mStereoRenderer.onSurfaceChanged(width, height);
            }
        }

        @Override
        public void onSurfaceCreated(EGLConfig config) {
            this.mStereoRenderer.onSurfaceCreated(config);
        }

        @Override
        public void onRendererShutdown() {
            this.mStereoRenderer.onRendererShutdown();
        }
    }

    private class RendererHelper
    implements GLSurfaceView.Renderer {
        private final HeadTransform mHeadTransform;
        private final Eye mMonocular;
        private final Eye mLeftEye;
        private final Eye mRightEye;
        private final float[] mLeftEyeTranslate;
        private final float[] mRightEyeTranslate;
        private Renderer mRenderer;
        private boolean mSurfaceCreated;
        private HeadMountedDisplay mHmd;
        private DistortionRenderer mDistortionRenderer;
        private boolean mVRMode;
        private boolean mDistortionCorrectionEnabled;
        private boolean mProjectionChanged;
        private boolean mInvalidSurfaceSize;

        public RendererHelper() {
            this.mHmd = new HeadMountedDisplay(CardboardView.this.getHeadMountedDisplay());
            this.mHeadTransform = new HeadTransform();
            this.mMonocular = new Eye(0);
            this.mLeftEye = new Eye(1);
            this.mRightEye = new Eye(2);
            this.updateFieldOfView(this.mLeftEye.getFov(), this.mRightEye.getFov());
            this.mDistortionRenderer = new DistortionRenderer();
            this.mDistortionRenderer.setRestoreGLStateEnabled(CardboardView.this.mRestoreGLStateEnabled);
            this.mDistortionRenderer.setChromaticAberrationCorrectionEnabled(CardboardView.this.mChromaticAberrationCorrectionEnabled);
            this.mDistortionRenderer.setVignetteEnabled(CardboardView.this.mVignetteEnabled);
            this.mLeftEyeTranslate = new float[16];
            this.mRightEyeTranslate = new float[16];
            this.mVRMode = CardboardView.this.mVRMode;
            this.mDistortionCorrectionEnabled = CardboardView.this.mDistortionCorrectionEnabled;
            this.mProjectionChanged = true;
        }

        public void setRenderer(Renderer renderer) {
            this.mRenderer = renderer;
        }

        public void shutdown() {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (RendererHelper.this.mRenderer != null && RendererHelper.this.mSurfaceCreated) {
                        RendererHelper.this.mSurfaceCreated = false;
                        RendererHelper.this.mRenderer.onRendererShutdown();
                    }
                    CardboardView.this.mShutdownLatch.countDown();
                }
            });
        }

        public void setCardboardDeviceParams(CardboardDeviceParams newParams) {
            final CardboardDeviceParams deviceParams = new CardboardDeviceParams(newParams);
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mHmd.setCardboardDeviceParams(deviceParams);
                    RendererHelper.this.mProjectionChanged = true;
                }
            });
        }

        public void setScreenParams(ScreenParams newParams) {
            final ScreenParams screenParams = new ScreenParams(newParams);
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mHmd.setScreenParams(screenParams);
                    RendererHelper.this.mProjectionChanged = true;
                }
            });
        }

        public void setDistortionCorrectionEnabled(final boolean enabled) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionCorrectionEnabled = enabled;
                    RendererHelper.this.mProjectionChanged = true;
                }
            });
        }

        public void setDistortionCorrectionScale(final float scale) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionRenderer.setResolutionScale(scale);
                }
            });
        }

        public void setVRModeEnabled(final boolean enabled) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (RendererHelper.this.mVRMode == enabled) {
                        return;
                    }
                    RendererHelper.this.mVRMode = enabled;
                    if (RendererHelper.this.mRenderer instanceof StereoRendererHelper) {
                        StereoRendererHelper stereoHelper = (StereoRendererHelper)RendererHelper.this.mRenderer;
                        stereoHelper.setVRModeEnabled(enabled);
                    }
                    RendererHelper.this.mProjectionChanged = true;
                    RendererHelper.this.onSurfaceChanged(null, RendererHelper.this.mHmd.getScreenParams().getWidth(), RendererHelper.this.mHmd.getScreenParams().getHeight());
                }
            });
        }

        public void setRestoreGLStateEnabled(final boolean enabled) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionRenderer.setRestoreGLStateEnabled(enabled);
                }
            });
        }

        public void setChromaticAberrationCorrectionEnabled(final boolean enabled) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionRenderer.setChromaticAberrationCorrectionEnabled(enabled);
                }
            });
        }

        public void setVignetteEnabled(final boolean enabled) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionRenderer.setVignetteEnabled(enabled);
                    RendererHelper.this.mProjectionChanged = true;
                }
            });
        }

        public void setDistortionCorrectionTextureFormat(final int textureFormat, final int textureType) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionRenderer.setTextureFormat(textureFormat, textureType);
                }
            });
        }

        public void undistortTexture(final int inputTexture) {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.mDistortionRenderer.undistortTexture(inputTexture);
                }
            });
        }

        public void renderUiLayer() {
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CardboardView.this.mUiLayer.draw();
                }
            });
        }

        public void getCurrentEyeParams(final HeadTransform head, final Eye leftEye, final Eye rightEye, final Eye monocular) {
            final CountDownLatch finished = new CountDownLatch(1);
            CardboardView.this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    RendererHelper.this.getFrameParams(head, leftEye, rightEye, monocular);
                    finished.countDown();
                }
            });
            try {
                finished.await();
            }
            catch (InterruptedException e) {
                String string = String.valueOf(e.toString());
                Log.e((String)CardboardView.TAG, (String)(string.length() != 0 ? "Interrupted while reading frame params: ".concat(string) : new String("Interrupted while reading frame params: ")));
            }
        }

        private void getFrameParams(HeadTransform head, Eye leftEye, Eye rightEye, Eye monocular) {
            CardboardDeviceParams cdp = this.mHmd.getCardboardDeviceParams();
            ScreenParams screen = this.mHmd.getScreenParams();
            CardboardView.this.mHeadTracker.getLastHeadView(head.getHeadView(), 0);
            float halfInterpupillaryDistance = cdp.getInterLensDistance() * 0.5f;
            if (this.mVRMode) {
                Matrix.setIdentityM((float[])this.mLeftEyeTranslate, (int)0);
                Matrix.setIdentityM((float[])this.mRightEyeTranslate, (int)0);
                Matrix.translateM((float[])this.mLeftEyeTranslate, (int)0, (float)halfInterpupillaryDistance, (float)0.0f, (float)0.0f);
                Matrix.translateM((float[])this.mRightEyeTranslate, (int)0, (float)(-halfInterpupillaryDistance), (float)0.0f, (float)0.0f);
                Matrix.multiplyMM((float[])leftEye.getEyeView(), (int)0, (float[])this.mLeftEyeTranslate, (int)0, (float[])head.getHeadView(), (int)0);
                Matrix.multiplyMM((float[])rightEye.getEyeView(), (int)0, (float[])this.mRightEyeTranslate, (int)0, (float[])head.getHeadView(), (int)0);
            } else {
                System.arraycopy(head.getHeadView(), 0, monocular.getEyeView(), 0, head.getHeadView().length);
            }
            if (this.mProjectionChanged) {
                monocular.getViewport().setViewport(0, 0, screen.getWidth(), screen.getHeight());
                CardboardView.this.mUiLayer.updateViewport(monocular.getViewport());
                if (!this.mVRMode) {
                    this.updateMonocularFieldOfView(monocular.getFov());
                } else if (this.mDistortionCorrectionEnabled) {
                    this.updateFieldOfView(leftEye.getFov(), rightEye.getFov());
                    this.mDistortionRenderer.onFovChanged(this.mHmd, leftEye.getFov(), rightEye.getFov(), this.getVirtualEyeToScreenDistance());
                } else {
                    this.updateUndistortedFovAndViewport();
                }
                leftEye.setProjectionChanged();
                rightEye.setProjectionChanged();
                monocular.setProjectionChanged();
                this.mProjectionChanged = false;
            }
            if (this.mDistortionCorrectionEnabled && this.mDistortionRenderer.haveViewportsChanged()) {
                this.mDistortionRenderer.updateViewports(leftEye.getViewport(), rightEye.getViewport());
            }
        }

        public void onDrawFrame(GL10 gl) {
            if (this.mRenderer == null || !this.mSurfaceCreated || this.mInvalidSurfaceSize) {
                return;
            }
            this.getFrameParams(this.mHeadTransform, this.mLeftEye, this.mRightEye, this.mMonocular);
            if (this.mVRMode) {
                if (this.mDistortionCorrectionEnabled) {
                    this.mDistortionRenderer.beforeDrawFrame();
                    this.mRenderer.onDrawFrame(this.mHeadTransform, this.mLeftEye, this.mRightEye);
                    this.mDistortionRenderer.afterDrawFrame();
                } else {
                    this.mRenderer.onDrawFrame(this.mHeadTransform, this.mLeftEye, this.mRightEye);
                }
            } else {
                this.mRenderer.onDrawFrame(this.mHeadTransform, this.mMonocular, null);
            }
            this.mRenderer.onFinishFrame(this.mMonocular.getViewport());
            if (this.mVRMode) {
                CardboardView.this.mUiLayer.draw();
            }
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            if (this.mRenderer == null || !this.mSurfaceCreated) {
                return;
            }
            ScreenParams screen = this.mHmd.getScreenParams();
            if (width != screen.getWidth() || height != screen.getHeight()) {
                if (!this.mInvalidSurfaceSize) {
                    GLES20.glClear((int)16384);
                    int n = width;
                    int n2 = height;
                    int n3 = screen.getWidth();
                    int n4 = screen.getHeight();
                    Log.w((String)CardboardView.TAG, (String)new StringBuilder(124).append("Surface size ").append(n).append("x").append(n2).append(" does not match the expected screen size ").append(n3).append("x").append(n4).append(". Rendering is disabled.").toString());
                }
                this.mInvalidSurfaceSize = true;
            } else {
                this.mInvalidSurfaceSize = false;
            }
            this.mRenderer.onSurfaceChanged(width, height);
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            if (this.mRenderer == null) {
                return;
            }
            this.mSurfaceCreated = true;
            this.mRenderer.onSurfaceCreated(config);
            CardboardView.this.mUiLayer.initializeGl();
        }

        private void updateFieldOfView(FieldOfView leftEyeFov, FieldOfView rightEyeFov) {
            CardboardDeviceParams cdp = this.mHmd.getCardboardDeviceParams();
            ScreenParams screen = this.mHmd.getScreenParams();
            Distortion distortion = cdp.getDistortion();
            float eyeToScreenDist = this.getVirtualEyeToScreenDistance();
            float outerDist = (screen.getWidthMeters() - cdp.getInterLensDistance()) / 2.0f;
            float innerDist = cdp.getInterLensDistance() / 2.0f;
            float bottomDist = cdp.getVerticalDistanceToLensCenter() - screen.getBorderSizeMeters();
            float topDist = screen.getHeightMeters() + screen.getBorderSizeMeters() - cdp.getVerticalDistanceToLensCenter();
            float outerAngle = (float)Math.toDegrees(Math.atan(distortion.distort(outerDist / eyeToScreenDist)));
            float innerAngle = (float)Math.toDegrees(Math.atan(distortion.distort(innerDist / eyeToScreenDist)));
            float bottomAngle = (float)Math.toDegrees(Math.atan(distortion.distort(bottomDist / eyeToScreenDist)));
            float topAngle = (float)Math.toDegrees(Math.atan(distortion.distort(topDist / eyeToScreenDist)));
            leftEyeFov.setLeft(Math.min(outerAngle, cdp.getLeftEyeMaxFov().getLeft()));
            leftEyeFov.setRight(Math.min(innerAngle, cdp.getLeftEyeMaxFov().getRight()));
            leftEyeFov.setBottom(Math.min(bottomAngle, cdp.getLeftEyeMaxFov().getBottom()));
            leftEyeFov.setTop(Math.min(topAngle, cdp.getLeftEyeMaxFov().getTop()));
            rightEyeFov.setLeft(leftEyeFov.getRight());
            rightEyeFov.setRight(leftEyeFov.getLeft());
            rightEyeFov.setBottom(leftEyeFov.getBottom());
            rightEyeFov.setTop(leftEyeFov.getTop());
        }

        private void updateMonocularFieldOfView(FieldOfView monocularFov) {
            ScreenParams screen = this.mHmd.getScreenParams();
            float monocularBottomFov = 22.5f;
            float monocularLeftFov = (float)Math.toDegrees(Math.atan(Math.tan(Math.toRadians(monocularBottomFov)) * (double)screen.getWidthMeters() / (double)screen.getHeightMeters()));
            monocularFov.setLeft(monocularLeftFov);
            monocularFov.setRight(monocularLeftFov);
            monocularFov.setBottom(monocularBottomFov);
            monocularFov.setTop(monocularBottomFov);
        }

        private void updateUndistortedFovAndViewport() {
            ScreenParams screen = this.mHmd.getScreenParams();
            CardboardDeviceParams cdp = this.mHmd.getCardboardDeviceParams();
            float halfLensDistance = cdp.getInterLensDistance() / 2.0f;
            float eyeToScreen = this.getVirtualEyeToScreenDistance();
            float left = screen.getWidthMeters() / 2.0f - halfLensDistance;
            float right = halfLensDistance;
            float bottom = cdp.getVerticalDistanceToLensCenter() - screen.getBorderSizeMeters();
            float top = screen.getBorderSizeMeters() + screen.getHeightMeters() - cdp.getVerticalDistanceToLensCenter();
            FieldOfView leftEyeFov = this.mLeftEye.getFov();
            leftEyeFov.setLeft((float)Math.toDegrees(Math.atan2(left, eyeToScreen)));
            leftEyeFov.setRight((float)Math.toDegrees(Math.atan2(right, eyeToScreen)));
            leftEyeFov.setBottom((float)Math.toDegrees(Math.atan2(bottom, eyeToScreen)));
            leftEyeFov.setTop((float)Math.toDegrees(Math.atan2(top, eyeToScreen)));
            FieldOfView rightEyeFov = this.mRightEye.getFov();
            rightEyeFov.setLeft(leftEyeFov.getRight());
            rightEyeFov.setRight(leftEyeFov.getLeft());
            rightEyeFov.setBottom(leftEyeFov.getBottom());
            rightEyeFov.setTop(leftEyeFov.getTop());
            this.mLeftEye.getViewport().setViewport(0, 0, screen.getWidth() / 2, screen.getHeight());
            this.mRightEye.getViewport().setViewport(screen.getWidth() / 2, 0, screen.getWidth() / 2, screen.getHeight());
        }

        private float getVirtualEyeToScreenDistance() {
            return this.mHmd.getCardboardDeviceParams().getScreenToLensDistance();
        }
    }

    public static interface StereoRenderer {
        public void onNewFrame(HeadTransform var1);

        public void onDrawEye(Eye var1);

        public void onFinishFrame(Viewport var1);

        public void onSurfaceChanged(int var1, int var2);

        public void onSurfaceCreated(EGLConfig var1);

        public void onRendererShutdown();
    }

    public static interface Renderer {
        public void onDrawFrame(HeadTransform var1, Eye var2, Eye var3);

        public void onFinishFrame(Viewport var1);

        public void onSurfaceChanged(int var1, int var2);

        public void onSurfaceCreated(EGLConfig var1);

        public void onRendererShutdown();
    }
}

