/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import java.util.Arrays;

public class Distortion {
    private static final float[] DEFAULT_COEFFICIENTS = new float[]{0.441f, 0.156f};
    private float[] mCoefficients;

    public Distortion() {
        this.mCoefficients = (float[])DEFAULT_COEFFICIENTS.clone();
    }

    public Distortion(Distortion other) {
        this.setCoefficients(other.mCoefficients);
    }

    public static Distortion parseFromProtobuf(float[] coefficients) {
        Distortion distortion = new Distortion();
        distortion.setCoefficients(coefficients);
        return distortion;
    }

    public float[] toProtobuf() {
        return (float[])this.mCoefficients.clone();
    }

    public void setCoefficients(float[] coefficients) {
        this.mCoefficients = coefficients != null ? (float[])coefficients.clone() : new float[]{};
    }

    public float[] getCoefficients() {
        return this.mCoefficients;
    }

    public float distortionFactor(float radius) {
        float result = 1.0f;
        float rFactor = 1.0f;
        float rSquared = radius * radius;
        for (float ki : this.mCoefficients) {
            result += ki * (rFactor *= rSquared);
        }
        return result;
    }

    public float distort(float radius) {
        return radius * this.distortionFactor(radius);
    }

    public float distortInverse(float radius) {
        float r0 = radius / 0.9f;
        float r1 = radius * 0.9f;
        float dr0 = radius - this.distort(r0);
        while ((double)Math.abs(r1 - r0) > 1.0E-4) {
            float dr1 = radius - this.distort(r1);
            float r2 = r1 - dr1 * ((r1 - r0) / (dr1 - dr0));
            r0 = r1;
            r1 = r2;
            dr0 = dr1;
        }
        return r1;
    }

    private static double[] solveLeastSquares(double[][] matA, double[] vecY) {
        int j;
        int numSamples = matA.length;
        int numCoefficients = matA[0].length;
        double[][] matATA = new double[numCoefficients][numCoefficients];
        for (int k = 0; k < numCoefficients; ++k) {
            for (j = 0; j < numCoefficients; ++j) {
                double sum = 0.0;
                for (int i = 0; i < numSamples; ++i) {
                    sum += matA[i][j] * matA[i][k];
                }
                matATA[j][k] = sum;
            }
        }
        double[][] matInvATA = new double[numCoefficients][numCoefficients];
        if (numCoefficients != 2) {
            j = numCoefficients;
            throw new RuntimeException(new StringBuilder(78).append("solveLeastSquares: only 2 coefficients currently supported, ").append(j).append(" given.").toString());
        }
        double det = matATA[0][0] * matATA[1][1] - matATA[0][1] * matATA[1][0];
        matInvATA[0][0] = matATA[1][1] / det;
        matInvATA[1][1] = matATA[0][0] / det;
        matInvATA[0][1] = -matATA[1][0] / det;
        matInvATA[1][0] = -matATA[0][1] / det;
        double[] vecATY = new double[numCoefficients];
        for (int j2 = 0; j2 < numCoefficients; ++j2) {
            double sum = 0.0;
            for (int i = 0; i < numSamples; ++i) {
                sum += matA[i][j2] * vecY[i];
            }
            vecATY[j2] = sum;
        }
        double[] vecX = new double[numCoefficients];
        for (int j3 = 0; j3 < numCoefficients; ++j3) {
            double sum = 0.0;
            for (int i = 0; i < numCoefficients; ++i) {
                sum += matInvATA[i][j3] * vecATY[i];
            }
            vecX[j3] = sum;
        }
        return vecX;
    }

    public Distortion getApproximateInverseDistortion(float maxRadius) {
        int numSamples = 10;
        int numCoefficients = 2;
        double[][] matA = new double[10][2];
        double[] vecY = new double[10];
        for (int i = 0; i < 10; ++i) {
            double rp;
            float r = maxRadius * (float)(i + 1) / 10.0f;
            double v = rp = (double)this.distort(r);
            for (int j = 0; j < 2; ++j) {
                matA[i][j] = v *= rp * rp;
            }
            vecY[i] = (double)r - rp;
        }
        double[] vecK = Distortion.solveLeastSquares(matA, vecY);
        float[] coefficients = new float[vecK.length];
        for (int i = 0; i < vecK.length; ++i) {
            coefficients[i] = (float)vecK[i];
        }
        Distortion inverse = new Distortion();
        inverse.setCoefficients(coefficients);
        return inverse;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Distortion)) {
            return false;
        }
        Distortion o = (Distortion)other;
        return Arrays.equals(this.mCoefficients, o.mCoefficients);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("{\n").append("  coefficients: [");
        for (int i = 0; i < this.mCoefficients.length; ++i) {
            builder.append(Float.toString(this.mCoefficients[i]));
            if (i >= this.mCoefficients.length - 1) continue;
            builder.append(", ");
        }
        builder.append("],\n}");
        return builder.toString();
    }
}

