/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.opengl.GLES20;
import android.util.Log;
import com.google.vrtoolkit.cardboard.CardboardDeviceParams;
import com.google.vrtoolkit.cardboard.Distortion;
import com.google.vrtoolkit.cardboard.FieldOfView;
import com.google.vrtoolkit.cardboard.GLStateBackup;
import com.google.vrtoolkit.cardboard.HeadMountedDisplay;
import com.google.vrtoolkit.cardboard.ScreenParams;
import com.google.vrtoolkit.cardboard.Viewport;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class DistortionRenderer {
    private static final String TAG = "DistortionRenderer";
    private int mTextureId = -1;
    private int mRenderbufferId = -1;
    private int mFramebufferId = -1;
    private IntBuffer mOriginalFramebufferId = IntBuffer.allocate(1);
    private int mTextureFormat = 6407;
    private int mTextureType = 5121;
    private float mResolutionScale = 1.0f;
    private boolean mRestoreGLStateEnabled;
    private boolean mChromaticAberrationCorrectionEnabled;
    private boolean mVignetteEnabled;
    private DistortionMesh mLeftEyeDistortionMesh;
    private DistortionMesh mRightEyeDistortionMesh;
    private GLStateBackup mGLStateBackup = new GLStateBackup();
    private GLStateBackup mGLStateBackupAberration = new GLStateBackup();
    private HeadMountedDisplay mHmd;
    private EyeViewport mLeftEyeViewport;
    private EyeViewport mRightEyeViewport;
    private boolean mFovsChanged;
    private boolean mViewportsChanged;
    private boolean mTextureFormatChanged;
    private boolean mDrawingFrame;
    private float mXPxPerTanAngle;
    private float mYPxPerTanAngle;
    private float mMetersPerTanAngle;
    private ProgramHolder mProgramHolder;
    private ProgramHolderAberration mProgramHolderAberration;
    static final String VERTEX_SHADER = "attribute vec2 aPosition;\nattribute float aVignette;\nattribute vec2 aBlueTextureCoord;\nvarying vec2 vTextureCoord;\nvarying float vVignette;\nuniform float uTextureCoordScale;\nvoid main() {\n    gl_Position = vec4(aPosition, 0.0, 1.0);\n    vTextureCoord = aBlueTextureCoord.xy * uTextureCoordScale;\n    vVignette = aVignette;\n}\n";
    static final String FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nvarying float vVignette;\nuniform sampler2D uTextureSampler;\nvoid main() {\n    gl_FragColor = vVignette * texture2D(uTextureSampler, vTextureCoord);\n}\n";
    static final String VERTEX_SHADER_ABERRATION = "attribute vec2 aPosition;\nattribute float aVignette;\nattribute vec2 aRedTextureCoord;\nattribute vec2 aGreenTextureCoord;\nattribute vec2 aBlueTextureCoord;\nvarying vec2 vRedTextureCoord;\nvarying vec2 vBlueTextureCoord;\nvarying vec2 vGreenTextureCoord;\nvarying float vVignette;\nuniform float uTextureCoordScale;\nvoid main() {\n    gl_Position = vec4(aPosition, 0.0, 1.0);\n    vRedTextureCoord = aRedTextureCoord.xy * uTextureCoordScale;\n    vGreenTextureCoord = aGreenTextureCoord.xy * uTextureCoordScale;\n    vBlueTextureCoord = aBlueTextureCoord.xy * uTextureCoordScale;\n    vVignette = aVignette;\n}\n";
    static final String FRAGMENT_SHADER_ABERRATION = "precision mediump float;\nvarying vec2 vRedTextureCoord;\nvarying vec2 vBlueTextureCoord;\nvarying vec2 vGreenTextureCoord;\nvarying float vVignette;\nuniform sampler2D uTextureSampler;\nvoid main() {\n    gl_FragColor = vVignette * vec4(texture2D(uTextureSampler, vRedTextureCoord).r,\n                    texture2D(uTextureSampler, vGreenTextureCoord).g,\n                    texture2D(uTextureSampler, vBlueTextureCoord).b, 1.0);\n}\n";

    public void setTextureFormat(int textureFormat, int textureType) {
        if (this.mDrawingFrame) {
            throw new IllegalStateException("Cannot change texture format during rendering.");
        }
        if (textureFormat != this.mTextureFormat || textureType != this.mTextureType) {
            this.mTextureFormat = textureFormat;
            this.mTextureType = textureType;
            this.mTextureFormatChanged = true;
        }
    }

    public void beforeDrawFrame() {
        this.mDrawingFrame = true;
        if (this.mFovsChanged || this.mTextureFormatChanged) {
            this.updateTextureAndDistortionMesh();
        }
        GLES20.glGetIntegerv((int)36006, (IntBuffer)this.mOriginalFramebufferId);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFramebufferId);
    }

    public void afterDrawFrame() {
        GLES20.glBindFramebuffer((int)36160, (int)this.mOriginalFramebufferId.array()[0]);
        this.undistortTexture(this.mTextureId);
        this.mDrawingFrame = false;
    }

    public void undistortTexture(int textureId) {
        if (this.mRestoreGLStateEnabled) {
            if (this.mChromaticAberrationCorrectionEnabled) {
                this.mGLStateBackupAberration.readFromGL();
            } else {
                this.mGLStateBackup.readFromGL();
            }
        }
        if (this.mFovsChanged || this.mTextureFormatChanged) {
            this.updateTextureAndDistortionMesh();
        }
        GLES20.glViewport((int)0, (int)0, (int)this.mHmd.getScreenParams().getWidth(), (int)this.mHmd.getScreenParams().getHeight());
        GLES20.glDisable((int)3089);
        GLES20.glDisable((int)2884);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        if (this.mChromaticAberrationCorrectionEnabled) {
            GLES20.glUseProgram((int)this.mProgramHolderAberration.program);
        } else {
            GLES20.glUseProgram((int)this.mProgramHolder.program);
        }
        GLES20.glEnable((int)3089);
        GLES20.glScissor((int)0, (int)0, (int)(this.mHmd.getScreenParams().getWidth() / 2), (int)this.mHmd.getScreenParams().getHeight());
        this.renderDistortionMesh(this.mLeftEyeDistortionMesh, textureId);
        GLES20.glScissor((int)(this.mHmd.getScreenParams().getWidth() / 2), (int)0, (int)(this.mHmd.getScreenParams().getWidth() / 2), (int)this.mHmd.getScreenParams().getHeight());
        this.renderDistortionMesh(this.mRightEyeDistortionMesh, textureId);
        if (this.mRestoreGLStateEnabled) {
            if (this.mChromaticAberrationCorrectionEnabled) {
                this.mGLStateBackupAberration.writeToGL();
            } else {
                this.mGLStateBackup.writeToGL();
            }
        }
    }

    public void setResolutionScale(float scale) {
        this.mResolutionScale = scale;
        this.mViewportsChanged = true;
    }

    public void setRestoreGLStateEnabled(boolean enabled) {
        this.mRestoreGLStateEnabled = enabled;
    }

    public void setChromaticAberrationCorrectionEnabled(boolean enabled) {
        this.mChromaticAberrationCorrectionEnabled = enabled;
    }

    public void setVignetteEnabled(boolean enabled) {
        this.mVignetteEnabled = enabled;
        this.mFovsChanged = true;
    }

    public void onFovChanged(HeadMountedDisplay hmd, FieldOfView leftFov, FieldOfView rightFov, float virtualEyeToScreenDistance) {
        if (this.mDrawingFrame) {
            throw new IllegalStateException("Cannot change FOV while rendering a frame.");
        }
        this.mHmd = new HeadMountedDisplay(hmd);
        this.mLeftEyeViewport = this.initViewportForEye(leftFov, 0.0f);
        this.mRightEyeViewport = this.initViewportForEye(rightFov, this.mLeftEyeViewport.width);
        this.mMetersPerTanAngle = virtualEyeToScreenDistance;
        ScreenParams screen = this.mHmd.getScreenParams();
        this.mXPxPerTanAngle = (float)screen.getWidth() / (screen.getWidthMeters() / this.mMetersPerTanAngle);
        this.mYPxPerTanAngle = (float)screen.getHeight() / (screen.getHeightMeters() / this.mMetersPerTanAngle);
        this.mFovsChanged = true;
        this.mViewportsChanged = true;
    }

    public boolean haveViewportsChanged() {
        return this.mViewportsChanged;
    }

    public void updateViewports(Viewport leftViewport, Viewport rightViewport) {
        leftViewport.setViewport(Math.round(this.mLeftEyeViewport.x * this.mXPxPerTanAngle * this.mResolutionScale), Math.round(this.mLeftEyeViewport.y * this.mYPxPerTanAngle * this.mResolutionScale), Math.round(this.mLeftEyeViewport.width * this.mXPxPerTanAngle * this.mResolutionScale), Math.round(this.mLeftEyeViewport.height * this.mYPxPerTanAngle * this.mResolutionScale));
        rightViewport.setViewport(Math.round(this.mRightEyeViewport.x * this.mXPxPerTanAngle * this.mResolutionScale), Math.round(this.mRightEyeViewport.y * this.mYPxPerTanAngle * this.mResolutionScale), Math.round(this.mRightEyeViewport.width * this.mXPxPerTanAngle * this.mResolutionScale), Math.round(this.mRightEyeViewport.height * this.mYPxPerTanAngle * this.mResolutionScale));
        this.mViewportsChanged = false;
    }

    private void updateTextureAndDistortionMesh() {
        ScreenParams screen = this.mHmd.getScreenParams();
        CardboardDeviceParams cdp = this.mHmd.getCardboardDeviceParams();
        if (this.mProgramHolder == null) {
            this.mProgramHolder = this.createProgramHolder();
        }
        if (this.mProgramHolderAberration == null) {
            this.mProgramHolderAberration = (ProgramHolderAberration)this.createProgramHolder(true);
        }
        float textureWidthTanAngle = this.mLeftEyeViewport.width + this.mRightEyeViewport.width;
        float textureHeightTanAngle = Math.max(this.mLeftEyeViewport.height, this.mRightEyeViewport.height);
        int[] maxTextureSize = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])maxTextureSize, (int)0);
        int textureWidthPx = Math.min(Math.round(textureWidthTanAngle * this.mXPxPerTanAngle), maxTextureSize[0]);
        int textureHeightPx = Math.min(Math.round(textureHeightTanAngle * this.mYPxPerTanAngle), maxTextureSize[0]);
        float xEyeOffsetTanAngleScreen = (screen.getWidthMeters() / 2.0f - cdp.getInterLensDistance() / 2.0f) / this.mMetersPerTanAngle;
        float yEyeOffsetTanAngleScreen = (cdp.getVerticalDistanceToLensCenter() - screen.getBorderSizeMeters()) / this.mMetersPerTanAngle;
        this.mLeftEyeDistortionMesh = this.createDistortionMesh(this.mLeftEyeViewport, textureWidthTanAngle, textureHeightTanAngle, xEyeOffsetTanAngleScreen, yEyeOffsetTanAngleScreen);
        xEyeOffsetTanAngleScreen = screen.getWidthMeters() / this.mMetersPerTanAngle - xEyeOffsetTanAngleScreen;
        this.mRightEyeDistortionMesh = this.createDistortionMesh(this.mRightEyeViewport, textureWidthTanAngle, textureHeightTanAngle, xEyeOffsetTanAngleScreen, yEyeOffsetTanAngleScreen);
        this.setupRenderTextureAndRenderbuffer(textureWidthPx, textureHeightPx);
        this.mFovsChanged = false;
    }

    private EyeViewport initViewportForEye(FieldOfView fov, float xOffset) {
        float left = (float)Math.tan(Math.toRadians(fov.getLeft()));
        float right = (float)Math.tan(Math.toRadians(fov.getRight()));
        float bottom = (float)Math.tan(Math.toRadians(fov.getBottom()));
        float top = (float)Math.tan(Math.toRadians(fov.getTop()));
        EyeViewport vp = new EyeViewport();
        vp.x = xOffset;
        vp.y = 0.0f;
        vp.width = left + right;
        vp.height = bottom + top;
        vp.eyeX = left + xOffset;
        vp.eyeY = bottom;
        return vp;
    }

    private DistortionMesh createDistortionMesh(EyeViewport eyeViewport, float textureWidthTanAngle, float textureHeightTanAngle, float xEyeOffsetTanAngleScreen, float yEyeOffsetTanAngleScreen) {
        return new DistortionMesh(this.mHmd.getCardboardDeviceParams().getDistortion(), this.mHmd.getCardboardDeviceParams().getDistortion(), this.mHmd.getCardboardDeviceParams().getDistortion(), this.mHmd.getScreenParams().getWidthMeters() / this.mMetersPerTanAngle, this.mHmd.getScreenParams().getHeightMeters() / this.mMetersPerTanAngle, xEyeOffsetTanAngleScreen, yEyeOffsetTanAngleScreen, textureWidthTanAngle, textureHeightTanAngle, eyeViewport.eyeX, eyeViewport.eyeY, eyeViewport.x, eyeViewport.y, eyeViewport.width, eyeViewport.height);
    }

    private void renderDistortionMesh(DistortionMesh mesh, int textureId) {
        ProgramHolder holder = this.mChromaticAberrationCorrectionEnabled ? this.mProgramHolderAberration : this.mProgramHolder;
        GLES20.glBindBuffer((int)34962, (int)mesh.mArrayBufferId);
        GLES20.glVertexAttribPointer((int)holder.aPosition, (int)2, (int)5126, (boolean)false, (int)36, (int)(0 * 4));
        GLES20.glEnableVertexAttribArray((int)holder.aPosition);
        GLES20.glVertexAttribPointer((int)holder.aVignette, (int)1, (int)5126, (boolean)false, (int)36, (int)(2 * 4));
        GLES20.glEnableVertexAttribArray((int)holder.aVignette);
        GLES20.glVertexAttribPointer((int)holder.aBlueTextureCoord, (int)2, (int)5126, (boolean)false, (int)36, (int)(7 * 4));
        GLES20.glEnableVertexAttribArray((int)holder.aBlueTextureCoord);
        if (this.mChromaticAberrationCorrectionEnabled) {
            GLES20.glVertexAttribPointer((int)holder.aRedTextureCoord, (int)2, (int)5126, (boolean)false, (int)36, (int)(3 * 4));
            GLES20.glEnableVertexAttribArray((int)holder.aRedTextureCoord);
            GLES20.glVertexAttribPointer((int)holder.aGreenTextureCoord, (int)2, (int)5126, (boolean)false, (int)36, (int)(5 * 4));
            GLES20.glEnableVertexAttribArray((int)holder.aGreenTextureCoord);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glUniform1i((int)this.mProgramHolder.uTextureSampler, (int)0);
        GLES20.glUniform1f((int)this.mProgramHolder.uTextureCoordScale, (float)this.mResolutionScale);
        GLES20.glBindBuffer((int)34963, (int)mesh.mElementBufferId);
        GLES20.glDrawElements((int)5, (int)mesh.nIndices, (int)5123, (int)0);
    }

    private float computeDistortionScale(Distortion distortion, float screenWidthM, float interpupillaryDistanceM) {
        return distortion.distortionFactor((screenWidthM / 2.0f - interpupillaryDistanceM / 2.0f) / (screenWidthM / 4.0f));
    }

    private int createTexture(int width, int height, int textureFormat, int textureType) {
        int[] textureIds = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureIds, (int)0);
        GLES20.glBindTexture((int)3553, (int)textureIds[0]);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexImage2D((int)3553, (int)0, (int)textureFormat, (int)width, (int)height, (int)0, (int)textureFormat, (int)textureType, null);
        return textureIds[0];
    }

    private int setupRenderTextureAndRenderbuffer(int width, int height) {
        if (this.mTextureId != -1) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
        }
        if (this.mRenderbufferId != -1) {
            GLES20.glDeleteRenderbuffers((int)1, (int[])new int[]{this.mRenderbufferId}, (int)0);
        }
        if (this.mFramebufferId != -1) {
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.mFramebufferId}, (int)0);
        }
        this.mTextureId = this.createTexture(width, height, this.mTextureFormat, this.mTextureType);
        this.mTextureFormatChanged = false;
        this.checkGlError("setupRenderTextureAndRenderbuffer: create texture");
        int[] renderbufferIds = new int[1];
        GLES20.glGenRenderbuffers((int)1, (int[])renderbufferIds, (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)renderbufferIds[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
        this.mRenderbufferId = renderbufferIds[0];
        this.checkGlError("setupRenderTextureAndRenderbuffer: create renderbuffer");
        int[] framebufferIds = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])framebufferIds, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)framebufferIds[0]);
        this.mFramebufferId = framebufferIds[0];
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mTextureId, (int)0);
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)renderbufferIds[0]);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            String string = String.valueOf(Integer.toHexString(status));
            throw new RuntimeException(string.length() != 0 ? "Framebuffer is not complete: ".concat(string) : new String("Framebuffer is not complete: "));
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return framebufferIds[0];
    }

    private int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                int n = shaderType;
                Log.e((String)TAG, (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)TAG, (String)GLES20.glGetShaderInfoLog((int)shader));
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    private int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = this.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertexShader);
            this.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)program, (int)pixelShader);
            this.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                Log.e((String)TAG, (String)"Could not link program: ");
                Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    private ProgramHolder createProgramHolder() {
        return this.createProgramHolder(false);
    }

    private ProgramHolder createProgramHolder(boolean aberrationCorrected) {
        GLStateBackup state;
        ProgramHolder holder;
        if (aberrationCorrected) {
            holder = new ProgramHolderAberration();
            holder.program = this.createProgram(VERTEX_SHADER_ABERRATION, FRAGMENT_SHADER_ABERRATION);
            if (holder.program == 0) {
                throw new RuntimeException("Could not create aberration-corrected program");
            }
            state = this.mGLStateBackupAberration;
        } else {
            holder = new ProgramHolder();
            holder.program = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
            if (holder.program == 0) {
                throw new RuntimeException("Could not create program");
            }
            state = this.mGLStateBackup;
        }
        holder.aPosition = GLES20.glGetAttribLocation((int)holder.program, (String)"aPosition");
        this.checkGlError("glGetAttribLocation aPosition");
        if (holder.aPosition == -1) {
            throw new RuntimeException("Could not get attrib location for aPosition");
        }
        state.addTrackedVertexAttribute(holder.aPosition);
        holder.aVignette = GLES20.glGetAttribLocation((int)holder.program, (String)"aVignette");
        this.checkGlError("glGetAttribLocation aVignette");
        if (holder.aVignette == -1) {
            throw new RuntimeException("Could not get attrib location for aVignette");
        }
        state.addTrackedVertexAttribute(holder.aVignette);
        if (aberrationCorrected) {
            holder.aRedTextureCoord = GLES20.glGetAttribLocation((int)holder.program, (String)"aRedTextureCoord");
            this.checkGlError("glGetAttribLocation aRedTextureCoord");
            if (holder.aRedTextureCoord == -1) {
                throw new RuntimeException("Could not get attrib location for aRedTextureCoord");
            }
            holder.aGreenTextureCoord = GLES20.glGetAttribLocation((int)holder.program, (String)"aGreenTextureCoord");
            this.checkGlError("glGetAttribLocation aGreenTextureCoord");
            if (holder.aGreenTextureCoord == -1) {
                throw new RuntimeException("Could not get attrib location for aGreenTextureCoord");
            }
            state.addTrackedVertexAttribute(holder.aRedTextureCoord);
            state.addTrackedVertexAttribute(holder.aGreenTextureCoord);
        }
        holder.aBlueTextureCoord = GLES20.glGetAttribLocation((int)holder.program, (String)"aBlueTextureCoord");
        this.checkGlError("glGetAttribLocation aBlueTextureCoord");
        if (holder.aBlueTextureCoord == -1) {
            throw new RuntimeException("Could not get attrib location for aBlueTextureCoord");
        }
        state.addTrackedVertexAttribute(holder.aBlueTextureCoord);
        holder.uTextureCoordScale = GLES20.glGetUniformLocation((int)holder.program, (String)"uTextureCoordScale");
        this.checkGlError("glGetUniformLocation uTextureCoordScale");
        if (holder.uTextureCoordScale == -1) {
            throw new RuntimeException("Could not get attrib location for uTextureCoordScale");
        }
        holder.uTextureSampler = GLES20.glGetUniformLocation((int)holder.program, (String)"uTextureSampler");
        this.checkGlError("glGetUniformLocation uTextureSampler");
        if (holder.uTextureSampler == -1) {
            throw new RuntimeException("Could not get attrib location for uTextureSampler");
        }
        return holder;
    }

    private void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String string = String.valueOf(String.valueOf(op));
            int n = error;
            Log.e((String)TAG, (String)new StringBuilder(21 + string.length()).append(string).append(": glError ").append(n).toString());
            String string2 = String.valueOf(String.valueOf(op));
            int n2 = error;
            throw new RuntimeException(new StringBuilder(21 + string2.length()).append(string2).append(": glError ").append(n2).toString());
        }
    }

    private static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    private class DistortionMesh {
        private static final String TAG = "DistortionMesh";
        public static final int BYTES_PER_FLOAT = 4;
        public static final int BYTES_PER_SHORT = 2;
        public static final int COMPONENTS_PER_VERT = 9;
        public static final int DATA_STRIDE_BYTES = 36;
        public static final int DATA_POS_OFFSET = 0;
        public static final int DATA_POS_COMPONENTS = 2;
        public static final int DATA_VIGNETTE_OFFSET = 2;
        public static final int DATA_VIGNETTE_COMPONENTS = 1;
        public static final int DATA_RUV_OFFSET = 3;
        public static final int DATA_GUV_OFFSET = 5;
        public static final int DATA_BUV_OFFSET = 7;
        public static final int DATA_UV_COMPONENTS = 2;
        public static final int ROWS = 40;
        public static final int COLS = 40;
        public static final float VIGNETTE_SIZE_TAN_ANGLE = 0.05f;
        public int nIndices;
        public int mArrayBufferId = -1;
        public int mElementBufferId = -1;

        public DistortionMesh(Distortion distortionRed, Distortion distortionGreen, Distortion distortionBlue, float screenWidth, float screenHeight, float xEyeOffsetScreen, float yEyeOffsetScreen, float textureWidth, float textureHeight, float xEyeOffsetTexture, float yEyeOffsetTexture, float viewportXTexture, float viewportYTexture, float viewportWidthTexture, float viewportHeightTexture) {
            float[] vertexData = new float[14400];
            int vertexOffset = 0;
            for (int row = 0; row < 40; ++row) {
                for (int col = 0; col < 40; ++col) {
                    float uTextureBlue = (float)col / 39.0f * (viewportWidthTexture / textureWidth) + viewportXTexture / textureWidth;
                    float xTexture = uTextureBlue * textureWidth - xEyeOffsetTexture;
                    float vTextureBlue = (float)row / 39.0f * (viewportHeightTexture / textureHeight) + viewportYTexture / textureHeight;
                    float yTexture = vTextureBlue * textureHeight - yEyeOffsetTexture;
                    float rTexture = (float)Math.sqrt(xTexture * xTexture + yTexture * yTexture);
                    float textureToScreenBlue = rTexture > 0.0f ? distortionBlue.distortInverse(rTexture) / rTexture : 1.0f;
                    float xScreen = xTexture * textureToScreenBlue;
                    float yScreen = yTexture * textureToScreenBlue;
                    float uScreen = (xScreen + xEyeOffsetScreen) / screenWidth;
                    float vScreen = (yScreen + yEyeOffsetScreen) / screenHeight;
                    float rScreen = rTexture * textureToScreenBlue;
                    float screenToTextureGreen = rScreen > 0.0f ? distortionGreen.distortionFactor(rScreen) : 1.0f;
                    float uTextureGreen = (xScreen * screenToTextureGreen + xEyeOffsetTexture) / textureWidth;
                    float vTextureGreen = (yScreen * screenToTextureGreen + yEyeOffsetTexture) / textureHeight;
                    float screenToTextureRed = rScreen > 0.0f ? distortionRed.distortionFactor(rScreen) : 1.0f;
                    float uTextureRed = (xScreen * screenToTextureRed + xEyeOffsetTexture) / textureWidth;
                    float vTextureRed = (yScreen * screenToTextureRed + yEyeOffsetTexture) / textureHeight;
                    float vignetteSizeTexture = 0.05f / textureToScreenBlue;
                    float dxTexture = xTexture + xEyeOffsetTexture - DistortionRenderer.clamp(xTexture + xEyeOffsetTexture, viewportXTexture + vignetteSizeTexture, viewportXTexture + viewportWidthTexture - vignetteSizeTexture);
                    float dyTexture = yTexture + yEyeOffsetTexture - DistortionRenderer.clamp(yTexture + yEyeOffsetTexture, viewportYTexture + vignetteSizeTexture, viewportYTexture + viewportHeightTexture - vignetteSizeTexture);
                    float drTexture = (float)Math.sqrt(dxTexture * dxTexture + dyTexture * dyTexture);
                    float vignette = DistortionRenderer.this.mVignetteEnabled ? 1.0f - DistortionRenderer.clamp(drTexture / vignetteSizeTexture, 0.0f, 1.0f) : 1.0f;
                    vertexData[vertexOffset + 0] = 2.0f * uScreen - 1.0f;
                    vertexData[vertexOffset + 1] = 2.0f * vScreen - 1.0f;
                    vertexData[vertexOffset + 2] = vignette;
                    vertexData[vertexOffset + 3] = uTextureRed;
                    vertexData[vertexOffset + 4] = vTextureRed;
                    vertexData[vertexOffset + 5] = uTextureGreen;
                    vertexData[vertexOffset + 6] = vTextureGreen;
                    vertexData[vertexOffset + 7] = uTextureBlue;
                    vertexData[vertexOffset + 8] = vTextureBlue;
                    vertexOffset = (short)(vertexOffset + 9);
                }
            }
            this.nIndices = 3158;
            short[] indexData = new short[this.nIndices];
            int indexOffset = 0;
            vertexOffset = 0;
            for (int row = 0; row < 39; ++row) {
                if (row > 0) {
                    indexData[indexOffset] = indexData[indexOffset - 1];
                    indexOffset = (short)(indexOffset + 1);
                }
                for (int col = 0; col < 40; ++col) {
                    if (col > 0) {
                        vertexOffset = row % 2 == 0 ? (int)((short)(vertexOffset + 1)) : (int)((short)(vertexOffset - 1));
                    }
                    int n = indexOffset;
                    indexOffset = (short)(indexOffset + 1);
                    indexData[n] = vertexOffset;
                    int n2 = indexOffset;
                    indexOffset = (short)(indexOffset + 1);
                    indexData[n2] = (short)(vertexOffset + 40);
                }
                vertexOffset = (short)(vertexOffset + 40);
            }
            FloatBuffer vertexBuffer = ByteBuffer.allocateDirect(vertexData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertexBuffer.put(vertexData).position(0);
            ShortBuffer indexBuffer = ByteBuffer.allocateDirect(indexData.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
            indexBuffer.put(indexData).position(0);
            int[] bufferIds = new int[2];
            GLES20.glGenBuffers((int)2, (int[])bufferIds, (int)0);
            this.mArrayBufferId = bufferIds[0];
            this.mElementBufferId = bufferIds[1];
            GLES20.glBindBuffer((int)34962, (int)this.mArrayBufferId);
            GLES20.glBufferData((int)34962, (int)(vertexData.length * 4), (Buffer)vertexBuffer, (int)35044);
            GLES20.glBindBuffer((int)34963, (int)this.mElementBufferId);
            GLES20.glBufferData((int)34963, (int)(indexData.length * 2), (Buffer)indexBuffer, (int)35044);
            GLES20.glBindBuffer((int)34962, (int)0);
            GLES20.glBindBuffer((int)34963, (int)0);
        }
    }

    private class EyeViewport {
        public float x;
        public float y;
        public float width;
        public float height;
        public float eyeX;
        public float eyeY;

        private EyeViewport() {
        }

        public String toString() {
            float f = this.x;
            float f2 = this.y;
            float f3 = this.width;
            float f4 = this.height;
            float f5 = this.eyeX;
            float f6 = this.eyeY;
            return "{\n" + new StringBuilder(22).append("  x: ").append(f).append(",\n").toString() + new StringBuilder(22).append("  y: ").append(f2).append(",\n").toString() + new StringBuilder(26).append("  width: ").append(f3).append(",\n").toString() + new StringBuilder(27).append("  height: ").append(f4).append(",\n").toString() + new StringBuilder(25).append("  eyeX: ").append(f5).append(",\n").toString() + new StringBuilder(25).append("  eyeY: ").append(f6).append(",\n").toString() + "}";
        }
    }

    private class ProgramHolderAberration
    extends ProgramHolder {
        public int aRedTextureCoord;
        public int aGreenTextureCoord;

        private ProgramHolderAberration() {
        }
    }

    private class ProgramHolder {
        public int program;
        public int aPosition;
        public int aVignette;
        public int aBlueTextureCoord;
        public int uTextureCoordScale;
        public int uTextureSampler;

        private ProgramHolder() {
        }
    }
}

