/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.opengl.Matrix;

public class FieldOfView {
    private static final float DEFAULT_MAX_FOV_LEFT_RIGHT = 40.0f;
    private static final float DEFAULT_MAX_FOV_BOTTOM = 40.0f;
    private static final float DEFAULT_MAX_FOV_TOP = 40.0f;
    private float mLeft;
    private float mRight;
    private float mBottom;
    private float mTop;

    public FieldOfView() {
        this.mLeft = 40.0f;
        this.mRight = 40.0f;
        this.mBottom = 40.0f;
        this.mTop = 40.0f;
    }

    public FieldOfView(float left, float right, float bottom, float top) {
        this.mLeft = left;
        this.mRight = right;
        this.mBottom = bottom;
        this.mTop = top;
    }

    public FieldOfView(FieldOfView other) {
        this.copy(other);
    }

    public static FieldOfView parseFromProtobuf(float[] angles) {
        if (angles.length != 4) {
            return null;
        }
        return new FieldOfView(angles[0], angles[1], angles[2], angles[3]);
    }

    public float[] toProtobuf() {
        return new float[]{this.mLeft, this.mRight, this.mBottom, this.mTop};
    }

    public void copy(FieldOfView other) {
        this.mLeft = other.mLeft;
        this.mRight = other.mRight;
        this.mBottom = other.mBottom;
        this.mTop = other.mTop;
    }

    public void setLeft(float left) {
        this.mLeft = left;
    }

    public float getLeft() {
        return this.mLeft;
    }

    public void setRight(float right) {
        this.mRight = right;
    }

    public float getRight() {
        return this.mRight;
    }

    public void setBottom(float bottom) {
        this.mBottom = bottom;
    }

    public float getBottom() {
        return this.mBottom;
    }

    public void setTop(float top) {
        this.mTop = top;
    }

    public float getTop() {
        return this.mTop;
    }

    public void toPerspectiveMatrix(float near, float far, float[] perspective, int offset) {
        if (offset + 16 > perspective.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        float l = (float)(-Math.tan(Math.toRadians(this.mLeft))) * near;
        float r = (float)Math.tan(Math.toRadians(this.mRight)) * near;
        float b = (float)(-Math.tan(Math.toRadians(this.mBottom))) * near;
        float t = (float)Math.tan(Math.toRadians(this.mTop)) * near;
        Matrix.frustumM((float[])perspective, (int)offset, (float)l, (float)r, (float)b, (float)t, (float)near, (float)far);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof FieldOfView)) {
            return false;
        }
        FieldOfView o = (FieldOfView)other;
        return this.mLeft == o.mLeft && this.mRight == o.mRight && this.mBottom == o.mBottom && this.mTop == o.mTop;
    }

    public String toString() {
        float f = this.mLeft;
        float f2 = this.mRight;
        float f3 = this.mBottom;
        float f4 = this.mTop;
        return "{\n" + new StringBuilder(25).append("  left: ").append(f).append(",\n").toString() + new StringBuilder(26).append("  right: ").append(f2).append(",\n").toString() + new StringBuilder(27).append("  bottom: ").append(f3).append(",\n").toString() + new StringBuilder(24).append("  top: ").append(f4).append(",\n").toString() + "}";
    }
}

