/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.opengl.GLES20;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;

class GLStateBackup {
    private boolean mCullFaceEnabled;
    private boolean mScissorTestEnabled;
    private boolean mDepthTestEnabled;
    private IntBuffer mViewport = IntBuffer.allocate(4);
    private IntBuffer mTexture2dId = IntBuffer.allocate(1);
    private IntBuffer mTextureUnit = IntBuffer.allocate(1);
    private IntBuffer mScissorBox = IntBuffer.allocate(4);
    private IntBuffer mShaderProgram = IntBuffer.allocate(1);
    private IntBuffer mArrayBufferBinding = IntBuffer.allocate(1);
    private IntBuffer mElementArrayBufferBinding = IntBuffer.allocate(1);
    private FloatBuffer mClearColor = FloatBuffer.allocate(4);
    private ArrayList<VertexAttributeState> mVertexAttributes = new ArrayList();

    GLStateBackup() {
    }

    void addTrackedVertexAttribute(int attributeId) {
        this.mVertexAttributes.add(new VertexAttributeState(attributeId));
    }

    void clearTrackedVertexAttributes() {
        this.mVertexAttributes.clear();
    }

    void readFromGL() {
        GLES20.glGetIntegerv((int)2978, (IntBuffer)this.mViewport);
        this.mCullFaceEnabled = GLES20.glIsEnabled((int)2884);
        this.mScissorTestEnabled = GLES20.glIsEnabled((int)3089);
        this.mDepthTestEnabled = GLES20.glIsEnabled((int)2929);
        GLES20.glGetFloatv((int)3106, (FloatBuffer)this.mClearColor);
        GLES20.glGetIntegerv((int)35725, (IntBuffer)this.mShaderProgram);
        GLES20.glGetIntegerv((int)3088, (IntBuffer)this.mScissorBox);
        GLES20.glGetIntegerv((int)34016, (IntBuffer)this.mTextureUnit);
        GLES20.glGetIntegerv((int)32873, (IntBuffer)this.mTexture2dId);
        GLES20.glGetIntegerv((int)34964, (IntBuffer)this.mArrayBufferBinding);
        GLES20.glGetIntegerv((int)34965, (IntBuffer)this.mElementArrayBufferBinding);
        for (VertexAttributeState vas : this.mVertexAttributes) {
            vas.readFromGL();
        }
    }

    void writeToGL() {
        for (VertexAttributeState vas : this.mVertexAttributes) {
            vas.writeToGL();
        }
        GLES20.glBindBuffer((int)34962, (int)this.mArrayBufferBinding.array()[0]);
        GLES20.glBindBuffer((int)34963, (int)this.mElementArrayBufferBinding.array()[0]);
        GLES20.glBindTexture((int)3553, (int)this.mTexture2dId.array()[0]);
        GLES20.glActiveTexture((int)this.mTextureUnit.array()[0]);
        GLES20.glScissor((int)this.mScissorBox.array()[0], (int)this.mScissorBox.array()[1], (int)this.mScissorBox.array()[2], (int)this.mScissorBox.array()[3]);
        GLES20.glUseProgram((int)this.mShaderProgram.array()[0]);
        GLES20.glClearColor((float)this.mClearColor.array()[0], (float)this.mClearColor.array()[1], (float)this.mClearColor.array()[2], (float)this.mClearColor.array()[3]);
        if (this.mCullFaceEnabled) {
            GLES20.glEnable((int)2884);
        } else {
            GLES20.glDisable((int)2884);
        }
        if (this.mScissorTestEnabled) {
            GLES20.glEnable((int)3089);
        } else {
            GLES20.glDisable((int)3089);
        }
        if (this.mDepthTestEnabled) {
            GLES20.glEnable((int)2929);
        } else {
            GLES20.glDisable((int)2929);
        }
        GLES20.glViewport((int)this.mViewport.array()[0], (int)this.mViewport.array()[1], (int)this.mViewport.array()[2], (int)this.mViewport.array()[3]);
    }

    private class VertexAttributeState {
        private int mAttributeId;
        private IntBuffer mEnabled = IntBuffer.allocate(1);

        VertexAttributeState(int attributeId) {
            this.mAttributeId = attributeId;
        }

        void readFromGL() {
            GLES20.glGetVertexAttribiv((int)this.mAttributeId, (int)34338, (IntBuffer)this.mEnabled);
        }

        void writeToGL() {
            if (this.mEnabled.array()[0] == 0) {
                GLES20.glDisableVertexAttribArray((int)this.mAttributeId);
            } else {
                GLES20.glEnableVertexAttribArray((int)this.mAttributeId);
            }
        }
    }
}

