/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.content.Context;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.vrtoolkit.cardboard.CardboardDeviceParams;
import com.google.vrtoolkit.cardboard.ConfigUtils;
import com.google.vrtoolkit.cardboard.HeadMountedDisplay;
import com.google.vrtoolkit.cardboard.ScreenParams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeadMountedDisplayManager {
    private static final String TAG = "HeadMountedDisplayManager";
    private final HeadMountedDisplay mHmd;
    private final Context mContext;

    public HeadMountedDisplayManager(Context context) {
        this.mContext = context;
        this.mHmd = new HeadMountedDisplay(this.createScreenParams(), this.createCardboardDeviceParams());
    }

    public HeadMountedDisplay getHeadMountedDisplay() {
        return this.mHmd;
    }

    public void onResume() {
        ScreenParams screenParams;
        CardboardDeviceParams deviceParams = this.createCardboardDeviceParamsFromExternalStorage();
        if (deviceParams != null && !deviceParams.equals(this.mHmd.getCardboardDeviceParams())) {
            this.mHmd.setCardboardDeviceParams(deviceParams);
            Log.i((String)TAG, (String)"Successfully read updated device params from external storage");
        }
        if ((screenParams = this.createScreenParamsFromExternalStorage(this.getDisplay())) != null && !screenParams.equals(this.mHmd.getScreenParams())) {
            this.mHmd.setScreenParams(screenParams);
            Log.i((String)TAG, (String)"Successfully read updated screen params from external storage");
        }
    }

    public void onPause() {
    }

    public boolean updateCardboardDeviceParams(CardboardDeviceParams cardboardDeviceParams) {
        if (cardboardDeviceParams == null || cardboardDeviceParams.equals(this.mHmd.getCardboardDeviceParams())) {
            return false;
        }
        this.mHmd.setCardboardDeviceParams(cardboardDeviceParams);
        this.writeCardboardParamsToExternalStorage();
        return true;
    }

    public boolean updateScreenParams(ScreenParams screenParams) {
        if (screenParams == null || screenParams.equals(this.mHmd.getScreenParams())) {
            return false;
        }
        this.mHmd.setScreenParams(screenParams);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCardboardParamsToExternalStorage() {
        boolean success = false;
        OutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(ConfigUtils.getConfigFile("current_device_params")));
            success = this.mHmd.getCardboardDeviceParams().writeToOutputStream(stream);
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        if (!success) {
            Log.e((String)TAG, (String)"Could not write Cardboard parameters to external storage.");
        } else {
            Log.i((String)TAG, (String)"Successfully wrote Cardboard parameters to external storage.");
        }
    }

    private Display getDisplay() {
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    private ScreenParams createScreenParams() {
        Display display = this.getDisplay();
        ScreenParams params = this.createScreenParamsFromExternalStorage(display);
        if (params != null) {
            Log.i((String)TAG, (String)"Successfully read screen params from external storage");
            return params;
        }
        return new ScreenParams(display);
    }

    private CardboardDeviceParams createCardboardDeviceParams() {
        CardboardDeviceParams params = this.createCardboardDeviceParamsFromExternalStorage();
        if (params != null) {
            Log.i((String)TAG, (String)"Successfully read device params from external storage");
            return params;
        }
        params = this.createCardboardDeviceParamsFromAssetFolder();
        if (params != null) {
            Log.i((String)TAG, (String)"Successfully read device params from asset folder");
            this.writeCardboardParamsToExternalStorage();
            return params;
        }
        return new CardboardDeviceParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardboardDeviceParams createCardboardDeviceParamsFromAssetFolder() {
        block8: {
            CardboardDeviceParams cardboardDeviceParams;
            block7: {
                InputStream stream = null;
                try {
                    stream = new BufferedInputStream(ConfigUtils.openAssetConfigFile(this.mContext.getAssets(), "current_device_params"));
                    cardboardDeviceParams = CardboardDeviceParams.createFromInputStream(stream);
                    if (stream == null) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        String string = String.valueOf(String.valueOf(e));
                        Log.d((String)TAG, (String)new StringBuilder(47 + string.length()).append("Bundled Cardboard device parameters not found: ").append(string).toString());
                        break block8;
                    }
                    catch (IOException e) {
                        String string = String.valueOf(String.valueOf(e));
                        Log.e((String)TAG, (String)new StringBuilder(43 + string.length()).append("Error reading config file in asset folder: ").append(string).toString());
                    }
                }
                stream.close();
            }
            return cardboardDeviceParams;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardboardDeviceParams createCardboardDeviceParamsFromExternalStorage() {
        CardboardDeviceParams cardboardDeviceParams;
        block10: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(ConfigUtils.getConfigFile("current_device_params")));
                cardboardDeviceParams = CardboardDeviceParams.createFromInputStream(stream);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    String string = String.valueOf(String.valueOf(e));
                    Log.d((String)TAG, (String)new StringBuilder(44 + string.length()).append("Cardboard device parameters file not found: ").append(string).toString());
                    return null;
                }
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cardboardDeviceParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScreenParams createScreenParamsFromExternalStorage(Display display) {
        ScreenParams screenParams;
        block10: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(ConfigUtils.getConfigFile("phone_params")));
                screenParams = ScreenParams.createFromInputStream(display, stream);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    String string = String.valueOf(String.valueOf(e));
                    Log.d((String)TAG, (String)new StringBuilder(44 + string.length()).append("Cardboard screen parameters file not found: ").append(string).toString());
                    return null;
                }
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return screenParams;
    }
}

