/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard;

import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.vrtoolkit.cardboard.ConfigUtils;
import com.google.vrtoolkit.cardboard.proto.Phone;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PhoneParams {
    private static final String TAG = PhoneParams.class.getSimpleName();
    private static final int STREAM_SENTINEL = 779508118;

    private PhoneParams() {
    }

    static Phone.PhoneParams readFromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            ByteBuffer header = ByteBuffer.allocate(8);
            if (inputStream.read(header.array(), 0, header.array().length) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            int sentinel = header.getInt();
            int length = header.getInt();
            if (sentinel != 779508118) {
                Log.e((String)TAG, (String)"Error parsing param record: incorrect sentinel.");
                return null;
            }
            byte[] protoBytes = new byte[length];
            if (inputStream.read(protoBytes, 0, protoBytes.length) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            return (Phone.PhoneParams)MessageNano.mergeFrom((MessageNano)new Phone.PhoneParams(), (byte[])protoBytes);
        }
        catch (InvalidProtocolBufferNanoException e) {
            String string = String.valueOf(e.toString());
            Log.w((String)TAG, (String)(string.length() != 0 ? "Error parsing protocol buffer: ".concat(string) : new String("Error parsing protocol buffer: ")));
        }
        catch (IOException e) {
            String string = String.valueOf(e.toString());
            Log.w((String)TAG, (String)(string.length() != 0 ? "Error reading Cardboard parameters: ".concat(string) : new String("Error reading Cardboard parameters: ")));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phone.PhoneParams readFromExternalStorage() {
        Phone.PhoneParams phoneParams;
        block10: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(ConfigUtils.getConfigFile("phone_params")));
                phoneParams = PhoneParams.readFromInputStream(stream);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    String string = String.valueOf(String.valueOf(e));
                    Log.d((String)TAG, (String)new StringBuilder(43 + string.length()).append("Cardboard phone parameters file not found: ").append(string).toString());
                    return null;
                }
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return phoneParams;
    }
}

