/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard.sensors;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Handler;
import android.util.Log;
import com.google.vrtoolkit.cardboard.CardboardDeviceParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class NfcSensor {
    private static final String TAG = "NfcSensor";
    private static final int MAX_CONNECTION_FAILURES = 1;
    private static final long NFC_POLLING_INTERVAL_MS = 250L;
    private static NfcSensor sInstance;
    private final Context mContext;
    private final NfcAdapter mNfcAdapter;
    private final Object mTagLock;
    private final List<ListenerHelper> mListeners;
    private IntentFilter[] mNfcIntentFilters;
    private Ndef mCurrentNdef;
    private Tag mCurrentTag;
    private boolean mCurrentTagIsCardboard;
    private Timer mNfcDisconnectTimer;
    private int mTagConnectionFailures;

    public static NfcSensor getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new NfcSensor(context);
        }
        return sInstance;
    }

    private NfcSensor(Context context) {
        this.mContext = context.getApplicationContext();
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.mContext);
        this.mListeners = new ArrayList<ListenerHelper>();
        this.mTagLock = new Object();
        if (this.mNfcAdapter == null) {
            return;
        }
        IntentFilter ndefIntentFilter = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
        ndefIntentFilter.addAction("android.nfc.action.TECH_DISCOVERED");
        ndefIntentFilter.addAction("android.nfc.action.TAG_DISCOVERED");
        this.mNfcIntentFilters = new IntentFilter[]{ndefIntentFilter};
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                NfcSensor.this.onNfcIntent(intent);
            }
        }, ndefIntentFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCardboardNfcListener(OnCardboardNfcListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerHelper> list = this.mListeners;
        synchronized (list) {
            for (ListenerHelper helper : this.mListeners) {
                if (helper.getListener() != listener) continue;
                return;
            }
            this.mListeners.add(new ListenerHelper(listener, new Handler()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCardboardNfcListener(OnCardboardNfcListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerHelper> list = this.mListeners;
        synchronized (list) {
            for (ListenerHelper helper : this.mListeners) {
                if (helper.getListener() != listener) continue;
                this.mListeners.remove(helper);
                return;
            }
        }
    }

    public boolean isNfcSupported() {
        return this.mNfcAdapter != null;
    }

    public boolean isNfcEnabled() {
        return this.isNfcSupported() && this.mNfcAdapter.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceInCardboard() {
        Object object = this.mTagLock;
        synchronized (object) {
            return this.mCurrentTagIsCardboard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage getTagContents() {
        Object object = this.mTagLock;
        synchronized (object) {
            return this.mCurrentNdef != null ? this.mCurrentNdef.getCachedNdefMessage() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage getCurrentTagContents() throws TagLostException, IOException, FormatException {
        Object object = this.mTagLock;
        synchronized (object) {
            return this.mCurrentNdef != null ? this.mCurrentNdef.getNdefMessage() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTagCapacity() {
        Object object = this.mTagLock;
        synchronized (object) {
            if (this.mCurrentNdef == null) {
                throw new IllegalStateException("No NFC tag");
            }
            return this.mCurrentNdef.getMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUri(Uri uri) throws TagLostException, IOException, IllegalArgumentException {
        Object object = this.mTagLock;
        synchronized (object) {
            int recordFound;
            if (this.mCurrentTag == null) {
                throw new IllegalStateException("No NFC tag found");
            }
            NdefMessage currentMessage = null;
            NdefMessage newMessage = null;
            NdefRecord newRecord = NdefRecord.createUri((Uri)uri);
            try {
                currentMessage = this.getCurrentTagContents();
            }
            catch (Exception e) {
                currentMessage = this.getTagContents();
            }
            if (currentMessage != null) {
                ArrayList<NdefRecord> newRecords = new ArrayList<NdefRecord>();
                recordFound = 0;
                for (NdefRecord record : currentMessage.getRecords()) {
                    if (this.isCardboardNdefRecord(record)) {
                        if (recordFound != 0) continue;
                        newRecords.add(newRecord);
                        recordFound = 1;
                        continue;
                    }
                    newRecords.add(record);
                }
                newMessage = new NdefMessage(newRecords.toArray(new NdefRecord[newRecords.size()]));
            }
            if (newMessage == null) {
                newMessage = new NdefMessage(new NdefRecord[]{newRecord});
            }
            if (this.mCurrentNdef != null) {
                if (!this.mCurrentNdef.isConnected()) {
                    this.mCurrentNdef.connect();
                }
                if (this.mCurrentNdef.getMaxSize() < newMessage.getByteArrayLength()) {
                    int newRecords = this.mCurrentNdef.getMaxSize();
                    recordFound = newMessage.getByteArrayLength();
                    throw new IllegalArgumentException(new StringBuilder(82).append("Not enough capacity in NFC tag. Capacity: ").append(newRecords).append(" bytes, ").append(recordFound).append(" required.").toString());
                }
                try {
                    this.mCurrentNdef.writeNdefMessage(newMessage);
                }
                catch (FormatException e) {
                    String string = String.valueOf(e.toString());
                    throw new RuntimeException(string.length() != 0 ? "Internal error when writing to NFC tag: ".concat(string) : new String("Internal error when writing to NFC tag: "));
                }
            }
            NdefFormatable ndef = NdefFormatable.get((Tag)this.mCurrentTag);
            if (ndef == null) {
                throw new IOException("Could not find a writable technology for the NFC tag");
            }
            Log.w((String)TAG, (String)"Ndef technology not available. Falling back to NdefFormattable.");
            try {
                ndef.connect();
                ndef.format(newMessage);
                ndef.close();
            }
            catch (FormatException e) {
                String string = String.valueOf(e.toString());
                throw new RuntimeException(string.length() != 0 ? "Internal error when writing to NFC tag: ".concat(string) : new String("Internal error when writing to NFC tag: "));
            }
            this.onNewNfcTag(this.mCurrentTag);
        }
    }

    public void onResume(Activity activity) {
        if (!this.isNfcEnabled()) {
            return;
        }
        Intent intent = new Intent("android.nfc.action.NDEF_DISCOVERED");
        intent.setPackage(activity.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        this.mNfcAdapter.enableForegroundDispatch(activity, pendingIntent, this.mNfcIntentFilters, (String[][])null);
    }

    public void onPause(Activity activity) {
        if (!this.isNfcEnabled()) {
            return;
        }
        this.mNfcAdapter.disableForegroundDispatch(activity);
    }

    public void onNfcIntent(Intent intent) {
        if (!this.isNfcEnabled() || intent == null || !this.mNfcIntentFilters[0].matchAction(intent.getAction())) {
            return;
        }
        this.onNewNfcTag((Tag)intent.getParcelableExtra("android.nfc.extra.TAG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewNfcTag(Tag nfcTag) {
        if (nfcTag == null) {
            return;
        }
        Object object = this.mTagLock;
        synchronized (object) {
            NdefMessage nfcTagContents;
            Tag previousTag = this.mCurrentTag;
            Ndef previousNdef = this.mCurrentNdef;
            boolean previousTagWasCardboard = this.mCurrentTagIsCardboard;
            this.closeCurrentNfcTag();
            this.mCurrentTag = nfcTag;
            this.mCurrentNdef = Ndef.get((Tag)nfcTag);
            if (this.mCurrentNdef == null) {
                if (previousTagWasCardboard) {
                    this.sendDisconnectionEvent();
                }
                return;
            }
            boolean isSameTag = false;
            if (previousNdef != null) {
                byte[] tagId1 = this.mCurrentTag.getId();
                byte[] tagId2 = previousTag.getId();
                boolean bl = isSameTag = tagId1 != null && tagId2 != null && Arrays.equals(tagId1, tagId2);
                if (!isSameTag && previousTagWasCardboard) {
                    this.sendDisconnectionEvent();
                }
            }
            try {
                this.mCurrentNdef.connect();
                nfcTagContents = this.mCurrentNdef.getCachedNdefMessage();
            }
            catch (Exception e) {
                String string = String.valueOf(e.toString());
                Log.e((String)TAG, (String)(string.length() != 0 ? "Error reading NFC tag: ".concat(string) : new String("Error reading NFC tag: ")));
                if (isSameTag && previousTagWasCardboard) {
                    this.sendDisconnectionEvent();
                }
                return;
            }
            this.mCurrentTagIsCardboard = this.isCardboardNdefMessage(nfcTagContents);
            if (!isSameTag && this.mCurrentTagIsCardboard) {
                List<ListenerHelper> list = this.mListeners;
                synchronized (list) {
                    for (ListenerHelper listener : this.mListeners) {
                        listener.onInsertedIntoCardboard(CardboardDeviceParams.createFromNfcContents(nfcTagContents));
                    }
                }
            }
            if (this.mCurrentTagIsCardboard) {
                this.mTagConnectionFailures = 0;
                this.mNfcDisconnectTimer = new Timer("NFC disconnect timer");
                this.mNfcDisconnectTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = NfcSensor.this.mTagLock;
                        synchronized (object) {
                            if (!NfcSensor.this.mCurrentNdef.isConnected()) {
                                ++NfcSensor.this.mTagConnectionFailures;
                                if (NfcSensor.this.mTagConnectionFailures > 1) {
                                    NfcSensor.this.closeCurrentNfcTag();
                                    NfcSensor.this.sendDisconnectionEvent();
                                }
                            }
                        }
                    }
                }, 250L, 250L);
            }
        }
    }

    private void closeCurrentNfcTag() {
        if (this.mNfcDisconnectTimer != null) {
            this.mNfcDisconnectTimer.cancel();
        }
        if (this.mCurrentNdef == null) {
            return;
        }
        try {
            this.mCurrentNdef.close();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)e.toString());
        }
        this.mCurrentTag = null;
        this.mCurrentNdef = null;
        this.mCurrentTagIsCardboard = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDisconnectionEvent() {
        List<ListenerHelper> list = this.mListeners;
        synchronized (list) {
            for (ListenerHelper listener : this.mListeners) {
                listener.onRemovedFromCardboard();
            }
        }
    }

    private boolean isCardboardNdefMessage(NdefMessage message) {
        if (message == null) {
            return false;
        }
        for (NdefRecord record : message.getRecords()) {
            if (!this.isCardboardNdefRecord(record)) continue;
            return true;
        }
        return false;
    }

    private boolean isCardboardNdefRecord(NdefRecord record) {
        if (record == null) {
            return false;
        }
        Uri uri = record.toUri();
        return uri != null && CardboardDeviceParams.isCardboardUri(uri);
    }

    private static class ListenerHelper
    implements OnCardboardNfcListener {
        private OnCardboardNfcListener mListener;
        private Handler mHandler;

        public ListenerHelper(OnCardboardNfcListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        public OnCardboardNfcListener getListener() {
            return this.mListener;
        }

        @Override
        public void onInsertedIntoCardboard(final CardboardDeviceParams deviceParams) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerHelper.this.mListener.onInsertedIntoCardboard(deviceParams);
                }
            });
        }

        @Override
        public void onRemovedFromCardboard() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerHelper.this.mListener.onRemovedFromCardboard();
                }
            });
        }
    }

    public static interface OnCardboardNfcListener {
        public void onInsertedIntoCardboard(CardboardDeviceParams var1);

        public void onRemovedFromCardboard();
    }
}

