/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard.sensors.internal;

import com.google.vrtoolkit.cardboard.sensors.internal.Vector3d;

public class GyroBiasEstimator {
    private static final float GYRO_SMOOTHING_FACTOR = 0.01f;
    private static final float ACC_SMOOTHING_FACTOR = 0.1f;
    private static final Vector3d UP_VECTOR = new Vector3d(0.0, 0.0, 1.0);
    private static final float MIN_ACCEL_DOT_WITH_UP = (float)Math.cos(Math.toRadians(10.0));
    private static final float MIN_ACCEL_LENGTH = 1.0E-4f;
    private static final float MAX_GYRO_DIFF = 0.01f;
    private static final long CALIBRATION_DURATION_NS = 5000000000L;
    private static final long MAX_DELAY_BETWEEN_EVENTS_NS = 100000000L;
    private final Vector3d mLastGyro = new Vector3d();
    private final Vector3d mCurrGyro = new Vector3d();
    private final Vector3d mGyroDiff = new Vector3d();
    private final Vector3d mCurrAcc = new Vector3d();
    private final Vector3d mAccSmoothed = new Vector3d();
    private final Vector3d mAccNormalizedTmp = new Vector3d();
    private float mGyroMagnitudeDiffSmoothed;
    private final Estimate mBiasEstimate = new Estimate();
    private long mCalibrationStartTimeNs = -1L;
    private long mLastGyroTimeNs = -1L;
    private long mLastAccTimeNs = -1L;

    public void processGyroscope(Vector3d gyro, long sensorTimeStamp) {
        if (this.mBiasEstimate.mState == Estimate.State.CALIBRATED) {
            return;
        }
        this.mCurrGyro.set(gyro);
        Vector3d.sub(this.mCurrGyro, this.mLastGyro, this.mGyroDiff);
        float mCurrDiff = (float)this.mGyroDiff.length();
        this.mGyroMagnitudeDiffSmoothed = 0.01f * mCurrDiff + 0.99f * this.mGyroMagnitudeDiffSmoothed;
        this.mLastGyro.set(this.mCurrGyro);
        boolean eventIsDelayed = sensorTimeStamp > this.mLastGyroTimeNs + 100000000L;
        this.mLastGyroTimeNs = sensorTimeStamp;
        if (eventIsDelayed) {
            this.resetCalibration();
            return;
        }
        if (this.mBiasEstimate.mState == Estimate.State.CALIBRATING && sensorTimeStamp > this.mCalibrationStartTimeNs + 5000000000L) {
            this.mBiasEstimate.mState = Estimate.State.CALIBRATED;
            return;
        }
        if (!this.canCalibrateGyro()) {
            this.resetCalibration();
            return;
        }
        this.startCalibration(sensorTimeStamp);
    }

    private void resetCalibration() {
        this.mBiasEstimate.mState = Estimate.State.UNCALIBRATED;
        this.mBiasEstimate.mBias.set(0.0, 0.0, 0.0);
        this.mCalibrationStartTimeNs = -1L;
    }

    private void startCalibration(long gyroTimeStamp) {
        if (this.mBiasEstimate.mState != Estimate.State.CALIBRATING) {
            this.mBiasEstimate.mBias.set(this.mCurrGyro);
            this.mBiasEstimate.mState = Estimate.State.CALIBRATING;
            this.mCalibrationStartTimeNs = gyroTimeStamp;
        } else {
            GyroBiasEstimator.smooth(this.mBiasEstimate.mBias, this.mCurrGyro, 0.01f);
        }
    }

    public void processAccelerometer(Vector3d acc, long sensorTimeStamp) {
        if (this.mBiasEstimate.mState == Estimate.State.CALIBRATED) {
            return;
        }
        this.mCurrAcc.set(acc);
        boolean eventIsDelayed = sensorTimeStamp > this.mLastAccTimeNs + 100000000L;
        this.mLastAccTimeNs = sensorTimeStamp;
        if (eventIsDelayed) {
            this.resetCalibration();
            return;
        }
        GyroBiasEstimator.smooth(this.mAccSmoothed, this.mCurrAcc, 0.1f);
    }

    public void getEstimate(Estimate output) {
        output.set(this.mBiasEstimate);
    }

    private boolean canCalibrateGyro() {
        if (this.mAccSmoothed.length() < (double)1.0E-4f) {
            return false;
        }
        this.mAccNormalizedTmp.set(this.mAccSmoothed);
        this.mAccNormalizedTmp.normalize();
        if (Vector3d.dot(this.mAccNormalizedTmp, UP_VECTOR) < (double)MIN_ACCEL_DOT_WITH_UP) {
            return false;
        }
        return !(this.mGyroMagnitudeDiffSmoothed > 0.01f);
    }

    private static void smooth(Vector3d smoothed, Vector3d newValue, float smoothingFactor) {
        smoothed.x = (double)smoothingFactor * newValue.x + (double)(1.0f - smoothingFactor) * smoothed.x;
        smoothed.y = (double)smoothingFactor * newValue.y + (double)(1.0f - smoothingFactor) * smoothed.y;
        smoothed.z = (double)smoothingFactor * newValue.z + (double)(1.0f - smoothingFactor) * smoothed.z;
    }

    public static class Estimate {
        public State mState = State.UNCALIBRATED;
        public final Vector3d mBias = new Vector3d();

        public void set(Estimate from) {
            this.mState = from.mState;
            this.mBias.set(from.mBias);
        }

        public static enum State {
            UNCALIBRATED,
            CALIBRATING,
            CALIBRATED;

        }
    }
}

