package com.linkesoft.ctlogocardboard;

import android.graphics.Color;
import android.opengl.*;
import android.os.Bundle;
import android.util.Log;

import com.google.vrtoolkit.cardboard.*;

import java.util.*;

import javax.microedition.khronos.egl.EGLConfig;


public class MainActivity extends CardboardActivity implements CardboardView.StereoRenderer {

    private Triangle triangle; // simples Dreieck im Raum
    private CTLogo ctlogo; // 3D-Logo der c't

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        // Cardboard-View initialisieren
        CardboardView cardboardView=(CardboardView)findViewById(R.id.cardboard_view);
        setCardboardView(cardboardView);
        cardboardView.setRenderer(this);
    }

    @Override
    public void onSurfaceCreated(EGLConfig eglConfig) {
        // OpenGL ist bereit
        triangle=new Triangle();
        //ctlogo=new CTLogo();
    }

    @Override
    public void onDrawEye(Eye eye) {
        // Kamera-Perspektive
        float camera[]=new float[16];
        Matrix.setLookAtM(camera,
                0, // nutze float-Array ab erster Position
                0, 0.04f, 0.0f,// eye x,y,z
                0, 0,0, // center x,y,z
                0, 0,-1); // up x,y,z

        // erzeuge Model-View-Projection-Matrix aus Kamera-Perspektive und Augen-Position
        float mvpMatrix[]=new float[16];
        Matrix.multiplyMM(mvpMatrix,0,eye.getEyeView(),0,camera,0);

        triangle.draw(mvpMatrix);
        //ctlogo.draw(mvpMatrix);
    }

    @Override
    public void onCardboardTrigger() {
        Log.i(getClass().getSimpleName(),"Trigger pulled");
        if(triangle!=null) {
            int red=(int)(Math.random()*255.0);
            int green=(int)(Math.random()*255.0);
            int blue=(int)(Math.random()*255.0);
            triangle.color = Color.argb(255, red,green,blue);
        }
    }

    @Override
    public void onNewFrame(HeadTransform headTransform) {
    }

    @Override
    public void onFinishFrame(Viewport viewport) {
    }

    @Override
    public void onSurfaceChanged(int i, int i2) {
    }

    @Override
    public void onRendererShutdown() {
    }
}
