/*****************/
/* 28.06.2015    */
/* Kai-Uwe Mrkor */
/*****************/

#include <pebble.h>
#include <string.h>
  
static Window *window;
static TextLayer *time_layer;

// Uhren-Event (Ausgabe der Uhrzeit)
static void tick_handler(struct tm *tick_time, TimeUnits units_changed) {
  static char buffer[] = "00:00";
  strftime(buffer, sizeof("00:00"), "%H:%M", tick_time);
  text_layer_set_text(time_layer, buffer);        
}

// Fenster erzeugen
static void window_load(Window *window) {
  // Text-Layer für die Uhrzeit
  time_layer = text_layer_create(GRect(0, 50, 144, 55));  
  text_layer_set_background_color(time_layer, GColorWhite);
  text_layer_set_text_color(time_layer, GColorBlack); 
  
  // Schriftart und Ausrichtung der Uhrzeit einrichten
  text_layer_set_font(time_layer, fonts_get_system_font( FONT_KEY_ROBOTO_BOLD_SUBSET_49)); 
  text_layer_set_text_alignment(time_layer, GTextAlignmentCenter);

  // Kindfenster hinzufügen 
  layer_add_child(window_get_root_layer(window), text_layer_get_layer(time_layer));
}

// Layer wieder abbauen
static void window_unload(Window *window) {
  text_layer_destroy(time_layer);
}

// Initialisierung aller Komponenten
static void init(void) {
  // Fenster 
  window = window_create();
  window_set_fullscreen(window, true);  
  
  // Handler für das Einrichten und Abbauen des Fensters festlegen
  window_set_window_handlers(window, (WindowHandlers) {
	  .load = window_load,
    .unload = window_unload,
  });   
  
  // Tick-Timer anmelden (löst jede Sekunde ein Event aus)
  tick_timer_service_subscribe(SECOND_UNIT, tick_handler);   
  
  // window = aktuelles Fenster der App
  window_stack_push(window, true);
}

// Das Hauptprogramm
int main(void) {
  init();
  app_event_loop();
  window_destroy(window);
}