/*
This sketch is used for the mini DMX Lightconsole
It can change the values of four DMX Channels in two different modes
Press the Button to change the mode

Mode 1:
All lights are changed with the slider

Mode 2:
To select the light move the wheel and to change the values move the slider. Only one light get changed at a time
*/


#include <DmxSimple.h>


//Lamp Values
byte value[4];
byte mode = 0; //Two modes: 0 and 1


//Poti Slider (ALPS)
byte slideValue;       // variable to store the value coming from the slide poti

boolean buttonState; //Stores the state of the pushbutton


//Define all used Arduino Pins
#define dmxOut 13
#define slider A0
#define encoderA 11
#define encoderB 12
#define button 10


//Needed for the rotary pulse encoder (Drehimpulsgeber)
int8_t altAB = 0;
int wert = 0; //Start Value for Drehimpulsgeber

int8_t schrittTab[16] = {0, -1, 1, 0, 1, 0, 0, -1, -1, 0, 0, 1, 0, 1, -1, 0};


////////////////////////////////////////////////////
void setup() {

  Serial.begin(9600);

  //DMX Output
  DmxSimple.usePin(dmxOut);


  //Define if the Arduino Pin is a Input or Output
  pinMode(button, INPUT);
  pinMode(encoderA, INPUT);
  pinMode(encoderB, INPUT);

  Serial.print("Start the Lightshow: ");
}

////////////////////////////////////////////////////
void loop() {

  ////////////////////////////////////////////////////
  //Poti Slider ALPS
  //
  slideValue = analogRead(slider) / 4;  // read the value from the sensor //0 - 255 for DMX Out





  ////////////////////////////////////////////////////
  //Button
  //

  //Recognize it when Button gets pressed, but only once!
  //When it is down more then one cycles, only once recognized
  if (buttonState != digitalRead(button)) {
    buttonState = !buttonState;

    Serial.println("\n Button pressed. New Mode: ");
    mode = !mode;
    Serial.print(mode);

  }




  ////////////////////////////////////////////////////
  //  	rotary pulse encoder (Drehimpulsregler)
  //
  wert += readEncoder(encoderA, encoderB);

  if (wert < 1)
    wert = 1;

  if (wert > 4)
    wert = 4;

  Serial.print("selected lamp: ");
  Serial.println(wert);


  //////////////////////////////////////////////////////
  // Work
  switch (mode) {
    case (0):
      DmxSimple.write(1, slideValue);
      DmxSimple.write(2, slideValue);
      DmxSimple.write(3, slideValue);
      DmxSimple.write(4, slideValue);
      break;
    case (1):
      DmxSimple.write(wert, slideValue);

  }

  delay(20);
}



//Function for Drehencoder
//from http://www.meinduino.de/arduino-grundlagen/2014/09/20/drehencoder1.html
int8_t readEncoder(int pinA, int pinB) {
  altAB <<= 2;
  altAB &= B00001100;
  altAB |= (digitalRead(pinA) << 1) | digitalRead(pinB);
  return (schrittTab[altAB]);
}

