(function ($, window) {
  "use strict";
  var inputEl, outputEl, checkboxes;

  function applyFilter() {
    var filters = checkboxes.filter(function(i, checkbox) {
      return $(checkbox).is(':checked');
    }).map(function(i, checkbox) {
      return $(checkbox).attr('id');
    }).toArray();
    $.ajax({
      url: 'ajax/filter.php',
      method: 'POST',
      data: {
        filters: filters.join(','),
        data: inputEl.val()
      },
      dataType: 'json',
      error: function(err) {
        console.error(err);
      },
      success: function(d) {
        console.log(d);
        outputEl.val(d.data);
      }
    });
  }

  function init() {
    $('#status').text('ready').removeClass('not-ready').addClass('ready');
    inputEl = $('#input');
    inputEl.bind("keyup change", applyFilter)
    outputEl = $('#output');
    checkboxes = $('input[type=checkbox]');
    checkboxes.change(applyFilter);
  }
  $(document).ready(init);
})($, window);
