package de.jockels.forcetouchemu;

import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.MotionEvent;

/**
 * Created by jow on 20.01.2016.
 * <p/>
 * Ausgewertet wird der getToolType statt getSource:
 * Auf dem Nvidia-Tablet ist getSource bei Finger- und Stifteingabe die gleiche, aber der
 * ToolType ist unterschiedlich.
 *
 * TODO Werte abspeichern
 */
public class ForceTouchHelper {
    static SimpleArrayMap<Integer, Pair<Float, Float>> mValues = new SimpleArrayMap<>(10);

    public static boolean isForceTouch(MotionEvent ev) {
        // kein ForceTouch bei Multitouch
        if (ev.getPointerCount() > 1) return false;

        Integer tool = ev.getToolType(0);
        Pair<Float, Float> save = mValues.get(tool);
        if (save==null) {
            // erster Touch von diesem Tool
            mValues.put(tool, new Pair<>(ev.getPressure(), ev.getPressure()));
//            Log.v("Helper", "new tool " + tool);
            return false;
        } else {
            float p = ev.getPressure();

            // neues Minimum oder Maximum?
            if (p<save.first) mValues.put(tool, save = new Pair<>(p, save.second));
            if (p>save.second) mValues.put(tool, save = new Pair<>(save.first, p));
            Log.v("Helper", String.format("%d: %1.3f ... %1.3f", (int)tool, (float)save.first, (float)save.second));

            // Force Touch, wenn über Minimalwert und über 66% von Max-Min
            return p > 0.3 && p > (save.first + (save.second - save.first) * 0.66);
        }
    }
}
