#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys, subprocess
from os import chdir
from glob import glob

FFMPEG = '..\\ffmpeg.exe'
FFPROBE = '..\\ffprobe.exe'
FPS = 10
DST = 'output'

folder = sys.argv[1]
chdir(folder)
f = glob('*.wmv')[0]
subprocess.call([FFMPEG, '-y', '-i', f, '-an', '-q:v', '3', '-preset', 'veryslow', '-vcodec', 'libvpx', '-vf', 'fps=' + str(FPS), DST + '.webm'])
subprocess.call([FFMPEG, '-y', '-i', f, '-an', '-q:v', '7', '-preset', 'veryslow', '-vcodec', 'libtheora', '-vf', 'fps=' + str(FPS), DST + '.ogv'])
subprocess.call([FFMPEG, '-y', '-i', f, '-an', '-q:v', '4', '-preset', 'veryslow', '-vcodec', 'libx264', '-vf', 'fps=' + str(FPS), '-movflags', '+faststart', DST + '.mp4'])
p = subprocess.Popen([FFPROBE, '-of', 'flat=s=_', '-v', 'error', '-show_entries', 'format=duration', DST + '.mp4'], stdout=subprocess.PIPE)
p.wait()
result = p.communicate()[0].decode('utf-8')
duration = str(0.75 * float(result.split('=')[1].rstrip()[1:-1]))
subprocess.call([FFMPEG, '-y', '-i', DST + '.mp4', '-vframes', '1', '-ss', duration, DST + '.png'])
chdir('..')
