from psonic import *
from threading import Thread, Barrier

def piano_sound(barrier):
    use_synth(PIANO)
    chords = [chord(C4,MAJOR), chord(G3, '7'), chord(A3,MINOR), chord(F3,MAJOR)]
    while True:
        for i in range(4):
            barrier.wait()
            for j in range(8):
                play(chords[i], release=2.0)
                sleep(0.25)


def drum_sound(barrier):
    while True:
        barrier.wait()
        for i in range(4):
            sample(DRUM_BASS_HARD)
            sleep(0.5)

barrier = Barrier(2)
piano_thread = Thread(target=piano_sound, args=(barrier,))
drums_thread = Thread(target=drum_sound, args=(barrier,))

piano_thread.start()
drums_thread.start()


while True:
    pass
