//LinkedList wird bereitgestellt
import java.util.LinkedList;

//Die Klasse UndoSpeicher speichert Bildinhalte und gibt diese zurück.
class UndoSpeicher {
  
  //Referenz auf die LinkedList, welche die Bildinhalte speichern wird
  LinkedList<PImage> img;
  //Referenz auf den aktuellen Bildinhalt
  PImage aktuellesBild;
  //Anzahl der Bildinhalte, die erinnert werden soll
  static final int nBilder = 20;
  
  //Konstruktor...
  UndoSpeicher(Bild bild) {
    //LinkedList wird initialisiert
    img = new LinkedList<PImage>();
    //Aktueller Bildinhalt wird initialisiert
    aktuellesBild = bild.pg.copy();
  }
  
  //Wird von bild.malenBeenden() aufgerufen
  void save() {
    //Der letzte Bildzustand wird an die LinkedList angehängt.
    img.add(aktuellesBild);
    //Der aktuelle Zustand des Bildesinhaltes wird neu gesetzt.
    aktuellesBild = bild.pg.copy();
    //Wenn die LinkedList mehr als nBilder enthält, wird der zuerst gespeicherte Bildinhalt entfernt.
    if (img.size() > nBilder) {
      img.pollFirst();
    }
  }
  
  //Wird von bild.undo() aufgerufen, wenn die Taste "z" gedrückt wurde
  PImage undo() {
    //Wenn die LinkedList nicht leer ist... 
    if (!img.isEmpty()) {
      //... wird der zuletzt gespeicherte Bildinhalt in aktuelles Bild gespeichert und aus der LinkedList entfernt.
      aktuellesBild = img.pollLast();
    }
    //Der aktuelle Bildinhalt wird zurückgegeben.
    return aktuellesBild;
  }
}