/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.app;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import org.openmuc.jsml.GenericParser;
import org.openmuc.jsml.internal.cli.CliParameter;
import org.openmuc.jsml.internal.cli.CliParameterBuilder;
import org.openmuc.jsml.internal.cli.CliParseException;
import org.openmuc.jsml.internal.cli.CliParser;
import org.openmuc.jsml.internal.cli.StringCliParameter;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.transport.SerialReceiver;

public class EhzSerialReader {
    public static void main(String[] args) throws IOException, PortInUseException, UnsupportedCommOperationException, NoSuchPortException {
        StringCliParameter serialPortName = new CliParameterBuilder("-sp").setDescription("The serial port used for communication. Examples are /dev/ttyS0 (Linux) or COM1 (Windows).").setMandatory().buildStringParameter("serial_port");
        ArrayList<CliParameter> cliParameters = new ArrayList<CliParameter>();
        cliParameters.add(serialPortName);
        CliParser cliParser = new CliParser("jsml-ehz-reader", "Reads an eHz using its optical port over a serial connection.");
        cliParser.addParameters(cliParameters);
        try {
            cliParser.parseArguments(args);
        }
        catch (CliParseException e1) {
            System.err.println("Error parsing command line parameters: " + e1.getMessage());
            System.out.println(cliParser.getUsageString());
            System.exit(1);
        }
        SerialPort serialPort = EhzSerialReader.setupSerialPort(serialPortName.getValue());
        SerialReceiver receiver = new SerialReceiver(serialPort);
        int j = 0;
        while (j < 2) {
            System.out.println("\n\n == round " + j + " == \n\n");
            SmlFile smlFile = receiver.getSMLFile();
            System.out.println("Got SML_File");
            System.out.println(" ======================== ");
            GenericParser.printFile(smlFile);
            ++j;
        }
        receiver.closeStream();
        serialPort.close();
        System.out.println("\n *** Reader finished ***");
    }

    private static SerialPort setupSerialPort(String serialPortName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)serialPortName);
        CommPort commPort = commPortIdentifier.open("SampleSmlSerialReader", 2000);
        SerialPort serialPort = null;
        if (commPort instanceof SerialPort) {
            serialPort = (SerialPort)commPort;
            serialPort.setSerialPortParams(9600, 8, 1, 0);
            serialPort.setFlowControlMode(1);
            serialPort.notifyOnDataAvailable(true);
        } else {
            System.err.println("commPort isn't an instace of SerialPort");
            System.exit(1);
        }
        return serialPort;
    }
}

