/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import org.openmuc.jsml.EObis;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlSignature;
import org.openmuc.jsml.structures.SmlStatus;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlUnit;
import org.openmuc.jsml.structures.SmlValue;

public class SmlListEntry
extends Sequence {
    protected OctetString objName;
    protected SmlStatus status;
    protected SmlTime valTime;
    protected SmlUnit unit;
    protected Integer8 scaler;
    protected SmlValue value;
    protected SmlSignature valueSignature;

    public SmlListEntry() {
    }

    public SmlListEntry(OctetString objName, SmlStatus status, SmlTime valTime, SmlUnit unit, Integer8 scaler, SmlValue value, SmlSignature valueSignature) {
        if (objName == null) {
            throw new IllegalArgumentException("SML_ListEntry: objName is not optional and must not be null!");
        }
        if (value == null) {
            throw new IllegalArgumentException("SML_ListEntry: value is not optional and must not be null!");
        }
        this.objName = objName;
        this.status = status;
        this.valTime = valTime;
        this.unit = unit;
        this.scaler = scaler;
        this.value = value;
        this.valueSignature = valueSignature;
        if (this.status == null) {
            this.status = new SmlStatus();
        }
        if (this.valTime == null) {
            this.valTime = new SmlTime();
        }
        if (this.unit == null) {
            this.unit = new SmlUnit();
        }
        if (this.scaler == null) {
            this.scaler = new Integer8();
        }
        if (this.valueSignature == null) {
            this.valueSignature = new SmlSignature();
        }
        this.setOptionalAndSeq();
        this.isSelected = true;
    }

    public OctetString getObjName() {
        return this.objName;
    }

    public SmlStatus getStatus() {
        return this.status;
    }

    public SmlTime getValTime() {
        return this.valTime;
    }

    public SmlUnit getUnit() {
        return this.unit;
    }

    public Integer8 getScaler() {
        return this.scaler;
    }

    public SmlValue getValue() {
        return this.value;
    }

    public SmlSignature getValueSignature() {
        return this.valueSignature;
    }

    public void setOptionalAndSeq() {
        this.status.setOptional();
        this.valTime.setOptional();
        this.unit.setOptional();
        this.scaler.setOptional();
        this.valueSignature.setOptional();
        this.seqArray = new ASNObject[]{this.objName, this.status, this.valTime, this.unit, this.scaler, this.value, this.valueSignature};
    }

    @Override
    protected void createElements() {
        this.objName = new OctetString();
        this.status = new SmlStatus();
        this.valTime = new SmlTime();
        this.unit = new SmlUnit();
        this.scaler = new Integer8();
        this.value = new SmlValue();
        this.valueSignature = new SmlSignature();
        this.setOptionalAndSeq();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SML_ListEntry{\n");
        sb.append("               objName:         " + this.objName.toString() + "\n");
        sb.append("               status:          " + this.status.toString() + "\n");
        sb.append("               valTime:         " + this.valTime.toString() + "\n");
        sb.append("               unit:            " + this.unit.toString() + "\n");
        sb.append("               scaler:          " + this.scaler.toString() + "\n");
        sb.append("               value:           " + this.value.toString() + "\n");
        sb.append("               valueSignature:  " + this.valueSignature.toString() + "\n");
        sb.append("            }\n");
        return sb.toString();
    }

    public String toStringIndent(String level) {
        StringBuilder sb = new StringBuilder();
        sb.append("SML_ListEntry{\n");
        sb.append(String.valueOf(level) + "objName:         " + EObis.getInstance(this.objName).name() + "    " + this.objName.toString() + "\n");
        sb.append(String.valueOf(level) + "status:          " + this.status.toStringIndent(String.valueOf(level) + "    ") + "\n");
        sb.append(String.valueOf(level) + "valTime:         " + this.valTime.toString() + "\n");
        sb.append(String.valueOf(level) + "unit:            " + this.unit.toString() + "\n");
        sb.append(String.valueOf(level) + "scaler:          " + this.scaler.toString() + "\n");
        sb.append(String.valueOf(level) + "value:           " + this.value.toString() + "\n");
        sb.append(String.valueOf(level) + "valueSignature:  " + this.valueSignature.toString() + "\n");
        String indent = "";
        if (level.length() >= 4) {
            indent = level.substring(0, level.length() - 4);
        }
        sb.append(String.valueOf(indent) + "}\n");
        return sb.toString();
    }
}

