/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures.requests;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;

public class SmlGetListReq
extends Sequence {
    protected OctetString clientId;
    protected OctetString serverId;
    protected OctetString username;
    protected OctetString password;
    protected OctetString listName;

    public SmlGetListReq() {
    }

    public SmlGetListReq(OctetString clientId, OctetString serverId, OctetString username, OctetString password, OctetString listName) {
        if (clientId == null) {
            throw new IllegalArgumentException("SML_GetListReq: clientId is not optional and must not be null!");
        }
        this.clientId = clientId;
        this.serverId = serverId;
        this.username = username;
        this.password = password;
        this.listName = listName;
        if (this.serverId == null) {
            this.serverId = new OctetString();
        }
        if (this.username == null) {
            this.username = new OctetString();
        }
        if (this.password == null) {
            this.password = new OctetString();
        }
        if (this.listName == null) {
            this.listName = new OctetString();
        }
        this.setOptionalAndSeq();
        this.isSelected = true;
    }

    public OctetString getClientId() {
        return this.clientId;
    }

    public OctetString getServerId() {
        return this.serverId;
    }

    public OctetString getUsername() {
        return this.username;
    }

    public OctetString getPassword() {
        return this.password;
    }

    public OctetString getListName() {
        return this.listName;
    }

    public void setOptionalAndSeq() {
        this.serverId.setOptional();
        this.username.setOptional();
        this.password.setOptional();
        this.listName.setOptional();
        this.seqArray = new ASNObject[]{this.clientId, this.serverId, this.username, this.password, this.listName};
    }

    @Override
    protected void createElements() {
        this.clientId = new OctetString();
        this.serverId = new OctetString();
        this.username = new OctetString();
        this.password = new OctetString();
        this.listName = new OctetString();
        this.setOptionalAndSeq();
    }
}

