/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.openmuc.jsml.transport.ConnectionHandler;
import org.openmuc.jsml.transport.TConnection;
import org.openmuc.jsml.transport.TSAP;

class ServerThread
extends Thread {
    private final ServerSocket serverSocket;
    private int numConnections = 0;
    private final TSAP tSAP;
    protected int maxTPDUSizeParam;
    private final int maxConnections;
    protected int messageTimeout;
    protected int messageFragmentTimeout;

    protected ServerThread(TSAP tSAP, ServerSocket socket, int maxConnections, int messageTimeout, int messageFragmentTimeout) {
        this.tSAP = tSAP;
        this.serverSocket = socket;
        this.maxTPDUSizeParam = this.maxTPDUSizeParam;
        this.maxConnections = maxConnections;
        this.messageTimeout = messageTimeout;
        this.messageFragmentTimeout = messageFragmentTimeout;
    }

    @Override
    public void run() {
        Socket clientSocket = null;
        while (true) {
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (IOException e) {
                this.tSAP.getConnectionListener().serverStoppedListeningIndication(e);
                return;
            }
            if (this.numConnections < this.maxConnections) {
                ++this.numConnections;
                ConnectionHandler myConnectionHandler = new ConnectionHandler(clientSocket, this);
                myConnectionHandler.start();
                continue;
            }
            System.err.println("Transport Layer Server: Maximum number of connections reached. Ignoring connection request.");
        }
    }

    protected void connectionIndication(TConnection tConnection) {
        this.tSAP.getConnectionListener().connectionIndication(tConnection);
    }

    protected void removeHandler(ConnectionHandler handler) {
        --this.numConnections;
    }

    public void stopServer() {
        if (this.serverSocket != null && this.serverSocket.isBound()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

