(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='WolframEngine 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       160,          7]
NotebookDataLength[     39217,        785]
NotebookOptionsPosition[     38702,        763]
NotebookOutlinePosition[     39242,        784]
CellTagsIndexPosition[     39199,        781]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Programmautor", ":", " ", 
    RowBox[{"Pit", " ", "Noack"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Eingabestrings", " ", "f\[UDoubleDot]r", " ", "Ort", " ", "und", " ", 
    "Zeitraum", " ", "interpretieren"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"getPositionFromString", "[", "input_", "]"}], ":=", " ", 
    RowBox[{
     RowBox[{"Interpreter", "[", "\"\<Location\>\"", "]"}], "[", "input", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"getDateFromString", "[", "input_", "]"}], ":=", " ", 
    RowBox[{
     RowBox[{"Interpreter", "[", "\"\<Date\>\"", "]"}], "[", "input", "]"}]}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Erdbebendaten", " ", "abfragen", " ", "und", " ", "als", " ", 
     "zweidimensionale", " ", "Liste", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Datum", ",", " ", "Magnitude", ",", " ", "Ort"}], "}"}], ",",
        " ", "..."}], " ", "}"}], " ", "formatieren"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"getEarthquakeData", "[", 
     RowBox[{
     "center_", ",", "sideLength_", ",", "start_", ",", "end_", ",", 
      "magnitude_"}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"quakesRaw", ",", " ", "searchArea"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"searchArea", " ", "=", " ", 
        RowBox[{"GeoDisk", "[", 
         RowBox[{"center", ",", 
          RowBox[{"Quantity", "[", 
           RowBox[{
            RowBox[{"sideLength", "/", "2"}], ",", "\"\<Kilometers\>\""}], 
           "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"quakesRaw", "=", 
        RowBox[{"EarthquakeData", "[", 
         RowBox[{"searchArea", ",", "magnitude", ",", 
          RowBox[{"{", 
           RowBox[{"start", ",", "end"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{"quakesRaw", ",", " ", "_Association"}], "]"}], ",", " ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", "\"\<Period\>\"", "]"}], ",", 
              RowBox[{"#", "[", "\"\<Magnitude\>\"", "]"}], ",", 
              RowBox[{"#", "[", "\"\<Position\>\"", "]"}]}], "}"}], "&"}], 
           ",", 
           RowBox[{"Values", "[", "quakesRaw", "]"}]}], "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"CTextinfo", " ", "rendern"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"renderTextInfos", "[", 
     RowBox[{
     "data_", ",", "center_", ",", "start_", ",", "end_", ",", "filename_"}], 
     "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Column", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Auswertung\>\"", ",", "Bold", ",", 
           RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<Zentrum: \>\"", " ", "center"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<Seitenl\[ADoubleDot]nge: \>\"", "<>", 
         RowBox[{"ToString", "[", "sideLength", "]"}], "<>", "\"\< km\>\""}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\"\<Zeitraum: \>\"", " ", "start"}], "-", "end"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<Magnitude min: \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", " ", "2"}], "]"}], "]"}], "//", "Min"}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"\"\<Magnitude max: \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", " ", "2"}], "]"}], "]"}], "//", "Max"}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"\"\<Anzahl Erdbeben: \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"data", "//", "Length"}], "]"}]}]}], "\[IndentingNewLine]", 
       "}"}], ",", 
      RowBox[{"Spacings", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Erdbenenkarte", " ", "rendern"}], "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"renderEarthquakeMap", "[", "data_", "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"GeoGraphics", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Apply", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "0", ",", " ", "1", ",", " ", "0.4"}], 
             "]"}], ",", " ", 
            RowBox[{"PointSize", "[", 
             RowBox[{"0.0003", " ", 
              RowBox[{"(", 
               RowBox[{"#2", " ", "^", "2.5"}], ")"}]}], "]"}], ",", 
            RowBox[{"Point", "[", "#3", "]"}]}], "}"}], "&"}], ",", "data", 
         ",", " ", 
         RowBox[{"{", "1", "}"}]}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"GeoRange", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GeoScaleBar", "\[Rule]", "\"\<Kilometers\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GeoRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", "0.05", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"GeoBackground", " ", "\[Rule]", " ", 
       RowBox[{"GeoStyling", "[", "\"\<ReliefMap\>\"", "]"}]}], ",", "\n", 
      "     ", 
      RowBox[{"ImageSize", "\[Rule]", "700"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Histogram", " ", "H\[ADoubleDot]ufigkeit", " ", 
     RowBox[{"vs", ".", " ", "Zeitinterval"}], " ", "rendern"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"renderIntervalHistogram", "[", 
     RowBox[{"data_", ",", " ", "start_", ",", " ", "end_"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"difference", ",", "  ", "segmentation"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"difference", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"DateDifference", "[", 
           RowBox[{"start", ",", " ", "end"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "/", "365"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Which", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"difference", " ", ">", " ", "1"}], " ", ",", " ", 
         RowBox[{"segmentation", " ", "=", " ", "\"\<Year\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"difference", " ", "<=", " ", "1"}], "  ", "&&", " ", 
          RowBox[{"difference", " ", ">", " ", "0.2"}]}], ",", " ", 
         RowBox[{"segmentation", "  ", "=", "\"\<Month\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"difference", " ", "<=", " ", "0.2"}], ",", 
         RowBox[{"segmentation", " ", "=", " ", "\"\<Day\>\""}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"DateHistogram", "[", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{"First", ",", "data"}], "]"}], ",", "segmentation", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Interval\>\"", ",", "\"\<Anzahl Beben\>\""}], "}"}]}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"ImagePadding", "\[Rule]", "60"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
         "ChartElementFunction", "\[Rule]", "\"\<FadingRectangle\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ChartStyle", " ", "\[Rule]", " ", "Red"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", " ", "\[Rule]", " ", "500"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Histogram", " ", "Magnitude", " ", 
     RowBox[{"vs", ".", " ", "H\[ADoubleDot]ufigkeit"}], " ", "rendern"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"renderMagnitudeHistogram", "[", "data_", "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Histogram", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}], ",", "data"}], "]"}], ",", 
      RowBox[{"{", "0.1", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Magnitude\>\"", ",", "\"\<H\[ADoubleDot]ufigkeit\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "60"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ChartElementFunction", "\[Rule]", "\"\<FadingRectangle\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"ChartStyle", "\[Rule]", " ", "Blue"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Text", ",", " ", 
     RowBox[{"Karte", " ", "und", " ", "Histogramme", " ", "rendern"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"renderAll", "[", 
     RowBox[{
     "data_", ",", " ", "center_", ",", " ", "start_", ",", " ", "end_", ",", 
      " ", "filename_"}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Column", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"renderTextInfos", "[", 
         RowBox[{
         "data", ",", " ", "center", ",", " ", "start", ",", " ", "end", ",", 
          " ", "filename"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"renderEarthquakeMap", "[", "data", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"renderIntervalHistogram", "[", 
         RowBox[{"data", ",", " ", "start", ",", " ", "end"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"renderMagnitudeHistogram", "[", "data", "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", " ", 
      RowBox[{"Frame", " ", "\[Rule]", " ", "All"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Eingabefelder", " ", "initialisieren"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"inputCenter", "=", "\"\<Japan\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{"sideLength", "=", "1000"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"inputStart", "=", "\"\<1.1.2010\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{"inputEnd", "=", "\"\<31.12.2017\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"magnitude", "=", "6.0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"filename", " ", "=", " ", "\"\<auswertung\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{"stateMessage", "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Eingabemaske", " ", "rendern"}], ",", " ", 
     RowBox[{"Eingaben", " ", "verarbeiten"}], ",", " ", 
     RowBox[{"Ausgabe", " ", "rendern"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"I", ".1", " ", "Eingabefelder"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Zentrum :\>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "inputCenter", "]"}], ",", "String"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Seitenlaenge (km) : \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "sideLength", "]"}], ",", "Number"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Datum Start : \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "inputStart", "]"}], ",", "String"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Datum Ende : \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "inputEnd", "]"}], ",", "String"}], "]"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Minimale Magnitude : \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "magnitude", "]"}], ",", "Number"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Ausgabe speichern unter : \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "filename", "]"}], ",", " ", "String"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Knopf", " ", "zur", " ", "Daten\[UDoubleDot]bernahme"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Button", "[", 
         RowBox[{
         "\"\<Suche starten\>\"", ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
           "********)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Aktion", " ", "bei", " ", 
            RowBox[{"Knopfdruck", ":"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "stateMessage", "=", 
            "\"\<...Interpretiere Texteingabe f\[UDoubleDot]r \
Zentrum...\>\""}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"...", "Texteingaben", " ", "interpretieren"}], "..."}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"center", "=", 
            RowBox[{"getPositionFromString", "[", "inputCenter", "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"start", "=", 
            RowBox[{"getDateFromString", "[", "inputStart", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"end", "=", 
            RowBox[{"getDateFromString", "[", "inputEnd", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"stateMessage", "=", "\"\<...suche nach Erdbeben...\>\""}],
            ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"...", "Suchanfrage", " ", "losschicken"}], "..."}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"data", "=", 
            RowBox[{"getEarthquakeData", "[", 
             RowBox[{
             "center", ",", "sideLength", ",", " ", "start", ",", "end", ",", 
              " ", "magnitude"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"...", "Wenn", " ", "Daten", " ", "gefunden"}], "..."}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"data", "//", "Length"}], ")"}], "\[GreaterEqual]", 
              "1"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"stateMessage", "=", 
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{"data", "//", "Length"}], "]"}], "<>", 
                "\"\< Erdbeben gefunden.\\n...rendert...\>\""}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"NotebookClose", "[", "outputNotebook", "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{
                "...", "Neues", " ", "Notebook", " ", "\[ODoubleDot]ffnen"}], 
                "..."}], "*)"}], "\[IndentingNewLine]", 
              RowBox[{"outputNotebook", " ", "=", " ", 
               RowBox[{"CreateDocument", "[", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{
                 "...", "Komplette", " ", "grafische", " ", "Ausgabe", " ", 
                  "in", " ", "das", " ", "neu", " ", "ge\[ODoubleDot]ffnete", 
                  " ", "Notebook", " ", "schreiben"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"ExpressionCell", "[", 
                  RowBox[{
                   RowBox[{"StandardForm", "[", 
                    RowBox[{"renderAll", "[", 
                    RowBox[{
                    "data", ",", " ", "center", ",", " ", "start", ",", " ", 
                    "end", ",", " ", "filename"}], "]"}], "]"}], ",", 
                   "\"\<Output\>\""}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                 "WindowTitle", " ", "\[Rule]", " ", "\"\<Auswertung\>\""}], 
                 ",", " ", "\[IndentingNewLine]", 
                 RowBox[{"WindowSize", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"900", ",", "900"}], "}"}]}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                 "NotebookFileName", " ", "\[Rule]", " ", "filename"}]}], 
                "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"stateMessage", "=", "\"\<fertig\>\""}], ";"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{
               "...", "Wenn", " ", "keine", " ", "Daten", " ", "gefunden"}], 
               "..."}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{
             "stateMessage", "=", 
              "\"\<Keine Erdbeben im Suchbereich gefunden\>\""}]}], "]"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"Ende", " ", "Aktion", " ", "bei", " ", "Knopfdruck"}], 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
          "*********)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}],
         ",", "SpanFromLeft"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Ausgabefeld", " ", "f\[UDoubleDot]r", " ", "Statusnachrichten"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", "\"\<Nachricht : \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "stateMessage", "]"}], ",", "String", ",", 
          " ", 
          RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.738803878551629*^9, 3.738803878554446*^9}, 
   3.738806853342502*^9, {3.7388074986264*^9, 3.738807508599144*^9}, {
   3.738807657838744*^9, 3.7388076661834383`*^9}, {3.738807773518663*^9, 
   3.738807778667935*^9}, {3.7388078763725567`*^9, 3.7388079123943996`*^9}, {
   3.7388079582155952`*^9, 3.738807958495549*^9}, {3.738807997882164*^9, 
   3.7388079991946774`*^9}, {3.738808072802577*^9, 3.738808087887169*^9}, {
   3.7388083001399403`*^9, 3.738808323902752*^9}, {3.738808556061596*^9, 
   3.7388086210176153`*^9}, 3.738808756825674*^9, {3.7388087936090603`*^9, 
   3.738808807173482*^9}, {3.738809155245534*^9, 3.738809172609487*^9}, {
   3.73880954904178*^9, 3.738809574595286*^9}, {3.7388124425653477`*^9, 
   3.738812472340839*^9}, {3.7388126807104816`*^9, 3.738812712592723*^9}, {
   3.738812952780024*^9, 3.738812958819738*^9}, {3.738813212421043*^9, 
   3.7388132391420918`*^9}, {3.7388132805875187`*^9, 
   3.7388132973891087`*^9}, {3.738813333617743*^9, 3.738813372687114*^9}, 
   3.738813488563575*^9, {3.7388141948058777`*^9, 3.738814222173703*^9}, {
   3.7388142736591682`*^9, 3.73881427913813*^9}, 3.7388143544749317`*^9, {
   3.738814389905702*^9, 3.7388143907399073`*^9}, 3.738814427539338*^9, {
   3.738814461919682*^9, 3.7388144729128513`*^9}, {3.738814575175157*^9, 
   3.738814575656047*^9}, {3.738814714738791*^9, 3.738814716239456*^9}, {
   3.738815743459681*^9, 3.738815767411634*^9}, {3.738815957666993*^9, 
   3.7388159657159357`*^9}, {3.738816021653267*^9, 3.7388160365588512`*^9}, {
   3.738816092028028*^9, 3.7388162004106627`*^9}, {3.738816331801084*^9, 
   3.7388163754687843`*^9}, {3.7388164067992983`*^9, 
   3.7388164448033237`*^9}, {3.7388178563812647`*^9, 3.738817861239195*^9}, {
   3.7388179785512543`*^9, 3.738818010433988*^9}, {3.7388181092462*^9, 
   3.7388181096629143`*^9}, 3.738818201475974*^9, {3.738818447604685*^9, 
   3.738818527317728*^9}, {3.738818723596468*^9, 3.7388187879027777`*^9}, {
   3.73881883856491*^9, 3.738818855740252*^9}, {3.7388188955022306`*^9, 
   3.738818912339861*^9}, {3.738819258738245*^9, 3.7388192647035713`*^9}, 
   3.738825913202903*^9, {3.7388259748535957`*^9, 3.738825980080407*^9}, {
   3.738826064729279*^9, 3.738826065253895*^9}, {3.738826113713002*^9, 
   3.738826117039275*^9}, {3.7388266822729397`*^9, 3.738826693610182*^9}, {
   3.738826746361178*^9, 3.738826825856421*^9}, {3.738826956277811*^9, 
   3.7388269575910797`*^9}, {3.738827043517346*^9, 3.738827085551318*^9}, {
   3.738827966303248*^9, 3.738827991376156*^9}, {3.738828084816412*^9, 
   3.7388281306705303`*^9}, {3.7388281691805687`*^9, 3.738828177151232*^9}, {
   3.738828210391171*^9, 3.738828210757807*^9}, {3.738828797927228*^9, 
   3.738828846105958*^9}, {3.738828990197994*^9, 3.738829025163063*^9}, 
   3.7388290583800497`*^9, {3.738830124470064*^9, 3.7388301465510073`*^9}, {
   3.738830179263941*^9, 3.738830183385449*^9}, {3.7388307328434553`*^9, 
   3.738830757752715*^9}, {3.738831257880897*^9, 3.73883131192024*^9}, {
   3.7388313896423607`*^9, 3.7388314709213543`*^9}, {3.7388315119849586`*^9, 
   3.7388315123290243`*^9}, {3.738831578918415*^9, 3.73883183008186*^9}, {
   3.7388318791150627`*^9, 3.738831879536839*^9}, {3.738833581540452*^9, 
   3.738833627113887*^9}, {3.738833667051126*^9, 3.738833782104195*^9}, {
   3.7388338427757797`*^9, 3.738833844175221*^9}, {3.738833907593458*^9, 
   3.7388339457994013`*^9}, {3.738833980395178*^9, 3.738834004613112*^9}, {
   3.738834067882966*^9, 3.738834069518359*^9}, {3.738834119638555*^9, 
   3.7388342861260977`*^9}, {3.738834408826069*^9, 3.738834420812027*^9}, 
   3.738834452073022*^9, {3.738834616518153*^9, 3.73883461814741*^9}, {
   3.7388346575153847`*^9, 3.738834678045*^9}, {3.738834748277739*^9, 
   3.738834762829739*^9}, {3.738834843180749*^9, 3.738834874887095*^9}, {
   3.738834972100848*^9, 3.738834985176343*^9}, 3.738835019420224*^9, {
   3.738835054116941*^9, 3.738835128534923*^9}, {3.738835160768633*^9, 
   3.738835177457028*^9}, {3.738835213756261*^9, 3.738835280348607*^9}, 
   3.738835324212681*^9, {3.738835484331285*^9, 3.7388354895223093`*^9}, {
   3.73883552138058*^9, 3.738835524124929*^9}, 3.73883556883239*^9, {
   3.738835654804949*^9, 3.738835657836462*^9}, {3.738835694128648*^9, 
   3.738835695554185*^9}, {3.738836066467765*^9, 3.73883606961935*^9}, {
   3.738836106611779*^9, 3.7388362123072243`*^9}, {3.738836253062928*^9, 
   3.738836254261614*^9}, {3.738836286634225*^9, 3.7388362871927*^9}, {
   3.738836342669091*^9, 3.7388363431542587`*^9}, {3.738836428634219*^9, 
   3.738836454599387*^9}, {3.738836523863577*^9, 3.738836526315316*^9}, {
   3.738836557969956*^9, 3.738836562464867*^9}, {3.738836606856564*^9, 
   3.738836661471819*^9}, {3.73883675090243*^9, 3.7388368362748938`*^9}, {
   3.738837178597063*^9, 3.7388371824327517`*^9}, 3.7388372161845083`*^9, {
   3.738837269382433*^9, 3.738837269416271*^9}, 3.7388374449424963`*^9, {
   3.738837496045783*^9, 3.738837500332024*^9}, {3.738837552261653*^9, 
   3.738837585543799*^9}, {3.738837647129675*^9, 3.73883777581739*^9}, 
   3.738837812525772*^9, {3.738837919536832*^9, 3.7388379930187683`*^9}, {
   3.738838036432955*^9, 3.738838042580205*^9}, 3.738838099371545*^9, {
   3.738838135733729*^9, 3.738838181964676*^9}, {3.738838214770773*^9, 
   3.738838262233615*^9}, {3.7388390576525507`*^9, 3.7388390963655643`*^9}, 
   3.738839274919237*^9, {3.738839840226344*^9, 3.7388398592634487`*^9}, {
   3.738839939097245*^9, 3.738839939696871*^9}, {3.738840007011891*^9, 
   3.738840099287157*^9}, {3.7388401385699*^9, 3.738840198135878*^9}, {
   3.738840865615745*^9, 3.738840872854129*^9}, {3.7388409236843853`*^9, 
   3.73884096602013*^9}, {3.738841017254475*^9, 3.7388410310403233`*^9}, {
   3.738841146352311*^9, 3.738841174589275*^9}, {3.738841343861434*^9, 
   3.738841450347466*^9}, 3.738841528598954*^9, {3.7388415747012253`*^9, 
   3.73884157744184*^9}, {3.7388416711198387`*^9, 3.738841678945138*^9}, {
   3.7388417495888767`*^9, 3.738841777682005*^9}, {3.73884183686548*^9, 
   3.738841878666698*^9}, {3.738841927695389*^9, 3.738842011812895*^9}, {
   3.7388421392197733`*^9, 3.7388421597052937`*^9}, {3.738842193630522*^9, 
   3.738842201385892*^9}, {3.738842317380691*^9, 3.738842333274222*^9}, {
   3.738842378235057*^9, 3.738842389882967*^9}, {3.738842596938476*^9, 
   3.738842614816242*^9}, {3.738842648653036*^9, 3.738842676108631*^9}, {
   3.738842706902055*^9, 3.738842716033716*^9}, {3.7388428640502787`*^9, 
   3.738842925097539*^9}, 3.7388429602439337`*^9, {3.738843014269751*^9, 
   3.73884302550898*^9}, {3.738843118192895*^9, 3.738843126865477*^9}, {
   3.7388431703454943`*^9, 3.738843186642056*^9}, {3.738843223676532*^9, 
   3.738843244792404*^9}, {3.738843520126005*^9, 3.7388435314822903`*^9}, {
   3.738843565981032*^9, 3.738843577519302*^9}, {3.738843632167753*^9, 
   3.7388436361607533`*^9}, {3.738843671731179*^9, 3.738843672188527*^9}, 
   3.7388437197149057`*^9, {3.738843768161397*^9, 3.738843774672407*^9}, {
   3.738843814915325*^9, 3.73884382177323*^9}, {3.738843855672358*^9, 
   3.738843865209333*^9}, 3.738843901185257*^9, {3.738843940790183*^9, 
   3.738843954866819*^9}, {3.738843998101962*^9, 3.7388440020124826`*^9}, {
   3.7388440733171043`*^9, 3.738844200278141*^9}, {3.738844231882313*^9, 
   3.738844280597691*^9}, {3.7388443230579357`*^9, 3.7388443376364737`*^9}, {
   3.738844406125745*^9, 3.738844430177532*^9}, {3.738844725242844*^9, 
   3.738844730698483*^9}, 3.738844770160334*^9, {3.738844809406352*^9, 
   3.7388448525690823`*^9}, {3.738844986668295*^9, 3.738845011254015*^9}, {
   3.738845229074856*^9, 3.7388452476070833`*^9}, {3.738845306209714*^9, 
   3.738845377791523*^9}, {3.738845421719046*^9, 3.738845421862789*^9}, {
   3.7388455072017517`*^9, 3.7388455240162086`*^9}, {3.738845827400179*^9, 
   3.738845832947591*^9}, {3.738845913321204*^9, 3.738845968156272*^9}, {
   3.738846278133501*^9, 3.7388463085653563`*^9}, {3.738846379966164*^9, 
   3.738846400451252*^9}, {3.738846440672421*^9, 3.7388464486935873`*^9}, {
   3.7388464980697613`*^9, 3.738846682982155*^9}, {3.738846747531116*^9, 
   3.7388467693386183`*^9}, {3.7388468120640087`*^9, 
   3.7388468199627934`*^9}, {3.738846890928466*^9, 3.738846905526627*^9}, {
   3.738846953090104*^9, 3.73884695533941*^9}, {3.7388469941071463`*^9, 
   3.7388470072606783`*^9}, {3.738847071566525*^9, 3.73884708194316*^9}, {
   3.738847152425913*^9, 3.73884722390411*^9}, {3.738847278971842*^9, 
   3.7388473200178556`*^9}, {3.738847358102968*^9, 3.738847412690024*^9}, {
   3.7388475020572968`*^9, 3.738847511906055*^9}, 3.738848003038702*^9, {
   3.7388481934300537`*^9, 3.738848193921405*^9}, {3.738848247549049*^9, 
   3.738848251036577*^9}, {3.738849238045087*^9, 3.738849242292199*^9}, {
   3.738849309538056*^9, 3.738849314071939*^9}, {3.7388494059878607`*^9, 
   3.738849450820355*^9}, {3.738891417788151*^9, 3.738891423875266*^9}, {
   3.738891972256503*^9, 3.738892007151329*^9}, {3.738892055439891*^9, 
   3.738892072918766*^9}, {3.738906606660139*^9, 3.738906611964148*^9}, {
   3.738930526517054*^9, 3.738930539346341*^9}, {3.7389305781109257`*^9, 
   3.738930579769636*^9}, {3.7389309150294113`*^9, 3.7389309154793797`*^9}, {
   3.7389309891934757`*^9, 3.738931059737111*^9}, {3.738931117960946*^9, 
   3.738931122194428*^9}, {3.7389319466628447`*^9, 3.7389320286917267`*^9}, {
   3.738932129184638*^9, 3.738932139940708*^9}, {3.7389321938351803`*^9, 
   3.738932313449971*^9}, {3.7389323861851797`*^9, 3.73893238677255*^9}, {
   3.738932435270421*^9, 3.73893246149156*^9}, {3.738932531326169*^9, 
   3.738932531471382*^9}, 3.738932573880685*^9, {3.7389936724094057`*^9, 
   3.738993679195369*^9}, {3.73899373663275*^9, 3.738993754745318*^9}, {
   3.738993795563548*^9, 3.738993799210174*^9}, {3.738993856362008*^9, 
   3.7389938583661203`*^9}, {3.73899388994261*^9, 3.7389938927957687`*^9}, {
   3.7389939390822783`*^9, 3.738994003233346*^9}, 3.738994036814382*^9, 
   3.738994084657504*^9, {3.7389941168950367`*^9, 3.7389941208586893`*^9}, {
   3.7389942044485273`*^9, 3.738994205016755*^9}, {3.738994293379537*^9, 
   3.738994364068906*^9}, 3.738994397775463*^9, {3.738994473241184*^9, 
   3.73899451605055*^9}, {3.7389946781642427`*^9, 3.738994828400632*^9}, {
   3.738994869236059*^9, 3.7389948695236187`*^9}, {3.738994910238647*^9, 
   3.738994921303733*^9}, {3.738994956838559*^9, 3.738994993019993*^9}, {
   3.738995150628275*^9, 3.738995152042945*^9}, {3.738999281056633*^9, 
   3.7389992888819227`*^9}, {3.738999330330769*^9, 3.738999332327626*^9}, {
   3.739162624882743*^9, 3.739162626267249*^9}, {3.739190368605833*^9, 
   3.73919037223446*^9}, {3.739244570580823*^9, 3.739244577684787*^9}, {
   3.739450543901729*^9, 3.739450803153091*^9}, {3.739450935118271*^9, 
   3.73945093952101*^9}, {3.739451018068959*^9, 3.7394510373692303`*^9}, {
   3.739451087058795*^9, 3.739451241802745*^9}, {3.739451397716941*^9, 
   3.73945140811723*^9}, 3.739451452072318*^9, {3.7394515008044558`*^9, 
   3.73945150715361*^9}, {3.739451549672183*^9, 3.739451551756125*^9}, {
   3.7394516089586153`*^9, 3.739451697773964*^9}, {3.739493489861795*^9, 
   3.739493501378922*^9}, {3.739515053777252*^9, 3.739515062901795*^9}, {
   3.739515149607687*^9, 3.739515168725588*^9}, {3.7395185058285713`*^9, 
   3.7395187027052183`*^9}, {3.739518744124344*^9, 3.739518750776147*^9}, {
   3.739518781354446*^9, 3.739519021663453*^9}, {3.7395219253158817`*^9, 
   3.73952197886716*^9}, {3.7395230524358797`*^9, 3.739523138284646*^9}, {
   3.73952812124338*^9, 3.739528153499922*^9}, {3.7395282171043587`*^9, 
   3.739528244067124*^9}, {3.739535232865054*^9, 3.73953523557269*^9}, {
   3.739536443484777*^9, 3.739536445828912*^9}, {3.739536657851467*^9, 
   3.739536703459291*^9}, {3.7395367353944473`*^9, 3.7395367358156147`*^9}, 
   3.7395367804632177`*^9, {3.7395368763444653`*^9, 3.739536883794519*^9}, {
   3.739536930441936*^9, 3.739536930942636*^9}, 3.739537051387546*^9, {
   3.7395371144514523`*^9, 3.739537116842986*^9}, {3.739537154533064*^9, 
   3.739537156406959*^9}, 3.739537186413713*^9, {3.73957873551245*^9, 
   3.739578793595953*^9}, {3.739578882532009*^9, 3.73957896831872*^9}, {
   3.739579009426475*^9, 3.739579083656253*^9}, {3.7395791286414213`*^9, 
   3.739579318383729*^9}, {3.7395793487427607`*^9, 3.739579356199937*^9}, {
   3.739579391202417*^9, 3.73957940805101*^9}, {3.73957946389704*^9, 
   3.739579533467577*^9}, {3.739579638543655*^9, 3.7395796533226137`*^9}, {
   3.7395797297565928`*^9, 3.7395797428550873`*^9}, 3.739580909227367*^9, {
   3.7395813570608683`*^9, 3.739581359558577*^9}, {3.73958140750249*^9, 
   3.739581431050103*^9}, {3.739581540690402*^9, 3.7395815461516237`*^9}, {
   3.7395817164246597`*^9, 3.739581730800861*^9}, {3.7395818654018373`*^9, 
   3.739581886214052*^9}, {3.739587438946089*^9, 3.739587478817905*^9}, {
   3.7395875459818773`*^9, 3.739587583903966*^9}, {3.739587626225973*^9, 
   3.739587660327814*^9}, {3.739587706709835*^9, 3.73958770728692*^9}, {
   3.739833663699842*^9, 3.739833707459004*^9}, {3.739833804710717*^9, 
   3.7398338794331636`*^9}, {3.739833924702697*^9, 3.739834035200547*^9}, {
   3.739834092913933*^9, 3.739834110828122*^9}, {3.739834204390605*^9, 
   3.739834207110132*^9}, {3.739834316510795*^9, 3.739834316994422*^9}, {
   3.739834362385069*^9, 3.739834467477845*^9}, {3.739834597163837*^9, 
   3.739834598216908*^9}, {3.7398346515588703`*^9, 3.739834675046068*^9}, {
   3.739834707492313*^9, 3.739834734847283*^9}, {3.739835357070228*^9, 
   3.739835383221167*^9}, {3.73983635367773*^9, 3.739836354007811*^9}, {
   3.739836390738161*^9, 3.73983641186385*^9}, {3.7398367410728807`*^9, 
   3.739836747404091*^9}, {3.739836822659698*^9, 3.739836877416457*^9}, 
   3.7398369094062347`*^9, {3.7398370060111027`*^9, 3.739837008536695*^9}, {
   3.73983704761985*^9, 3.7398370489526863`*^9}, {3.7398370805834713`*^9, 
   3.739837081151194*^9}, {3.739837604250196*^9, 3.7398376935944967`*^9}, {
   3.739838351247704*^9, 3.739838376547756*^9}, {3.739838489456278*^9, 
   3.7398385587415533`*^9}, {3.741481846153989*^9, 3.741481867819971*^9}, {
   3.741482005170735*^9, 3.74148201484636*^9}, {3.741482053104291*^9, 
   3.7414820654627047`*^9}, {3.741482202337738*^9, 3.7414822397431803`*^9}, {
   3.7414824064479513`*^9, 3.741482425318328*^9}, {3.7414824811816196`*^9, 
   3.7414824891724997`*^9}, {3.741482583594747*^9, 3.741482590421801*^9}, {
   3.741482648779552*^9, 3.74148266354604*^9}, {3.741482712997818*^9, 
   3.741482721148519*^9}, {3.741482790425145*^9, 3.7414827990801573`*^9}, {
   3.741999601145639*^9, 3.7419996156682*^9}, {3.741999716707511*^9, 
   3.7419997808625517`*^9}, {3.742000042187173*^9, 3.7420000431312847`*^9}, {
   3.742001227630863*^9, 3.742001277758662*^9}, {3.7420015652500563`*^9, 
   3.742001619605769*^9}, 3.742090431245626*^9, {3.742090497207143*^9, 
   3.742090497835956*^9}, {3.742090578791581*^9, 3.7420905813216743`*^9}, {
   3.742714881980404*^9, 3.742714954583981*^9}, {3.74272127826396*^9, 
   3.7427213113361197`*^9}, {3.742723102865748*^9, 3.7427232474722853`*^9}, {
   3.742798335473284*^9, 3.7427984120445147`*^9}, 3.742798571128664*^9, {
   3.742901961194191*^9, 3.742901980807929*^9}},
 ExpressionUUID -> "9967d84a-0fad-4e1e-a888-dd6baf18ece5"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Zentrum :\"\>", TextForm]], "InlineText"],
      Text["Zentrum :"]], 
     InputFieldBox[Dynamic[$CellContext`inputCenter], String]},
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Seitenlaenge (km) : \"\>", TextForm]], "InlineText"],
      Text["Seitenlaenge (km) : "]], 
     InputFieldBox[Dynamic[$CellContext`sideLength], Number]},
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Datum Start : \"\>", TextForm]], "InlineText"],
      Text["Datum Start : "]], 
     InputFieldBox[Dynamic[$CellContext`inputStart], String]},
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Datum Ende : \"\>", TextForm]], "InlineText"],
      Text["Datum Ende : "]], 
     InputFieldBox[Dynamic[$CellContext`inputEnd], String]},
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Minimale Magnitude : \"\>", TextForm]], "InlineText"],
      Text["Minimale Magnitude : "]], 
     InputFieldBox[Dynamic[$CellContext`magnitude], Number]},
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Ausgabe speichern unter : \"\>", TextForm]], "InlineText"],
      Text["Ausgabe speichern unter : "]], 
     InputFieldBox[Dynamic[$CellContext`filename], String]},
    {
     ButtonBox["\<\"Suche starten\"\>",
      Appearance->Automatic,
      ButtonFunction:>($CellContext`stateMessage = 
        "...Interpretiere Texteingabe f\[UDoubleDot]r Zentrum..."; \
$CellContext`center = \
$CellContext`getPositionFromString[$CellContext`inputCenter]; \
$CellContext`start = $CellContext`getDateFromString[$CellContext`inputStart]; \
$CellContext`end = $CellContext`getDateFromString[$CellContext`inputEnd]; \
$CellContext`stateMessage = 
        "...suche nach Erdbeben..."; $CellContext`data = \
$CellContext`getEarthquakeData[$CellContext`center, $CellContext`sideLength, \
$CellContext`start, $CellContext`end, $CellContext`magnitude]; 
       If[Length[$CellContext`data] >= 
         1, $CellContext`stateMessage = StringJoin[
            ToString[
             Length[$CellContext`data]], 
            " Erdbeben gefunden.\n...rendert..."]; 
         NotebookClose[$CellContext`outputNotebook]; \
$CellContext`outputNotebook = CreateDocument[
            ExpressionCell[
             StandardForm[
              $CellContext`renderAll[$CellContext`data, $CellContext`center, \
$CellContext`start, $CellContext`end, $CellContext`filename]], "Output"], 
            WindowTitle -> "Auswertung", WindowSize -> {900, 900}, 
            NotebookFileName -> $CellContext`filename]; \
$CellContext`stateMessage = "fertig"; Null, $CellContext`stateMessage = 
         "Keine Erdbeben im Suchbereich gefunden"]),
      Evaluator->Automatic,
      Method->"Queued"], "\[SpanFromLeft]"},
    {
     InterpretationBox[Cell[BoxData[
       FormBox["\<\"Nachricht : \"\>", TextForm]], "InlineText"],
      Text["Nachricht : "]], 
     InputFieldBox[Dynamic[$CellContext`stateMessage], String,
      Enabled->False]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.74279857515381*^9}]
}, Open  ]]
},
WindowSize->{1280, 960},
WindowMargins->{{4, Automatic}, {-60, Automatic}},
WindowStatusArea->None,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{Automatic, Automatic},
"PostScriptOutputFile"->""},
FrontEndVersion->"11.0 for Linux ARM (32-bit) (January 17, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[582, 22, 34894, 664, 2883, "Input"],
Cell[35479, 688, 3207, 72, 235, "Output"]
}, Open  ]]
}
]
*)

