#!/usr/bin/perl

use lib ('~/perl5/lib/perl5');

use strict; 
use warnings;

use Net::Fritz::Box;

#####################################################################
# re-dsl.pl
#####################################################################
# Prototypes
sub IsDSLInUse($);
sub IsDSLReady($);
sub DoReboot($);

# Credentials
my $USERNAME = 'soapuser';
my $PASSWORD = 's0ap0pera';
#####################################################################
# Connect to FRITZ!Box
my $Fritz = Net::Fritz::Box->new(
  username => $USERNAME,
  password => $PASSWORD,
);
$Fritz->errorcheck;

# Run discovery  
my $Device = $Fritz->discover();
$Device->errorcheck;

if(IsDSLInUse($Device)) {
  print qq|DSL in use\n|;
  exit(0);
}

unless(IsDSLReady($Device)) {
  print qq|DSL not ready\n|;
  exit(0);
}

DoReboot($Device);
print qq|Reboot initiated\n|;

#####################################################################
sub IsDSLInUse($) {
  my $Device = shift(@_) or die;

  my $Service  = $Device->find_service('WANCommonInterfaceConfig:1');
  $Service->errorcheck;
  my $Response = $Service->call('GetCommonLinkProperties');
  $Response->errorcheck;

  my $Data = $Response->data;

  return($Data->{'NewWANAccessType'} =~ /DSL/);
}
#####################################################################
sub IsDSLReady($) {
  my $Device = shift(@_) or die;

  my $Service  = $Device->find_service('WANDSLInterfaceConfig:1');
  $Service->errorcheck;
  my $Response = $Service->call('X_AVM-DE_GetDSLDiagnoseInfo');
  $Response->errorcheck;

  my $Data = $Response->data;

  return($Data->{'NewX_AVM-DE_DSLSync'}  == 1);
}
#####################################################################
sub DoReboot($) {
  my $Device = shift(@_) or die;

  my $Service  = $Device->find_service('DeviceConfig:1');
  $Service->errorcheck;
  my $Response = $Service->call('Reboot');
  $Response->errorcheck;
}
#####################################################################
__END__

=head1 NAME

re-dsl.pl

=head1 DESCRIPTION

Reboot FRITZ!Box if DSL is in sync but not currently in use for the WAN connection. This script uses TR-064 and its corresponding services B<DeviceConfig>, B<WANCommonInterfaceConfig> and B<WANDSLInterfaceConfig> to determine the status and to initiate the reboot.

Visit L<https://avm.de/service/schnittstellen/> for further information.

=head1 SYNOPSIS

./re-dsl.pl

No parameters or options to be supplied.

The variables USERNAME and PASSWORD must be set on valid TR-064 credentials.

This script's file ownership and permissions should be set in ways that the
execution will be allowed and read access will be restricted to an authorized
user and/or group.

=cut

#####################################################################
1;
