unit DXBackDateU_Intl; // 14-DEC-98 as (Arne Schpers)
{ Setzt die Versionsnummern der DirectX-DLLs auf "DirectX 1"
  zurck und macht damit die Reinstallation lterer DX-Versionen
  mglich.
  Das Programm ndert auer dem Registrierungseintrag fr das
  DirectX-Setup *nichts* am System. Es sorgt lediglich dafr,
  da die installierten DirectX-DLLs, Treiber usw. nach
  dem nchsten Neustart eine gehackte Versionsnummer haben.

  Fr Windows 98/2000 mit ihrem spezielen SysBckup-Verzeichnis sieht der
  Ablauf whrend des Neustarts so aus:
  Anforderung: DX-DLL aus Temp-Verzeichnis -> System
  Reaktion des Systems:
    1. DX-DLL aus System -> SysBckup
    2. DX-DLL aus Temp-Verzeichnis -> System
    ...
  Spter beim Hochfahren des Systems:
    3. Versionsvergleich zwischen SysBckup und System. Wenn die Versionsnummer
       einer DLL in System kleiner ist: Rckkopie von SysBckUp -> System

  Das Programm legt aus diesem Grund ein Unterverzeichnis SysBckup\~DXBackdate
  an und trgt pro DX-DLL *zwei* Rename-Befehle in Wininit.ini ein:

  a) DX-DLL aus Temp-Verzeichnis->System
  b) DX-DLL aus SysBckup (= die Originaldatei aus System) -> SysBckup\~DXBackdate.

  Die Originaldateien bleiben auf diese Tour erst mal erhalten; die Automatik ist trotzdem lahmgelegt.
  Das Verzeichnis SysBckUp\~DXBackdate kann nach der Installation der "endgltigen" DX-Version
  ohne weiteres gelscht werden.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, IniFiles, Registry, FileCtrl;
type
  TDXBackForm = class(TForm)
    Label2: TLabel;
    OpenDXInfDialog: TOpenDialog;
    mHelp: TMemo;
    bHelpOK: TButton;
    GroupStep1: TGroupBox;
    bHelp: TButton;
    Label3: TLabel;
    GroupStep2: TGroupBox;
    Label1: TLabel;
    eDirectXINF: TEdit;
    bBrowseDXInf: TButton;
    lWinNTHack: TLabel;
    GroupStep3: TGroupBox;
    mProtocol: TMemo;
    bResetVersionNumbers: TButton;
    cRebootIfDone: TCheckBox;
    Label4: TLabel;
    procedure bBrowseDXInfClick(Sender: TObject);
    procedure bResetVersionNumbersClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure eDirectXINFChange(Sender: TObject);
    procedure bHelpClick(Sender: TObject);
    procedure bHelpOKClick(Sender: TObject);
  private
    IsWindowsNT: Boolean;
    WinDir, SystemDir, TempDir,
    SysBckupDir, SysBckupBackDir: String;
    DXFileList, DXCopyList: TStringList;
  protected
    function CreateModifiedCopy(FName: String): Boolean;
    procedure ResetVersionEntryInRegistry;
    function PendingSystemUpdates: Boolean;
  end;

var DXBackForm: TDXBackForm;

implementation
{$R *.DFM}

procedure TDXBackForm.FormCreate(Sender: TObject);
var Buf: Array[0..MAX_PATH] of Char;
  ProcHandle, Token: THandle;  // NT only (fr Reboot)
  PvOld, PvNew: TTokenPrivileges; Dummy: DWORD;  // dito

  function BufToDir: String;
  begin
    Result := StrPas(Buf);
    if Result[Length(Result)] <> '\'then Result := Result + '\';
  end;

begin
  DXFileList := TStringList.Create;
  DXCopyList := TStringList.Create;
  IsWindowsNT := Win32Platform and VER_PLATFORM_WIN32_NT <> 0;
  if IsWindowsNT then
  begin  // Reboot-Privileg setzen, fixe Dateiliste als Vorgabe
    ProcHandle := GetCurrentProcess;
    if OpenProcessToken(ProcHandle, TOKEN_ADJUST_PRIVILEGES
         or TOKEN_QUERY, Token)
      and LookupPrivilegeValue('','SeShutdownPrivilege',
          PvNew.Privileges[0].LUID) then
    with PvNew do
    begin
     PrivilegeCount := 1;
     Privileges[0].Attributes := SE_PRIVILEGE_ENABLED;
     cRebootIfDone.Enabled := AdjustTokenPrivileges(Token, False,
       PvNew, 4 + 12* PvNew.PrivilegeCount, PvOld, Dummy);
    end;
    eDirectXINF.Text := ExtractFilePath(ParamStr(0))+'DXforNT.INF';
    lWinNTHack.Visible := bResetVersionNumbers.Enabled;
  end else
  begin
    lWinNTHack.Visible := False;
    bResetVersionNumbers.Enabled := False;
  end;
  cRebootIfDone.Checked := cRebootIfDone.Enabled;

  // Windows, System- und TEMP-Verzeichnis ermitteln
  GetWindowsDirectory(Buf,Sizeof(Buf)); WinDir := BufToDir;
  GetSystemDirectory(Buf,SizeOf(Buf)); SystemDir := BufToDir;
  GetTempPath(SizeOf(Buf),Buf); TempDir := BufToDir;
  // Rckwrts-Kontrolle von Windows 9x aushebeln
  SysBckupDir := WinDir+'SysBckup';
  if DirectoryExists(SysBckupDir) then
  begin
    SysBckupBackDir := SysBckupDir+'\'+'~DXBackdate';
    CreateDir(SysBckupBackDir);
    if not DirectoryExists(SysBckupBackDir) then
    begin
      ShowMessage('System Backup (SysBckup) exists, unable to create a "~DXBackdate" subdirectory');
      PostQuitMessage(0);
    end;
  end
    else SysBckupDir := '';

  with mProtocol.Lines do
  begin
    Clear;
    Add('Protocol:'); Add('WinDir = '+WinDir);
    Add('SystemDir = '+SystemDir); Add('TempDir = '+TempDir);
    if SysBckupDir <> '' then Add('System Backup = '+SysBckupDir);
  end;
  if TempDir = AnsiUpperCase(ExtractFilePath(ParamStr(0))) then
  begin
    TempDir := WinDir[1]+':\DXTEMP';
    if not DirectoryExists(TempDir) and
        not CreateDirectory(PChar(TempDir),nil) then
    begin
      ShowMessage('No TEMP dir; creation of '+TempDir+' failed.');
      Halt;
    end else
    begin
      ShowMessage('No TEMP dir; created '+TempDir+
        ' (Please delete this directory after reboot.)');
      TempDir := TempDir + '\';
    end;
  end;
  // Stehen im Moment System-Updates an?
  if PendingSystemUpdates then PostQuitMessage(0);
end;

procedure TDXBackForm.FormDestroy(Sender: TObject);
begin
  DXFileList.Free; DXCopyList.Free;
end;

function TDXBackForm.PendingSystemUpdates: Boolean;
const Renames = 'PendingFileRenameOperations';
var Reg: TRegistry; WinInit: TIniFile; RenameList: TStringList;
    SZMultiBuf: String; SZMultiLen, SZType: DWord; x: Integer;
begin
  Result := False;
  RenameList := TStringList.Create;
  // Existiert im Moment eine Liste mit umzubenennenden Dateien?
  if not IsWindowsNT then
  begin
    WinInit := TIniFile.Create(WinDir+'WININIT.INI');
    WinInit.ReadSectionValues('Rename',RenameList);
    if RenameList.Count <> 0 then
    begin
      RenameList.Insert(0,'System updates pending. '#13#10+
        'Please reboot, and, if this problem persists, '#13#10+
        'clean up '+WinInit.FileName+' by hand.'#13#10+
        'Current entries in '+WinInit.FileName+':');
      ShowMessage(RenameList.Text);
      Result := True;
    end;
    WinInit.Free;
  end;
  // Windows NT und Win98(?)
  Reg := TRegistry.Create;
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    if OpenKey('\SYSTEM\CurrentControlSet\Control\'+
      'Session Manager', False) then
    begin  // REGSZ_MULTI ist anscheinend jenseits von TRegistry
      if RegQueryValueEx(CurrentKey,Renames, nil, @SZType,nil,
         @SZMultiLen) = ERROR_SUCCESS then
      begin
        SetLength(SZMultiBuf,SZMultiLen);
        RegQueryValueEx(CurrentKey,Renames, nil, @SZType,
                     PByte(PChar(SZMultiBuf)), @SZMultiLen);
        for x := SZMultiLen-1 downto 1 do
          if SZMultiBuf[x] = #0 then SZMultiBuf[x] := #13;
        x := Pos(#13'!\??\',SZMultiBuf);
        while x <> 0 do
        begin
          System.Delete(SZMultiBuf,x,5); SZMultiBuf[x] := '=';
          x := Pos(#13'!\??\',SZMultiBuf);
        end;
        RenameList.Text := SZMultiBuf;
        if RenameList.Count <> 0 then
        begin
          RenameList.Insert(0,'System updates pending.'#13#10+
           'Please reboot, and, if this problem persists, '+
           'use RegEdt32 (not RegEdit!) to clear HKLM\SYSTEM\'+
           'CurrentControlSet\Control\'+
           'Session Manager\PendingFileRenameOperations'#13#10+
           'Current Entries are: ');
          ShowMessage(RenameList.Text);
          Result := True;
        end;
      end;
    end;
    Free;
  end;
  RenameList.Free;
end;

procedure TDXBackForm.bResetVersionNumbersClick(Sender: TObject);
var x: Integer; FName: String; WinInit: TIniFile;

   // Kurze Dateinamen fr die Eintrge in Wininit.ini
   function ShortPath(LongPath: String): String;
   var ShortBuf: Array[0..255] of Char;
   begin
     if GetShortPathName(PChar(LongPath),@ShortBuf,255) = 0
       then RaiseLastWin32Error;
     Result := StrPas(ShortBuf);
   end;

begin
  try
    DXFileList.LoadFromFile(eDirectXInf.Text);
  except
    ShowMessage('Can''t read '+eDirectXInf.Text); Exit;
  end;
  DXCopyList.Clear;
  for x := 0 to DXFileList.Count-1 do
  begin
    FName := AnsiUpperCase(Trim(DXFileList[x]));
    if (FName <> '') and (Pos('[',FName) = 0) then
    begin
      // Format von DirectX.INF:
      // 1,Pfad/Dateiname,... (1. Feld =  Diskettennummer)
      // 1,Pfad/Dateiname,...
      // Format von DXForNT.INF:
      // Dateiname
      // Dateiname
      FName := Copy(FName,Pos(',',FName)+1,255);
      if Pos(',',FName) <> 0
            then FName := Trim(Copy(FName,1,Pos(',',FName)-1));
      FName := ExtractFileName(FName);
      if (Pos(Copy(FName,Pos('.',FName)+1,3),'EXEDLLCPLVXD') <> 0)
        and FileExists(SystemDir+FName) then
      begin
        try
          if CreateModifiedCopy(FName) then DXCopyList.Add(FName);
        except
          on E: Exception do
            if MessageDlg(Format('Creation of modified copy failed '+
              'with Error "%s". Continue anyway?', [E.Message]),
                mtError,[mbNo,mbYes], 0) <> mrYes then
            begin
              ShowMessage('Program aborted'); Close; Exit;
            end;
        end;
      end;
    end;
  end;

  if DXCopyList.Count = 0
    then ShowMessage('Nothing to do (wrong INF file)?')
  else
  begin  // Die beim nchsten Systemstart zu kopierenden Dateien
    ResetVersionEntryInRegistry;
    if IsWindowsNT then
    begin  // MoveFileEx -> Registrierungseintrge
      for x := 0 to DXCopyList.Count-1 do
        if not MoveFileEx(PChar(TempDir+DXCopyList[x]),
          PChar(SystemDir+DXCopyList[x]),
        MOVEFILE_DELAY_UNTIL_REBOOT or MOVEFILE_REPLACE_EXISTING)
         then RaiseLastWin32Error;
    end else
    begin  // Windows 9x (Win98 ginge auch mit MoveFileEx)
      WinInit := TIniFile.Create(WinDir+'WININIT.INI');
      for x := 0 to DXCopyList.Count-1 do
      begin
        WinInit.WriteString('rename', ShortPath(SystemDir+DXCopyList[x]), ShortPath(TempDir+DXCopyList[x]));
        // Verschiebt die beim ersten "Rename" (automatisch nach SysBckUp kopierte Originaldatei
        if (SysBckupDir <> '') then
         WinInit.WriteString('rename',ShortPath(SysBckupBackDir)+'\'+DXCopyList[x], ShortPath(SysBckupDir)+'\'+DXCopyList[x]);
      end;
      WinInit.Free;
      if SysBckupDir <> '' then
      begin
        mProtocol.Lines.Add('Current files will be moved to '+SysBckupBackDir);
        mProtocol.Lines.Add('NOTE: Ignore "System files have been changed" msg after reboot');
      end;
    end;

    mProtocol.SelStart := Length(mProtocol.Lines.Text);  // ans Ende

    if cRebootIfDone.Checked then
    begin
      ShowMessage('Done. Click OK to reboot.');
      ExitWindowsEx(EWX_REBOOT,0);
      Close;
    end else
    begin
      ShowMessage('Done. Files with zeroed version numbers will '+
        'be copied on next system restart.');
      Close;
    end;
  end;
end;

procedure TDXBackForm.ResetVersionEntryInRegistry;
var Reg: TRegistry; DXCurVersion, DXVersion: String; x: Integer;
begin
  Reg := TRegistry.Create;
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    if OpenKey('\Software\Microsoft\DirectX',False) then
    begin
      DXCurVersion := ReadString('Version');
      if DXCurVersion <> '' then
      begin
        DXVersion := DXCurVersion;
        if Win32MajorVersion = 4 then DXVersion[1] := '4';
        for x := Pos('.',DXVersion)+1 to Length(DXVersion) do
          if DXVersion[x] <> '.' then DXVersion[x] := '0';
        WriteString('Version',DXVersion);
        mProtocol.Lines.Add(Format('%s from %s to %s',
          ['\HKLM\Software\Microsoft\DirectX\Version',
           DXCurVersion, DXVersion]));
      end
        else mProtocol.Lines.Add('Registry: No DX version entry');
    end;
    Free;
  end;
end;

function TDXBackForm.CreateModifiedCopy(FName: String): Boolean;
var Buf: Pointer; FixedFileInfo, PInfo: PVSFixedFileInfo;
    BufSize: Integer; Dummy: DWord; FFInfoLen: UINT;
    FStream: TFileStream; Stream: TMemoryStream;
    x: Integer; FoundInfo: Boolean; InfoCount: Integer;
    Prec3, Prec4: Integer;

  procedure ShowError(Msg: String);
  begin
    mProtocol.Lines.Add(FName+': *** '+Msg);
    raise Exception.Create(FName+': '+Msg);
  end;
begin
  Result := False;
  BufSize := GetFileVersionInfoSize(PChar(SystemDir+FName),Dummy);
  if BufSize = 0 then
  begin
    ShowError('no version information');
    Exit;
  end;
  Stream := nil;
  GetMem(Buf,BufSize);
  try
    if not GetFileVersionInfo(PChar(SystemDir+FName),0,BufSize,Buf)
      then ShowError('no file version info');

    if not VerQueryValue(Buf, '\', Pointer(FixedFileInfo), FFInfoLen)
      then ShowError('no fixed file info (shouldn''t happen)');

    // CopyFile haut bei schreibgeschtzten Dateien unter NT daneben
    try
      FStream := TFileStream.Create(SystemDir+FName,
          fmOpenRead or fmShareDenyNone);
      Stream := TMemoryStream.Create;
      Stream.CopyFrom(FStream,0); FStream.Free;
    except
      ShowError('Can''t read from '+FName+
        '. Not logged in with admin rights?');
    end;

    // Signaturprfungen etc. sind unntig - hat GetFileVersion
    // mehr als ausreichend erledigt. Suche in der Datei nach
    // dem FILEINFO-Eintrag (brute force)
    PInfo := Stream.Memory; FoundInfo := False; InfoCount := 0;
    for x := 1 to Stream.Size-SizeOf(FixedFileInfo^) do
    begin
      if (PDWORD(PInfo)^ = FixedFileInfo^.dwSignature) then
      begin
        if CompareMem(PInfo,FixedFileInfo, SizeOf(FixedFileInfo))
        then with PInfo^ do
        begin
          if not FoundInfo then
          begin
            if HiWord(dwFileVersionMS) > 4 then
            begin
              Prec3 := 4; Prec4 := 2;
            end else
            begin
              Prec3 := 2; Prec4 := 4;
            end;
            mProtocol.Lines.Add(Format('%s: FileVersion '+
             '%d.%.2d.%.*d.%.*d', [FName, HiWord(dwFileVersionMS),
             LoWord(dwFileVersionMS),
             Prec3, HiWord(dwFileVersionLS),
             Prec4, LoWord(dwFileVersionLS)]));
            FoundInfo := True;
          end;
          Inc(InfoCount);
          // Betriebssystemversion bleibt, den Rest auf 0 setzen
          if Cardinal(Win32MajorVersion) < dwFileVersionMS shr 16
           then dwFileVersionMS := Win32MajorVersion shl 16
           else dwFileVersionMS := dwFileVersionMS and $FFFF0000;
          dwFileVersionLS := 0;
          // Falls da wer nach PRODUCTINFO guckt
          if Cardinal(Win32MajorVersion) < dwProductVersionMS shr 16
            then dwProductVersionMS := Win32MajorVersion shl 16
            else dwProductVersionLS := dwProductVersionLS and $FFFF0000;
          dwProductVersionLS := 0;
          // Dateidatum auf 1.1.1980
          dwFileDateMS := 0; dwFileDateLS := 0;
        end;
      end;
      Inc(PByte(PInfo));  // kein Alignment, nicht mal auf WORDs
    end;
    if not FoundInfo then ShowError('Can''t locate FILEVERSION');

    if InfoCount > 1 then mProtocol.Lines.Add(
        Format('    %d localized FILEVERSION infos',[InfoCount]));
    Stream.SaveToFile(TempDir+FName);
    Result := True;
  finally
    Stream.Free;
    FreeMem(Buf);
  end;
end;

// --- Verdrahtung der Schaltflchen & Online-Doku ---
procedure TDXBackForm.bHelpClick(Sender: TObject);
begin
  mHelp.Align := alClient; mHelp.Visible := True;
  mHelp.BringToFront;
  bHelpOK.Visible := True; bHelpOK.BringToFront;
end;

procedure TDXBackForm.bHelpOKClick(Sender: TObject);
begin
  bHelpOK.Visible := False; mHelp.Visible := False;
end;

procedure TDXBackForm.bBrowseDXInfClick(Sender: TObject);
begin
  with OpenDXInfDialog do
  begin
    InitialDir := ExtractFilePath(FileName);
    FileName := 'DirectX.INF';
    if Execute then eDirectXInf.Text := FileName;
  end;
end;

procedure TDXBackForm.eDirectXINFChange(Sender: TObject);
var FName: String;
begin
  FName := AnsiUpperCase(eDirectXINF.Text);
  bResetVersionNumbers.Enabled := (Pos('.INF',FName) <> 0)
     and (FileExists(FName));
end;
end.

