/**********************************/
/* Punkt (Applikation)            */
/* Kai-Uwe Mrkor                  */
/* 1998                           */
/**********************************/
#include <windows.h>
#include <windowsx.h>
#include "resource.h"

HINSTANCE globInstance; /* Handle auf die Instanz des Programms */
HMENU     hmenue;       /* PopUp-Men */
HBITMAP   hbmLogo;      /* Handle auf ein Bitmap */
BITMAP    bm;           /* Bitmap-Struktur */
HINSTANCE hDLL;         /* Handle auf die DLL */

#define MYWM_Punkt     (WM_APP+100) /* ein paar selbstgebaute */ 
#define MYWM_DialogAn  (WM_APP+101) /* Windows-Nachrichten    */

typedef void (*INITPROC)(HINSTANCE, BOOL);
INITPROC InitProc; /* Zeiger auf eine DLL-Funktion */

enum {EIN,AUS} hook;      /* Merker fr Filter-Aktivitt */
HICON          hIcon[2];  /* Handles auf Tray-Icons */

/*************************************************/
/*   fgt Icon in das Statusfeld (Taskbar) ein   */
/*************************************************/
void AddTaskBarIcon(HWND hWnd, HICON hIcon) 
{
	NOTIFYICONDATA	icondaten;

	icondaten.cbSize = sizeof(NOTIFYICONDATA);
	icondaten.hWnd = hWnd;
	icondaten.uID = 3004;
	icondaten.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	icondaten.uCallbackMessage = MYWM_Punkt;
	icondaten.hIcon = hIcon;
	lstrcpyn(icondaten.szTip, "Kais Punkt", sizeof("Kais Punkt"));
	Shell_NotifyIcon(NIM_ADD, &icondaten);
}

/****************************************/
/*   entfernt Icon aus dem Statusfeld   */
/****************************************/
void DeleteTaskBarIcon(HWND hWnd) 
{ 
	NOTIFYICONDATA icondaten;

	icondaten.cbSize = sizeof(NOTIFYICONDATA);
	icondaten.hWnd = hWnd;
	icondaten.uID = 3004;
	Shell_NotifyIcon(NIM_DELETE, &icondaten);
}

/****************************************/
/*   modifiziert Icon im Statusfeld     */
/****************************************/
void ModifyTaskBarIcon(HWND hWnd) 
{ 
	NOTIFYICONDATA icondaten;

	icondaten.cbSize = sizeof(NOTIFYICONDATA);
	icondaten.hWnd = hWnd;
	icondaten.uID = 3004;
	icondaten.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	icondaten.uCallbackMessage = MYWM_Punkt;
	if (hook==EIN)
		icondaten.hIcon = hIcon[0];
	else
		icondaten.hIcon = hIcon[1];
	lstrcpyn(icondaten.szTip, "Kais Punkt", sizeof("Kais Punkt"));
	Shell_NotifyIcon(NIM_MODIFY, &icondaten);
}

/******************/
/*   DialogProc   */
/******************/ 
LRESULT CALLBACK DialogProc(HWND hDlg, UINT uMsg,
                            WPARAM wParam, LPARAM lParam)
{
	POINT   pos;
	HDC     hdc, hMemDC;
	HBITMAP hbmOld;

	switch (uMsg)
	{
		case WM_CLOSE:    /* Fenster verstecken, statt es zu schlieen */
				ShowWindow( hDlg, SW_HIDE);  /* Fenster ausblenden */
				break;

		case WM_CREATE:   /* Erzeugen des Fensters */
				hook=EIN;
				AddTaskBarIcon(hDlg, hIcon[0]); /*Icon in Taskbar einf.*/
				hmenue=CreatePopupMenu();       /*PopUp-Men erzeugen  */
				AppendMenu(hmenue, MF_STRING, MYWM_DialogAn,"&ber Punkt");
				AppendMenu(hmenue, MF_SEPARATOR, 0,NULL);
				AppendMenu(hmenue, MF_STRING, WM_DESTROY,"&Beenden");
				break;

		case WM_PAINT:   /* Fensterinhalt ausgeben/aktualisieren */
				hdc    = GetDC(hDlg);
				hMemDC = CreateCompatibleDC(hdc);
				hbmOld = SelectObject(hMemDC, hbmLogo);
				BitBlt(hdc,0,0,bm.bmWidth,bm.bmHeight,hMemDC,0,0,SRCCOPY);
				SelectObject(hMemDC, hbmOld);
				DeleteDC(hMemDC);
				ReleaseDC(hDlg, hdc);
				break;

		case WM_COMMAND: /* "Kommando" vom Taskbar-Dialog */
				switch ( GET_WM_COMMAND_ID(wParam, lParam))
				{
					case WM_DESTROY:
							DestroyMenu(hmenue);
							DeleteTaskBarIcon(hDlg);
							PostQuitMessage(0);
							break;

					case MYWM_DialogAn:
							ShowWindow( hDlg, SW_RESTORE);
							SetForegroundWindow( hDlg);
							break;
				}

		case MYWM_Punkt:	/* Taskbar-Icon */
				switch(lParam)
				{
					case WM_LBUTTONDOWN:
							if (hook==EIN)
							{
								InitProc(hDLL, FALSE);
								hook=AUS;
							}
							else
							{
								InitProc(hDLL, TRUE);
								hook=EIN;
							}
							ModifyTaskBarIcon(hDlg);
							break;

					case WM_RBUTTONDOWN:
							GetCursorPos( &pos);
							SetForegroundWindow (hDlg);
							TrackPopupMenu(hmenue, 0, pos.x, pos.y, 0, hDlg, NULL);
							PostMessage(hDlg, WM_USER, 0, 0);
							break;

					default:
							return FALSE;
				}

		default:
				return (DefWindowProc(hDlg,uMsg,wParam,lParam));
	}

	return FALSE;
}

/***************/
/*   WinMain   */
/***************/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,int nCmdShow)
{
	MSG       msg;
	HWND      hwDialog;
	WNDCLASS  wnd;     /* Fensterklassen-Struktur */

	/* einige Initialisierungen */
	globInstance=hInstance;
	hbmLogo=LoadBitmap(globInstance, "IDB_LOGO");
	GetObject(hbmLogo, sizeof(bm), (LPSTR)&bm);
	hDLL= LoadLibrary("Punkt.dll");
	if (hDLL==NULL)
	{
		MessageBox(NULL, "Punkt.DLL nicht gefunden!",
		           "kritischer Fehler", MB_OK);
		return -1;
	}

	InitProc = (INITPROC)GetProcAddress(hDLL, "DLLInit");
	InitProc(hDLL, TRUE); /* Initialisieren der Hook-Funktion */

	hIcon[0]=LoadIcon(hInstance, MAKEINTRESOURCE(IDI_Punkt));
	hIcon[1]=LoadIcon(hInstance, MAKEINTRESOURCE(IDI_Punkt1));

	/* Fensterklasse registrieren */
	wnd.style=0;
	wnd.lpfnWndProc=DialogProc;
	wnd.cbClsExtra=0;
	wnd.cbWndExtra=0;
	wnd.hInstance=hInstance;
	wnd.hIcon=hIcon[0];
	wnd.hCursor=LoadCursor(NULL,IDC_ARROW);
	wnd.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
	wnd.lpszMenuName=NULL;
	wnd.lpszClassName="PunktKlasse"; 
	RegisterClass( &wnd);

	/* Dialogfenster erzeugen */
	hwDialog=CreateWindow("PunktKlasse", "Punkt",
	                      WS_MINIMIZEBOX | WS_SYSMENU,
	                      30,30,bm.bmWidth,
	                      bm.bmHeight+GetSystemMetrics(SM_CYCAPTION),
	                      NULL, NULL, hInstance, NULL);

	while (GetMessage(&msg, NULL, 0, 0)) /* die Nachrichtenschleife */
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	if (hook==EIN)
		InitProc(hDLL, FALSE); /* Entfernen der Hook-Funktion */
	FreeLibrary(hDLL);       /* Freigabe der DLL */

	return msg.wParam;       /* und tsch */
}


