#!/usr/bin/perl
#
# check: check if hosts are up and redirect traffic
#
# syntax: ./check host1 host2 ...
#
# needs explicit routes with gateway for each host
#
# copyright c't/juergen schmidt


# some variables
$ping="/usr/local/bin/fping";
$route="/sbin/route";
$admin="root\@localhost";


sub get_gate {
# return gateway to host 
  my ($iaddr, $host, $routes, $gate);
  # convert to dotted adress
  $iaddr = gethostbyname($_[0]);
  # some black magic to convert adress to string
  $addr = join ".", unpack ('C4', $iaddr);
  $routes = `$route -n`;
  # parse routes
  foreach ( split( '\n', $routes ) ) {
    # Format: IP-Adresse Gateway
    if ( /$addr +([\d,.]+)/ ) {
      return $1;
    }
  }
  die "no gateway found for $addr\n";
}

#
# Main
#

@whosts = @ARGV or die "usage: $0 host1 host2, ...\n";

# Loop forever
while ( true ) {
  %goodhosts=""; %badhosts="";
  # check which servers are up 
  foreach $host ( @whosts ) {
    (my $ret);
    $ret = `$ping $host`;
    if ( $? == 0 ) {
      $goodhosts{$host} = $host;
    } else {
      $badhosts{$host} = $host;
    }
  }

  unless ( %goodhosts ) { 
    print "No hosts reachable\n";
    # ring all bells
    exit 1;
  }

  foreach $host ( keys %badhosts ) {

    # send ALARM
    system "mail -s \"ALARM: host $host is down\" $admin </dev/null >/dev/null 2>&1 ";
    
    # cycle through goodhost list
    unless ( ($ghost, undef) = each %goodhosts ) {
      # restart after end of list
      ($ghost, undef) = each %goodhosts;
    }

    # get gateway to set route
    $newgate = get_gate($ghost);

    # set new routes
    system "$route del $host";
    system "$route add $host gw $newgate";
    # print "redirected $host to $newgate\n";
  }

  # wait for next run
  sleep 60;
}
