/**************************************************************************/
/**************************************************************************/
/**                                                                      **/
/**               TU Muenchen - Institut fuer Informatik                 **/
/**                                                                      **/
/** Program for the game of Solitair  V1.1                               **/
/**                                                                      **/
/**            Joern Eichler                                             **/
/**            Jochen Jaeger                                             **/
/**            Thomas Ludwig                                             **/
/**                                                                      **/
/** File:      scan_table.c                                              **/
/**                                                                      **/
/**************************************************************************/
/**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#ifndef STYPE
#define STYPE unsigned long long
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

#define INDEX_STEP 2048

extern FILE *disktable;

struct HashEntry {
    STYPE hashindex;		/* The board */
    STYPE solutions;		/* Number of solutions from this pos. */
};

#ifndef BIG_ENDIAN
#define BIG_ENDIAN 4321
#endif
#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN 1234
#endif

extern unsigned short byte_order;
STYPE little_to_big(STYPE x);

int reads = 0, seeks = 0;

// here comes the index for the disktable
// every entry corresponds to the key of the x*INDEX_STEPth entry
// of the disktable file
#include "disktable.index"

// use the index table to determine where to start the search
// on the disktable file
// return the number of solutions if found, else 0
STYPE index_search(STYPE key)
{
    int i, j;
    struct HashEntry h;
// search the whole index
    for (i = 0; i < sizeof(index) / sizeof(STYPE); i++)
	if (key < index[i])
	    break;
// if i is 0 then the searched key is not in the database
    if (i == 0)
	return 0;
// now the key is between index[i-1] and index[i]
    // seek to the position where the key index[i-1] is stored
    i--;
    seeks++;
    fseek(disktable, i * INDEX_STEP * sizeof(struct HashEntry), SEEK_SET);
// now scan maximally INDEX_STEP entries for the key
    for (j = 0; j <= INDEX_STEP; j++) {
	reads++;
	fread((void *) &h, sizeof(struct HashEntry), 1, disktable);
	if (feof(disktable)) {
	    printf("!");
	    return 0;
	}
	if(byte_order==LITTLE_ENDIAN)
	  {
	    h.hashindex=little_to_big(h.hashindex);
	    h.solutions=little_to_big(h.solutions);
	  }
	if (key == h.hashindex)
	    return h.solutions;
	else if (key < h.hashindex) {
	    break;
	}
    }
    if (--j == INDEX_STEP && key > h.hashindex)
	printf("Warning! Inconsistency %d %d %lld %lld\n", i, j, key, h.hashindex);
    return 0;
}

STYPE read_key(int index)
{
    struct HashEntry h;
    seeks++;
    fseek(disktable, index * sizeof(struct HashEntry), SEEK_SET);
    reads++;
    fread((void *) &h, sizeof(struct HashEntry), 1, disktable);
    return h.hashindex;
}
