/**************************************************************************/
/**************************************************************************/
/**                                                                      **/
/**               TU Muenchen - Institut fuer Informatik                 **/
/**                                                                      **/
/** Program for the game of Solitair  V1.1                               **/
/**                                                                      **/
/**            Joern Eichler                                             **/
/**            Jochen Jaeger                                             **/
/**            Thomas Ludwig                                             **/
/**                                                                      **/
/** File:      solitair.h                                                **/
/**                                                                      **/
/**************************************************************************/
/**************************************************************************/

/**************************************************************************/
/* board representation                                                   */
/*                                                                        */
/* for the reason of easier symmetrie calculations we use the following   */
/* internal representation of the board:                                  */
/* xy means: byte x, bit y                                                */
/*                                                                        */
/*                            00 04 02                                    */
/*                            01 05 03                                    */
/*                      12 13 07 06 37 31 30                              */
/*                      14 15 16 40 36 35 34                              */
/*                      10 11 17 26 27 33 32                              */
/*                            23 25 21                                    */
/*                            22 24 20                                    */
/*                                                                        */
/**************************************************************************/

#ifndef _SOLITAIR_H
#define _SOLITAIR_H

#ifndef MAX_MOVE
#define MAX_MOVE 31
#endif

/* the type for the hash index and number of solutions   */
/* both need more than 32-bit. gcc calls the 64-bit ints */
/*   long long                                           */

#ifndef STYPE
#define STYPE unsigned long long
#endif

#define ULONG unsigned long

/* some macros to easily access the board */

#define BoardIndex(X)  ( (X) >> 3 )
#define BoardOffset(X) ( (X) & 7 )

#define setsquare(X,Y) ( X[(Y)>>3]|=1<<((Y)&7) )

#define clearsquare(X,Y) ( X[(Y)>>3]&=~(1<<((Y)&7)) )

/* set or unset a square depending on 'value' */
void putsquare(unsigned char *board,int square,int value)
{
  if(value) setsquare(board,square);
  else clearsquare(board,square);
}

#define getsquare(X,Y) ( (X[(Y)>>3] & (1<<((Y)&7))) >> ((Y)&7) )

/**************************************************************************/
/* table of possible moves                                                */
/* for each square there is one entry specifying the number of possible   */
/* moves (actualy it's twice the number because each move takes two       */
/* entries) from that square.                                             */
/* then there are the two squares used for these moves.                   */
/* first the square that is jumped over and then the target square        */
/* using the internal board representation:                               */
/*                                                                        */
/* square 0 is 00 (byte 0 bit 0)                                          */
/* square 1 is 01 (byte 0 bit 1)                                          */
/* ...                                                                    */
/* square 8 is 10 (byte 1 bit 0)                                          */
/* square 9 is 11 (byte 1 bit 1)                                          */
/* ...                                                                    */
/*                                                                        */
/**************************************************************************/

int move_pos[9*33] = {
  4, 4,2, 1,7, 0,0, 0,0,	/* square 0 */
  4, 5,3, 7,14, 0,0, 0,0,	/* square 1 */
  4, 4,0, 3,31, 0,0, 0,0,
  4, 5,1, 31,30, 0,0, 0,0,
  2, 5,6, 0,0, 0,0, 0,0,
  2, 6,32, 0,0, 0,0, 0,0,

  8, 5,4, 31,25, 32,22, 7,11,
  8, 1,0, 6,31, 14,15, 11,10,

  4, 12,10, 9,15, 0,0, 0,0,
  4, 13,11, 15,22, 0,0, 0,0,
  4, 12,8, 11,7, 0,0, 0,0,
  4, 13,9, 7,6, 0,0, 0,0,
  2, 13,14, 0,0, 0,0, 0,0,
  2, 14,32, 0,0, 0,0, 0,0,

  8, 7,1, 32,30, 15,19, 13,12,
  8, 14,7, 22,23, 19,18, 9,8,

  4, 17,23, 20,18, 0,0, 0,0,
  4, 23,30, 21,19, 0,0, 0,0,
  4, 19,15, 20,16, 0,0, 0,0,
  4, 15,14, 21,17, 0,0, 0,0,
  2, 21,22, 0,0, 0,0, 0,0,
  2, 22,32, 0,0, 0,0, 0,0,

  8, 32,6, 23,27, 21,20, 15,9,
  8, 30,31, 27,26, 17,16, 22,15,

  4, 25,31, 28,26, 0,0, 0,0,
  4, 31,6, 29,27, 0,0, 0,0,
  4, 28,24, 27,23, 0,0, 0,0,
  4, 29,25, 23,22, 0,0, 0,0,
  2, 29,30, 0,0, 0,0, 0,0,
  2, 30,32, 0,0, 0,0, 0,0,

  8, 32,14, 29,28, 31,3, 23,17,
  8, 6,7, 3,2, 25,24, 30,23,

  8, 6,5, 30,29, 22,21, 14,13	/* middle square */
};

/**************************************************************************/
/* data types for the hash table                                          */
/**************************************************************************/

#define HASHENTRY HashEntry

struct HashEntry
{
  STYPE hashindex;	        /* The board */
  STYPE solutions;		/* Number of solutions from this pos. */
};


#ifdef WWW
/* names of squares in alphanumerical description */
char *sqnames[]={"c7","c6","e7","e6","d7","d6","d5","c5",
	       "a3","b3","a5","b5","a4","b4","c4","c3",
	       "e1","e2","c1","c2","d1","d2","d3","e3",
	       "g5","f5","g3","f3","g4","f4","e4","e5",
	       "d4"};
#endif

/**************************************************************************/
/* symmetrie functions prototypes                                         */
/**************************************************************************/

extern void normalize_board(unsigned char *);

/**************************************************************************/
/* prototype for disk file hash function in file scan_table.c             */
/**************************************************************************/

#ifdef UseIndexTab
STYPE index_search(STYPE);
#endif

#endif
