VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmMonatskalender 
   Caption         =   "Monatskalender einfgen"
   ClientHeight    =   1305
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4050
   OleObjectBlob   =   "frmMonatskalender.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmMonatskalender"
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'Fgt einen Monatskalender als Tabelle ein
' 1999, Ralf Nebelo

Dim vntMonthArray As Variant

Private Sub UserForm_Initialize()
    Dim intI As Integer
    
    vntMonthArray = Array("Januar", "Februar", "Mrz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember")
    For intI = 1 To 12
        cmbMonat.AddItem vntMonthArray(intI - 1)
    Next
    cmbMonat.ListIndex = Month(Now) - 1

    For intI = 1900 To 2100
        cmbJahr.AddItem Format(intI, "####")
    Next
    cmbJahr.ListIndex = Year(Now) - 1900
End Sub

Private Sub cmdOK_Click()
    Dim intYear As Integer
    Dim intMonth As Integer
    Dim vntDayArray As Variant
    Dim objTable As Table
    Dim intI As Integer
    Dim intFirstDay As Integer
    Dim intDayCount As Integer
    
    intYear = cmbJahr.Value
    intMonth = cmbMonat.ListIndex + 1
    vntDayArray = Array("Mo", "Di", "Mi", "Do", "Fr", "Sa", "So")
    
    Set objTable = ActiveDocument.Tables.Add(Range:=Selection.Range, NumRows:=8, NumColumns:=7)
    With Selection
        .MoveRight Unit:=wdCharacter, Count:=7, Extend:=wdExtend
        .Cells.Merge
        .TypeText Text:=vntMonthArray(intMonth - 1) & " " & Format(intYear, "####")
        .MoveRight Unit:=wdCell
        
        For intI = 1 To 7
            .TypeText vntDayArray(intI - 1)
            .MoveRight Unit:=wdCell
        Next
        
        intFirstDay = WeekDay(Date:=DateSerial(Year:=intYear, Month:=intMonth, Day:=1), FirstDayOfWeek:=vbMonday)
        For intI = 1 To intFirstDay - 1
            .MoveRight Unit:=wdCell
        Next
        
        intDayCount = Day(Date:=DateSerial(Year:=intYear, Month:=intMonth + 1, Day:=0))
        For intI = 1 To intDayCount
            .TypeText Format(intI, "00")
            .MoveRight Unit:=wdCell
        Next
    End With
    
    With objTable
        .AutoFormat Format:=wdTableFormatSimple1
        .Rows(2).Select
        With Selection
            .Font.ColorIndex = wdBlue
            While .Information(wdWithInTable) = True
                .MoveDown Unit:=wdLine
            Wend
        End With
    End With
    
    Unload Me
End Sub

Private Sub cmdCancel_Click()
    Unload Me
End Sub
