// c't Programmierkurs
// Autor: Matthias Kalle Dalheimer, 1999
// AutoTest6.java
// Auto-Verwaltung mit Vector-Objekten, die Daten werden persistent
// gemacht und zu Programmbeginn wieder eingelesen.

import java.io.*;
import java.util.Vector;

class AutoTest6
{
    public static void main( String[] args ) {
	// Auto6-Objekte aus auto.dat einlesen, sofern vorhanden
	
	// dazu einen passenden Stream erzeugen
	Vector autos = null;
	try {
	    ObjectInputStream in = 
		new ObjectInputStream( 
		    new FileInputStream( "auto.dat" ) );
	    
	    // und aus diesem einlesen und einen Vector erzeugen
	    autos = (Vector)in.readObject();
	    
	    // Eingabedatei wird nicht mehr gebraucht; wieder schlieen
	    in.close();
	} catch( StreamCorruptedException sce ) {
	    System.out.println( "Eingabedatei ist korrupt. " +
				"Keine Daten eingelesen." );
	} catch( FileNotFoundException fnfe ) {
	    System.out.println( "Eingabedatei existiert nicht. " +
				"Keine Daten eingelesen." );
	} catch( ClassNotFoundException cnfe ) {
	    System.out.println( "Eingabedatei enthlt unbekannte " +
				"Klasse. Keine Daten eingelesen." );
	} catch( IOException ie ) {
	    System.out.println( "Allgemeiner Fehler beim Einlesen. " +
				"Keine Daten eingelesen" );
	    System.out.println( ie.toString() );
	}
	
	// Wenn beim Einlesen etwas schief gegangen ist, dann gibt es
	// das Objekt autos noch nicht, also erzeugen.
	if( autos == null )
	    autos = new Vector();
	
	// auf Wunsch weitere Auto6-Objekte erzeugen und einlesen
	boolean abbrechen = false;
	do {
	    Auto6 neuesauto = new Auto6();
	    abbrechen = neuesauto.datenEingeben();
	    if( abbrechen != true )
		autos.addElement( neuesauto );
	} while( abbrechen != true );
	
	// Auto-Daten auf dem Bildschirm ausgeben
	for( int i = 0; i < autos.size(); i++ ) 
	    System.out.println( "Auto " + (i+1) + ": " + 
				((Auto6)autos.elementAt( i )).beschreibung() );
	
	// und nach auto.dat schreiben
	try {
	    ObjectOutputStream out = 
		new ObjectOutputStream( 
		    new FileOutputStream( "auto.dat" ) );
	    out.writeObject( autos );
	    out.flush();
	    out.close();
	} catch( IOException ie ) {
	    System.out.println( "Fehler beim Abspeichern von " +
				"auto.dat" );
	    System.out.println( ie.toString() );
	}
    }
}
