/**
 * c't Programmierkurs
 * AWTHalloEuropa.java: Ein einfaches GUI-Programm mit dem AWT
 * Copyright 1999 Matthias Kalle Dalheimer
 */

import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AWTHalloEuropa extends Frame
{
	// Die main()-Methode: Hier startet das Programm.
	public static void main( String args[] ) {

		// Konstruieren eines neuen AWTHalloEuropa-Objektes
		AWTHalloEuropa hallo = new AWTHalloEuropa( "Hallo Europa" );

		// Festlegen der Fenstergre
		hallo.setSize( 150, 100 );

		// Anzeigen des Fensters
		hallo.show();
	}


	// Der Konstruktor von AWTHalloEuropa
	public AWTHalloEuropa( String fenstertitel ) {
		// Weitergeben des Fenstertitels an den Konstruktor der Basisklasse
		super( fenstertitel );

		// Erzeugen einer Label-Komponente
		Label label = new Label( "Hallo Europa", Label.CENTER );
		add( BorderLayout.CENTER, label );

		// Registrieren eines Listeners, der das Schlieen des
		// Fensters bemerkt und dann das Programm beendet.
		addWindowListener( new WindowAdapter() {
			public void windowClosing( WindowEvent event ) {
				// Ressourcen freigeben
				dispose();

				// Programm beenden
				System.exit( 0 );
			}
		} );
	}
}
