/**
 * c't Programmierkurs
 * AWTEuroApplet.java: Whrungsumrechnungen als Applet mit dem AWT
 * Copyright 1999 Matthias Kalle Dalheimer
 */

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;

public class AWTEuroApplet extends Applet
{
	// Umrechnungskurse
	double[] kurse = {
		1.95583, // DEM
		40.3399, // BFR
		5.94573, // FIM
		6.55957, // FRF
		2.20371, // NLG
		.787564, // IEP
		1936.27, // ITL
		40.3399, // LUF
		13.7603, // ATS
		200.482, // PTE
		166.386, // ESP
	};
	
	// Komponenten
	TextField eingabe;
	Choice waehrung;
	Label ausgabe;

	// Der Konstruktor von AWTHalloEuropa
	public void init() {
		// Erzeugen einer Text-Field-Komponente, in der der Benutzer
		// den Betrag in Euro eingibt.
		eingabe = new TextField( "          " );

		// Registrieren einer Methode, die ausgefhrt wird, wenn der
		// Benutzer im Textfeld die Return-Taste drckt.
		eingabe.addActionListener( new ActionListener() {
			public void actionPerformed( ActionEvent e ) {
				compute();
			}
		} );

		// Anorden des Eingabefeldes am oberen Fensterrand
		add( BorderLayout.NORTH, eingabe );

		// Erzeugen einer Auswahl-Komponente, in mit der der Benutzer
		// die Zielwhrung auswhlt. Eintragen der Whrungen.
		waehrung = new Choice();
		waehrung.add( "Deutsche Mark" );
		waehrung.add( "Belgische Francs" );
		waehrung.add( "Finnische Mark" );
		waehrung.add( "Franzsische Francs" );
		waehrung.add( "Niederlndische Gulden" );
		waehrung.add( "Irische Pfund" );
		waehrung.add( "Italienische Lire" );
		waehrung.add( "Luxemburgische Franc" );
		waehrung.add( "sterreichische Schillinge" );
		waehrung.add( "Portugiesische Escudos" );
		waehrung.add( "Spanische Pesetas" );
		
		// Registrieren einer Methode, die bei Auswahl einer Whrung
		// ausgefhrt werden soll.
		waehrung.addItemListener( new ItemListener() {
			public void itemStateChanged( ItemEvent event ) {
				// Umrechnen
				compute();
			}
		} );

		// Anordnen der Auswahl-Komponente in der Mitte des Fensters
		add( BorderLayout.CENTER, waehrung );

		// Erzeugen einer Label-Komponente, in der das Ergebnis der
		// Berechnung angezeigt werden soll.
		ausgabe = new Label( "----------", Label.CENTER );
		
		// Anordnen der Label-Komponente am oberen Bildschirmrand.
		add( BorderLayout.SOUTH, ausgabe );
	}

	// Hier findet die eigentliche Umrechnung statt
	void compute() {
		try {
			double euro_betrag = 
				Double.valueOf( eingabe.getText() ).doubleValue(); 
			
			double kurs = kurse[ waehrung.getSelectedIndex() ];
			double dm_betrag = euro_betrag * kurs;
			BigDecimal dm = new BigDecimal( dm_betrag );
			BigDecimal dm_gerundet = 
				dm.setScale( 2, BigDecimal.ROUND_HALF_UP );
			ausgabe.setText( "" + dm_gerundet );
		} catch( Exception e ) {
			ausgabe.setText( "Ungltiger Betrag" );
		}
	}
}
