UNIT SGlobalEinstellungen;

{The Little Richard Editor
 (C) 1996, 1997, 1998, 1999 by Johannes Leckebusch
 14. 05 1999}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Menus;

type
  TAllgEinstellDialog = class(TForm)
    PageControl1: TPageControl;
    GlobalAnzeige: TTabSheet;
    HistorySchalterGroup: TGroupBox;
    BLadeHistory: TButton;
    BSpeichereHistory: TButton;
    Font_und_Fenster: TTabSheet;
    FontKonfig: TGroupBox;
    KonfSpeichButton: TButton;
    KonfLadButton: TButton;
    EditorFensterRadiogroup: TRadioGroup;
    TextFensterRadiogroup: TRadioGroup;
    CheckHistoryLaden: TCheckBox;
    AllgGlobalSchalterGroup: TGroupBox;
    CheckSchaltleiste: TCheckBox;
    CheckIsoAnzeige: TCheckBox;
    CheckWortumbruch: TCheckBox;
    CheckLineal: TCheckBox;
    CheckSchaltleiste2: TCheckBox;
    MaxHistUpDown: TUpDown;
    MaxHistoryEdit: TEdit;
    MaxHistLabel: TLabel;
    Dateieinstellungen: TTabSheet;
    DateiOptionen: TGroupBox;
    CheckBAK: TCheckBox;
    SaveSuffixeButton: TButton;
    LoadSuffixeButton: TButton;
    CheckReplaceStart: TCheckBox;
    Seitenlayout: TTabSheet;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    EditZeichenProSeite: TEdit;
    UpDownZeichenProSeite: TUpDown;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    GroupMaxTextlaenge: TGroupBox;
    EditMaxTextLaen: TEdit;
    ButtonStandardTextlaen: TButton;
    ButtonMediumTextlaen: TButton;
    ButtonMaxTextLaen: TButton;
    CheckBoxStatusLeiste: TCheckBox;
    HaeufigBenoetigteVerzeichnisseSchaltbox: TGroupBox;
    MaxFavoriteEdit: TEdit;
    MaxFavoriteUpDown: TUpDown;
    Label1: TLabel;
    ButtonFavLaden: TButton;
    ButtonFavSpeichern: TButton;
    EditSaveTime: TEdit;
    UpDownSaveTime: TUpDown;
    Label2: TLabel;
    CheckBoxAutoSave: TCheckBox;
    CheckSchaltleiste3: TCheckBox;
    ButtonNichtspeichern: TButton;
    Button10Sek: TButton;
    Button30Sek: TButton;
    Button5Min: TButton;
    TabSheetAnwendungen: TTabSheet;
    GroupBoxAnwendungen: TGroupBox;
    EditAnwendung1: TEdit;
    ButtonF1: TButton;
    EditAnwendung2: TEdit;
    ButtonF2: TButton;
    FontVoreinstellDialog: TFontDialog;
    EditAnwendung3: TEdit;
    ButtonF3: TButton;
    EditAnwendung4: TEdit;
    ButtonF4: TButton;
    EditAnwendung5: TEdit;
    ButtonF5: TButton;
    EditAnwendung6: TEdit;
    ButtonF6: TButton;
    EditAnwendung7: TEdit;
    ButtonF7: TButton;
    EditAnwendung8: TEdit;
    ButtonF8: TButton;
    EditAnwendung9: TEdit;
    ButtonF9: TButton;
    EditAnwendung10: TEdit;
    ButtonF10: TButton;
    ButtonAnwLaden: TButton;
    ButtonAnwSpeichern: TButton;
    PopupMenuAnwendung: TPopupMenu;
    Ausschneiden1: TMenuItem;
    Kopieren1: TMenuItem;
    Einfuegen1: TMenuItem;
    Loeschen1: TMenuItem;
    N6: TMenuItem;
    Anwendungwhlen1: TMenuItem;
    CheckBoxLetzterText: TCheckBox;
    Label4: TLabel;
    LastHistoryEdit: TEdit;
    LastHistUpDown: TUpDown;
    CheckBoxKonfigSave: TCheckBox;
    CheckBoxExplorer: TCheckBox;
    CheckBoxAutoSyntaxHighlight: TCheckBox;
    CheckBoxAutoTagAssistant: TCheckBox;
    CheckBoxAutoUmlaut: TCheckBox;
    CheckBoxAutoDateien: TCheckBox;
    CheckBoxKeineDuplikate: TCheckBox;
    PanelIncBackup: TPanel;
    CheckIncBackup: TCheckBox;
    Label5: TLabel;
    EditIncBackup: TEdit;
    UpDownIncBackup: TUpDown;
    CheckBoxAutoWebfenster: TCheckBox;
    CheckBoxAutoHomepage: TCheckBox;
    CheckBoxAutoOnline: TCheckBox;
    CheckBoxWebMinimiert: TCheckBox;
    UpDownShowHisMenu: TUpDown;
    ShowHisMenuEdit: TEdit;
    Label6: TLabel;
    GroupBoxBrowserBackup: TGroupBox;
    Label7: TLabel;
    EditBrowseTime: TEdit;
    UpDownBrowseTime: TUpDown;
    ButtonNoBrowserUpdate: TButton;
    ButtonNach1Sek: TButton;
    ButtonNach3Sek: TButton;
    ButtonNach5Sek: TButton;
    ButtonNach10Sek: TButton;
    GroupBox2: TGroupBox;
    CheckBoxHeadline: TCheckBox;
    CheckBoxPagenumber: TCheckBox;
    Label8: TLabel;
    EditLeftMargin: TEdit;
    UpDownLeftMargin: TUpDown;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    EditRightMargin: TEdit;
    EditTopMargin: TEdit;
    EditBottomMargin: TEdit;
    UpDownRightMargin: TUpDown;
    UpDownTopMargin: TUpDown;
    UpDownBottomMargin: TUpDown;
    Label13: TLabel;
    EditHeaderMargin: TEdit;
    UpDownHeaderMargin: TUpDown;
    procedure FormCreate(Sender: TObject);
    procedure BLadeHistoryClick(Sender: TObject);
    procedure BSpeichereHistoryClick(Sender: TObject);
    procedure KonfSpeichButtonClick(Sender: TObject);
    procedure KonfLadButtonClick(Sender: TObject);
    procedure EditorFensterRadiogroupClick(Sender: TObject);
    procedure TextFensterRadiogroupClick(Sender: TObject);
    procedure CheckSchaltleisteClick(Sender: TObject);
    procedure CheckHistoryLadenClick(Sender: TObject);
    procedure CheckIsoAnzeigeClick(Sender: TObject);
    procedure CheckWortumbruchClick(Sender: TObject);
    procedure CheckLinealClick(Sender: TObject);
    procedure CheckSchaltleiste2Click(Sender: TObject);
    procedure MaxHistoryEditChange(Sender: TObject);
    procedure CheckBAKClick(Sender: TObject);
    procedure SaveSuffixeButtonClick(Sender: TObject);
    procedure LoadSuffixeButtonClick(Sender: TObject);
    procedure CheckReplaceStartClick(Sender: TObject);
    procedure EditZeichenProSeiteChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure EditMaxTextLaenChange(Sender: TObject);
    procedure ButtonStandardTextlaenClick(Sender: TObject);
    procedure ButtonMediumTextlaenClick(Sender: TObject);
    procedure ButtonMaxTextLaenClick(Sender: TObject);
    procedure CheckBoxStatusLeisteClick(Sender: TObject);
    procedure MaxFavoriteEditChange(Sender: TObject);
    procedure ButtonFavLadenClick(Sender: TObject);
    procedure ButtonFavSpeichernClick(Sender: TObject);
    procedure EditSaveTimeChange(Sender: TObject);
    procedure ButtonOkClick(Sender: TObject);
    procedure ButtonAbbrechenClick(Sender: TObject);
    procedure CheckBoxAutoSaveClick(Sender: TObject);
    procedure CheckSchaltleiste3Click(Sender: TObject);
    procedure ButtonNichtspeichernClick(Sender: TObject);
    procedure Button10SekClick(Sender: TObject);
    procedure Button30SekClick(Sender: TObject);
    procedure Button5MinClick(Sender: TObject);
    procedure EditAnwendung1DblClick(Sender: TObject);
    procedure ButtonF1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonF2Click(Sender: TObject);
    procedure ButtonF3Click(Sender: TObject);
    procedure ButtonF4Click(Sender: TObject);
    procedure ButtonF5Click(Sender: TObject);
    procedure ButtonF6Click(Sender: TObject);
    procedure ButtonF7Click(Sender: TObject);
    procedure ButtonF8Click(Sender: TObject);
    procedure ButtonF9Click(Sender: TObject);
    procedure ButtonF10Click(Sender: TObject);
    procedure ButtonAnwLadenClick(Sender: TObject);
    procedure ButtonAnwSpeichernClick(Sender: TObject);
    procedure Ausschneiden1Click(Sender: TObject);
    procedure Kopieren1Click(Sender: TObject);
    procedure Einfuegen1Click(Sender: TObject);
    procedure Loeschen1Click(Sender: TObject);
    procedure Allesauswaehlen1Click(Sender: TObject);
    procedure Anwendungwhlen1Click(Sender: TObject);
    procedure LastHistoryEditChange(Sender: TObject);
    procedure CheckBoxKonfigSaveClick(Sender: TObject);
    procedure CheckBoxExplorerClick(Sender: TObject);
    procedure CheckBoxAutoSyntaxHighlightClick(Sender: TObject);
    procedure CheckBoxAutoTagAssistantClick(Sender: TObject);
    procedure CheckBoxAutoUmlautClick(Sender: TObject);
    procedure CheckBoxAutoDateienClick(Sender: TObject);
    procedure CheckBoxKeineDuplikateClick(Sender: TObject);
    procedure CheckIncBackupClick(Sender: TObject);
    procedure EditIncBackupChange(Sender: TObject);
    procedure CheckBoxAutoWebfensterClick(Sender: TObject);
    procedure CheckBoxAutoHomepageClick(Sender: TObject);
    procedure CheckBoxAutoOnlineClick(Sender: TObject);
    procedure CheckBoxWebMinimiertClick(Sender: TObject);
    procedure ShowHisMenuEditChange(Sender: TObject);
    procedure ButtonNoBrowserUpdateClick(Sender: TObject);
    procedure ButtonNach1SekClick(Sender: TObject);
    procedure ButtonNach3SekClick(Sender: TObject);
    procedure ButtonNach5SekClick(Sender: TObject);
    procedure EditBrowseTimeChange(Sender: TObject);
    procedure ButtonNach10SekClick(Sender: TObject);
    procedure EditLeftMarginChange(Sender: TObject);
    procedure EditRightMarginChange(Sender: TObject);
    procedure EditTopMarginChange(Sender: TObject);
    procedure EditBottomMarginChange(Sender: TObject);
    procedure CheckBoxHeadlineClick(Sender: TObject);
    procedure CheckBoxPagenumberClick(Sender: TObject);
    procedure EditHeaderMarginChange(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  AllgEinstellDialog: TAllgEinstellDialog;

implementation

uses SmallLittleFrame, SLREdit, SDateimanager, MyFmxUtils, Clipbrd;

{$R *.DFM}

procedure TAllgEinstellDialog.FormCreate(Sender: TObject);
VAR  Index: Integer;
begin
  PageControl1.ActivePage := GlobalAnzeige;

  WITH Owner AS TLRFrame DO BEGIN
      FOR Index := 0 TO AnwendungsListe.Count -1 DO BEGIN
        CASE Index OF
          0: EditAnwendung1.Text := AnwendungsListe.Strings [0];
          1: EditAnwendung2.Text := AnwendungsListe.Strings [1];
          2: EditAnwendung3.Text := AnwendungsListe.Strings [2];
          3: EditAnwendung4.Text := AnwendungsListe.Strings [3];
          4: EditAnwendung5.Text := AnwendungsListe.Strings [4];
          5: EditAnwendung6.Text := AnwendungsListe.Strings [5];
          6: EditAnwendung7.Text := AnwendungsListe.Strings [6];
          7: EditAnwendung8.Text := AnwendungsListe.Strings [7];
          8: EditAnwendung9.Text := AnwendungsListe.Strings [8];
          9: EditAnwendung10.Text := AnwendungsListe.Strings [9];
        END (* CASE *);
      END (* FOR *);

    CheckHistoryLaden.Checked := Konfig.AusHistoryLaden;
//    CheckBoxLetzterText.Checked := Konfig.LetztenLaden;
//    MaxHistoryEdit.Text := IntToStr (Konfig.MaxHistory);
    MaxHistUpDown.Position := Konfig.MaxHistory;
//    EditZeichenProSeite.Text := IntToStr (Konfig.ZeichenAufSeite);
    LastHistUpDown.Position := Konfig.LastHistory;
    MaxFavoriteUpDown.Position := Konfig.MaxFavorite;
    UpDownSaveTime.Position := Konfig.saveIntervall;
    UpDownBrowseTime.Position := Konfig.BrowserBackup;
    UpDownIncBackup.Position := Konfig.NIncBackup;
    UpDownZeichenProSeite.Position := Konfig.ZeichenAufSeite;
    UpDownShowHisMenu.Position := Konfig.AnzeigeHistory;
    UpDownLeftMargin.Position := Konfig.LeftMargin;
    UpDownRightMargin.Position := Konfig.RightMargin;
    UpDownTopMargin.Position := Konfig.TopMargin;
    UpDownBottomMargin.Position := Konfig.BottomMargin;
    UpDownHeaderMargin.Position := Konfig.HeaderMargin;
    CheckBoxHeadLine.Checked := Konfig.PrintHeadline;
    CheckBoxPagenumber.Checked := Konfig.PrintPagenumber;
    CheckSchaltleiste.Checked := LRSchnellSchalter.Visible;
    CheckSchaltleiste2.Checked := LRSchnellSchalter2.Visible;
    CheckSchaltleiste3.Checked := LRSchnellSchalter3.Visible;
    CheckIsoAnzeige.Checked := Konfig.ISOAnzeigen;
    CheckWortumbruch.Checked := Konfig.WortUmbruch;
    CheckLineal.Checked := Konfig.LinealAnzeigen;
    CheckBAK.Checked := Konfig.BAKErstellen;
    CheckIncBackup.Checked := Konfig.IncBackup;
    CheckReplaceStart.Checked := Konfig.KeepReplaceStart;
    CheckBoxStatusLeiste.Checked := StatusBar1.Visible;
    CheckBoxExplorer.Checked := Konfig.NoExplorerTest;
    CheckBoxAutoSave.Checked := Konfig.AutoSaveAbfrage;
    CheckBoxKonfigSave.Checked := Konfig.AutoSaveKonfig;
    CheckBoxAutoSyntaxHighlight.Checked := Konfig.AutoSyntaxHighlight;
    CheckBoxAutoUmlaut.Checked := Konfig.AutoUmlaut;
    CheckBoxAutoTagAssistant.Checked := Konfig.AutoTagAssistant;
    CheckBoxAutoDateien.Checked := Konfig.AutoDateienMerken;
    CheckBoxKeineDuplikate.Checked := Konfig.KeineDuplikateLaden;
    CheckBoxAutoWebfenster.Checked := Konfig.AutoWebfenster;
    CheckBoxAutoHomepage.Checked := Konfig.AutoHomepage;
    CheckBoxAutoOnline.Checked := Konfig.AutoOnline;
    CheckBoxWebMinimiert.Checked := Konfig.WebMinimiert;
    EditMaxTextLaen.Text := IntToStr (Konfig.MaxTextLaenge);

    CheckIncBackUp.Enabled := Konfig.BAKErstellen;
    EditIncBackup.Enabled := Konfig.BAKErstellen;
    UpDownIncBackup.Enabled := Konfig.BAKErstellen;
    IF DefaultWindow.FrameWinDefault THEN BEGIN
      CASE DefaultWindow.FramePos OF
        poDesigned:        EditorFensterRadiogroup.ItemIndex := 0;
        poDefault:         EditorFensterRadiogroup.ItemIndex := 1;
        poDefaultPosOnly:  EditorFensterRadiogroup.ItemIndex := 2;
        poDefaultSizeOnly: EditorFensterRadiogroup.ItemIndex := 3;
        poScreenCenter:    EditorFensterRadiogroup.ItemIndex := 4;
      END (* CASD *);
    END
    ELSE
      EditorFensterRadiogroup.ItemIndex := 5;
    IF DefaultWindow.ChildWinDefault THEN BEGIN
      CASE DefaultWindow.ChildPos OF
        poDesigned:        TextFensterRadiogroup.ItemIndex := 0;
        poDefault:         TextFensterRadiogroup.ItemIndex := 1;
        poDefaultPosOnly:  TextFensterRadiogroup.ItemIndex := 2;
        poDefaultSizeOnly: TextFensterRadiogroup.ItemIndex := 3;
        poScreenCenter:    TextFensterRadiogroup.ItemIndex := 4;
      END (* CASD *);
    END
    ELSE
      TextFensterRadiogroup.ItemIndex := 5;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.BLadeHistoryClick(Sender: TObject);
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'History-Liste laden', 'Als Liste eintragen', ChangeFileExt (Application.Exename, '.HIS'),
    '*.HIS', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      WITH LRFrame DO
      HistoryListe.LoadFromFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.BSpeichereHistoryClick(Sender: TObject);
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'History-Liste speichern', 'History speichern', ChangeFileExt (Application.Exename, '.HIS'),
    '*.HIS', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, FALSE, FALSE, TRUE, TRUE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      WITH LRFrame DO
      HistoryListe.SaveToFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.KonfSpeichButtonClick(Sender: TObject);
VAR TextAttr: TFontEinstellungen;
    FontFile: FILE OF TFontEinstellungen;
VAR mr:     TModalResult;
begin
  IF LRFrame.DefaultFont <> NIL THEN
    FontVoreinstellDialog.Font := LRFrame.DefaultFont;
  IF FontVoreinstellDialog.Execute THEN BEGIN
    LRFrame.DefaultFont := FontVoreinstellDialog.Font;

    WITH LRFrame.DefaultFont, TextAttr DO BEGIN
      col := Color; Nam := Name; Pit := Pitch; Siz := Size; Styl := Style;
      Hei := Height;
    END (* WITH *);

    WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
      'Font-Datei speichern', 'Font speichern', ChangeFileExt (Application.Exename, '.FON'),
      '*.FON', // expliziter Filter
      LRFrame.Konfig.DateiFilterIndex, FALSE, FALSE, TRUE, TRUE) DO BEGIN
      mr := ShowModal;
      IF mr = mrOk THEN BEGIN
        AssignFile (FontFile, Dateiauswahl);
        Rewrite (FontFile);
        Write (FontFile, TextAttr);
        CloseFile (FontFile);
      END (* IF mrOk *);
      Release;
    END (* WITH *);
  END (* FontDialog *);
{    SaveKonfig.FileName := ChangeFileExt (Application.Exename, '.FON');
    SaveKonfig.Title := 'Font-Datei speichern';
    SaveKonfig.Filter := 'Font-Datei (*.FON)|*.FON|Alle Dateien (*.*)|*.*';
    IF SaveKonfig.Execute THEN BEGIN
      AssignFile (FontFile, SaveKonfig.FileName);
      Rewrite (FontFile);
      Write (FontFile, TextAttr);
      CloseFile (FontFile);
    END (* IF Save *);
  END (* FontDialog *);
}
end;

procedure TAllgEinstellDialog.KonfLadButtonClick(Sender: TObject);
VAR FontFile: FILE OF TFontEinstellungen;
    TextAttr: TFontEinstellungen;
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'Fontdatei laden', 'Font laden', ChangeFileExt (Application.Exename, '.FON'),
    '*.FON', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      IF LRFrame.DefaultFont = NIL THEN
        LRFrame.DefaultFont := TFont.Create;
      AssignFile (FontFile, Dateiauswahl);
      Reset (FontFile);
      Read (FontFile, TextAttr);
      CloseFile (FontFile);
      WITH TextAttr, FontVoreinstellDialog.Font DO BEGIN
        Color := col; Name := Nam; Pitch := Pit; Size := Siz; Style := Styl;
        Height := Hei;
      END (* WITH *);
      IF FontVoreinstellDialog.Execute THEN BEGIN
        LRFrame.DefaultFont := FontVoreinstellDialog.Font;
      END (* FontDialog *);

    END (* IF mrOk *);
    Release;
  END (* WITH *);

{  OpenKonfig.Filename := ChangeFileExt (Application.Exename, '.FON');
  OpenKonfig.Title := 'Fontdatei laden';
  OpenKonfig.Filter := 'Font-Datei (*.FON)|*.FON|Alle Dateien (*.*)|*.*';

  IF OpenKonfig.Execute THEN BEGIN
    IF LRFrame.DefaultFont = NIL THEN
      LRFrame.DefaultFont := TFont.Create;
    AssignFile (FontFile, OpenKonfig.FileName);
    Reset (FontFile);
    Read (FontFile, TextAttr);
    CloseFile (FontFile);
    WITH TextAttr, FontVoreinstellDialog.Font DO BEGIN
      Color := col; Name := Nam; Pitch := Pit; Size := Siz; Style := Styl;
      Height := Hei;
    END (* WITH *);
    IF FontVoreinstellDialog.Execute THEN BEGIN
      LRFrame.DefaultFont := FontVoreinstellDialog.Font;
    END (* FontDialog *);

  END (* IF FileExists *);
}  
end;

procedure TAllgEinstellDialog.EditorFensterRadiogroupClick(Sender: TObject);
begin
  WITH LRFrame.DefaultWindow DO BEGIN
    FrameWinDefault := TRUE;
    CASE EditorFensterRadiogroup.ItemIndex OF
      0: FramePos := poDesigned;
      1: FramePos := poDefault;
      2: FramePos := poDefaultPosOnly;
      3: FramePos := poDefaultSizeOnly;
      4: FramePos := poScreenCenter;
      5: FrameWinDefault := FALSE;
    END (* CASE *);
    LRFrame.Position := FramePos;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.TextFensterRadiogroupClick(Sender: TObject);
begin
  WITH LRFrame.DefaultWindow DO BEGIN
    ChildWinDefault := TRUE; (* Werte von Windows bernehmen *)
    CASE TextFensterRadiogroup.ItemIndex OF
      0: ChildPos := poDesigned;
      1: ChildPos := poDefault;
      2: ChildPos := poDefaultPosOnly;
      3: ChildPos := poDefaultSizeOnly;
      4: ChildPos := poScreenCenter;
      5: ChildWinDefault := FALSE;
    END (* CASE *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckHistoryLadenClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AusHistoryLaden := CheckHistoryLaden.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckIsoAnzeigeClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.IsoAnzeigen := CheckIsoAnzeige.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckWortumbruchClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.WortUmbruch := CheckWortumbruch.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckLinealClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.LinealAnzeigen := CheckLineal.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckSchaltleisteClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    LRSchnellSchalter.Visible := CheckSchaltleiste.Checked;
    Konfig.SchaltleisteAnzeigen := CheckSchaltleiste.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckSchaltleiste2Click(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    LRSchnellSchalter2.Visible := CheckSchaltleiste2.Checked;
    Konfig.Schaltleiste2Anzeigen := CheckSchaltleiste2.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.MaxHistoryEditChange(Sender: TObject);
begin
// showMessage ('MaxHistory: ' + MaxHistoryEdit.Text);
  WITH LRFrame.Konfig DO
    IF MaxHistoryEdit.Text <> '' THEN
      MaxHistory := StrToInt (MaxHistoryEdit.Text);
end;

procedure TAllgEinstellDialog.CheckBAKClick(Sender: TObject);
begin
  WITH LRFrame.Konfig DO BEGIN
    BAKErstellen := CheckBAK.Checked;
    CheckIncBackup.Enabled := CheckBAK.Checked;
    EditIncBackup.Enabled := CheckBAK.Checked;
    UpDownIncBackup.Enabled := CheckBAK.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.SaveSuffixeButtonClick(Sender: TObject);
VAR Suffixe: TextFile;
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'Dateifilter speichern', 'Filter speichern', ChangeFileExt (Application.Exename, '.FIL'),
    '*.FIL', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, FALSE, FALSE, TRUE, TRUE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      WITH LRFRame DO BEGIN
        AssignFile (Suffixe, Dateiauswahl);
        Rewrite (Suffixe);
        Write (Suffixe, OpenFileDialog.Filter);
        CloseFile (Suffixe);
      END;
    END (* IF mrOk *);
    Release;
  END (* WITH *);

{  SaveKonfig.FileName := ChangeFileExt (Application.ExeName, '.FIL');
  SaveKonfig.Filter := 'Filterdatei (*.FIL)|*.FIL|Alle Dateien (*.*)|*.*';
  SaveKonfig.Title := 'Dateifilter speichern';
  IF SaveKonfig.Execute THEN BEGIN
    WITH LRFRame DO BEGIN
      AssignFile (Suffixe, SaveKonfig.Filename);
      Rewrite (Suffixe);
      Write (Suffixe, OpenFileDialog.Filter);
      CloseFile (Suffixe);
    END;
  END;
}
end;

procedure TAllgEinstellDialog.LoadSuffixeButtonClick(Sender: TObject);
VAR Suffixe: TextFile;
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'Dateifilter laden', 'Filter laden', ChangeFileExt (Application.Exename, '.FIL'),
    '*.FIL', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      WITH LRFRame DO BEGIN
        AssignFile (Suffixe, Dateiauswahl);
        Reset (Suffixe);
        Read (Suffixe, Dateifilter);
        CloseFile (Suffixe);
      END;
    END (* IF mrOk *);
    Release;
  END (* WITH *);

{  OpenKonfig.FileName := ChangeFileExt (Application.ExeName, '.FIL');
  OpenKonfig.Filter := 'Filterdatei (*.FIL)|*.FIL|Alle Dateien (*.*)|*.*';
  OpenKonfig.Title := 'Dateifilter laden';
  IF OpenKonfig.Execute THEN BEGIN
    WITH LRFRame DO BEGIN
      AssignFile (Suffixe, OpenKonfig.Filename);
      Reset (Suffixe);
      Read (Suffixe, Dateifilter);
      CloseFile (Suffixe);
    END;
  END;
}  
end;

procedure TAllgEinstellDialog.CheckReplaceStartClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.KeepReplaceStart := CheckReplaceStart.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxStatusLeisteClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    StatusBar1.Visible := CheckBoxStatusleiste.Checked;
    Konfig.StatusLeiste := CheckBoxStatusleiste.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.EditZeichenProSeiteChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF EditZeichenProSeite.Text <> '' THEN
      ZeichenAufSeite := StrToInt (EditZeichenProSeite.Text);
end;


procedure TAllgEinstellDialog.Button1Click(Sender: TObject);
begin
  UpDownZeichenProSeite.Position := 1500;
end;

procedure TAllgEinstellDialog.Button2Click(Sender: TObject);
begin
  UpDownZeichenProSeite.Position := 3500;
end;

procedure TAllgEinstellDialog.Button3Click(Sender: TObject);
begin
  UpDownZeichenProSeite.Position := 7500;
end;


procedure TAllgEinstellDialog.EditMaxTextLaenChange(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
      IF EditMaxTextLaen.Text <> '' THEN
        Konfig.MaxTextLaenge := StrToInt (EditMaxTextLaen.Text);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonStandardTextlaenClick(Sender: TObject);
begin
  EditMaxTextLaen.Text := '0';
end;

procedure TAllgEinstellDialog.ButtonMediumTextlaenClick(Sender: TObject);
begin
  EditMaxTextLaen.Text := IntToStr (High (Integer) DIV 2);
end;

procedure TAllgEinstellDialog.ButtonMaxTextLaenClick(Sender: TObject);
begin
  EditMaxTextLaen.Text := IntToStr (High (Integer) - 1024);
end;


procedure TAllgEinstellDialog.MaxFavoriteEditChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF MaxFavoriteEdit.Text <> '' THEN
      MaxFavorite := StrToInt (MaxFavoriteEdit.Text);
end;

procedure TAllgEinstellDialog.ButtonFavLadenClick(Sender: TObject);
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'Favoriten-Liste laden', 'Als Liste eintragen', ChangeFileExt (Application.Exename, '.FAV'),
    '*.FAV', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      WITH LRFrame DO
      FavouriteListe.LoadFromFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonFavSpeichernClick(Sender: TObject);
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
    'Favoriten-Liste speichern', 'Favoriten speichern', ChangeFileExt (Application.Exename, '.FAV'),
    '*.FAV', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, FALSE, FALSE, TRUE, TRUE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      WITH LRFrame DO
        FavouriteListe.SaveToFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.EditSaveTimeChange(Sender: TObject);
begin
  IF EditSaveTime.Text <> '' THEN
    LRFrame.Konfig.saveIntervall := StrToInt (EditSaveTime.Text);
end;

procedure TAllgEinstellDialog.ButtonOkClick(Sender: TObject);
begin
  Close;
end;

procedure TAllgEinstellDialog.ButtonAbbrechenClick(Sender: TObject);
begin
  Close;
end;

procedure TAllgEinstellDialog.CheckBoxAutoSaveClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoSaveAbfrage := CheckBoxAutoSave.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckSchaltleiste3Click(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    LRSchnellSchalter3.Visible := CheckSchaltleiste3.Checked;
    Konfig.Schaltleiste3Anzeigen := CheckSchaltleiste3.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonNichtspeichernClick(Sender: TObject);
begin
  EditSaveTime.Text := '0';
end;

procedure TAllgEinstellDialog.Button10SekClick(Sender: TObject);
begin
  EditSaveTime.Text := '10';
end;

procedure TAllgEinstellDialog.Button30SekClick(Sender: TObject);
begin
  EditSaveTime.Text := '30';
end;

procedure TAllgEinstellDialog.Button5MinClick(Sender: TObject);
begin
  EditSaveTime.Text := '300';
end;

procedure TAllgEinstellDialog.EditAnwendung1DblClick(Sender: TObject);
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (LRFRame, FALSE, TRUE,
    'Anwendungsprogramm suchen', 'Als Anwendung eintragen', TEdit (Sender).Text,
    '*.EXE', // expliziter Filter
    LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      TEdit (Sender).Text := Dateiauswahl;
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.FormClose(Sender: TObject;
  var Action: TCloseAction);
VAR  Index:  Integer;
begin
  WITH LRFrame DO BEGIN
    AnwendungsListe.Clear;
    FOR Index := 0 TO 10 DO BEGIN
      CASE Index OF
        0: AnwendungsListe.Add (EditAnwendung1.Text);
        1: AnwendungsListe.Add (EditAnwendung2.Text);
        2: AnwendungsListe.Add (EditAnwendung3.Text);
        3: AnwendungsListe.Add (EditAnwendung4.Text);
        4: AnwendungsListe.Add (EditAnwendung5.Text);
        5: AnwendungsListe.Add (EditAnwendung6.Text);
        6: AnwendungsListe.Add (EditAnwendung7.Text);
        7: AnwendungsListe.Add (EditAnwendung8.Text);
        8: AnwendungsListe.Add (EditAnwendung9.Text);
        9: AnwendungsListe.Add (EditAnwendung10.Text);
      END (* CASE *);
    END (* FOR *);
  END (* WITH LRFrame *);
end;

procedure TAllgEinstellDialog.ButtonF1Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung1 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF2Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung2 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF3Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung3 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF4Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung4 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF5Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung5 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF6Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung6 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF7Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung7 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF8Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung8 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF9Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung9 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonF10Click(Sender: TObject);
VAR Argument: String;
begin
  WITH LRFrame DO BEGIN
    IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        IF Editor.Modified THEN BEGIN
          Speichern1Click (Sender);
        END (* IF *);
        Argument := Pfadname;
      END (* WITH *)
    ELSE Argument := '';
  END (* WITH LRFrame *);
  WITH EditAnwendung10 DO BEGIN
    IF Text <> '' THEN BEGIN
      TRY
        ExecuteFile (Text, Argument, '', SW_SHOW);
      Except
        showMessage ('Kann Anwendung "' + Text + '" (' + Argument + ') nicht starten');
      END (* TRY *);
    END (* IF Eintrag vorhanden *);
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ButtonAnwLadenClick(Sender: TObject);
VAR  Index: Integer;
     mr:     TModalResult;
begin
  WITH LRFrame DO BEGIN
    WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
      'Anwendungsliste suchen', 'Liste laden',
      ChangeFileExt (Application.Exename, '.ANW'), '*.ANW', Konfig.DateifilterIndex,
      TRUE, TRUE, FALSE, FALSE) DO BEGIN
//      DateiFilterCombobox.Filter := 'Anwendungen|*.ANW';
      mr := ShowModal;
      IF mr = mrOK THEN BEGIN
        AnwendungsListe.LoadFromFile (Dateiauswahl);
        FOR Index := 0 TO AnwendungsListe.Count -1 DO BEGIN
          CASE Index OF
            0: EditAnwendung1.Text := AnwendungsListe.Strings [0];
            1: EditAnwendung2.Text := AnwendungsListe.Strings [1];
            2: EditAnwendung3.Text := AnwendungsListe.Strings [2];
            3: EditAnwendung4.Text := AnwendungsListe.Strings [3];
            4: EditAnwendung5.Text := AnwendungsListe.Strings [4];
            5: EditAnwendung6.Text := AnwendungsListe.Strings [5];
            6: EditAnwendung7.Text := AnwendungsListe.Strings [6];
            7: EditAnwendung8.Text := AnwendungsListe.Strings [7];
            8: EditAnwendung9.Text := AnwendungsListe.Strings [8];
            9: EditAnwendung10.Text := AnwendungsListe.Strings [9];
          END (* CASE *);
        END (* FOR *);
      END (* IF mrOK *);
      Release;
    END (* WITH Dateimanager *);
  END (* WITH LRFrame *);
end;

procedure TAllgEinstellDialog.ButtonAnwSpeichernClick(Sender: TObject);
VAR  Index: Integer;
     mr:     TModalResult;
begin
  WITH LRFrame DO BEGIN
    WITH TDateiManagerForm.ECreate (LRFrame, FALSE, TRUE,
      'Anwendungsliste speichern', 'Liste speichern',
      ChangeFileExt (Application.Exename, '.ANW'), '*.ANW',
      Konfig.DateifilterIndex,
      FALSE, FALSE, TRUE, TRUE) DO BEGIN
//      DateiFilterCombobox.Filter := 'Anwendungen|*.ANW';
      mr := ShowModal;
      IF mr = mrOK THEN BEGIN
        AnwendungsListe.Clear;
        FOR Index := 0 TO 10 DO BEGIN
          CASE Index OF
            0: AnwendungsListe.Add (EditAnwendung1.Text);
            1: AnwendungsListe.Add (EditAnwendung2.Text);
            2: AnwendungsListe.Add (EditAnwendung3.Text);
            3: AnwendungsListe.Add (EditAnwendung4.Text);
            4: AnwendungsListe.Add (EditAnwendung5.Text);
            5: AnwendungsListe.Add (EditAnwendung6.Text);
            6: AnwendungsListe.Add (EditAnwendung7.Text);
            7: AnwendungsListe.Add (EditAnwendung8.Text);
            8: AnwendungsListe.Add (EditAnwendung9.Text);
            9: AnwendungsListe.Add (EditAnwendung10.Text);
          END (* CASE *);
        END (* FOR *);
        AnwendungsListe.SaveToFile (Dateiauswahl);
      END (* IF mrOK *);
      Release;
    END (* WITH Dateimanager *);
  END (* WITH LRFrame *);
end;

procedure TAllgEinstellDialog.Ausschneiden1Click(Sender: TObject);
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
  WITH PopupMenuAnwendung.PopupComponent AS TEdit DO BEGIN
    Clip.AsText := Text;
    Text := '';
  END;
end;

procedure TAllgEinstellDialog.Kopieren1Click(Sender: TObject);
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
  WITH PopupMenuAnwendung.PopupComponent AS TEdit DO BEGIN
    Clip.AsText := Text;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.Einfuegen1Click(Sender: TObject);
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
  WITH PopupMenuAnwendung.PopupComponent AS TEdit DO BEGIN
    Text := Clip.AsText;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.Loeschen1Click(Sender: TObject);
begin
  WITH PopupMenuAnwendung.PopupComponent AS TEdit DO BEGIN
    Text := '';
  END (* WITH *);
end;

procedure TAllgEinstellDialog.Allesauswaehlen1Click(Sender: TObject);
begin
  WITH PopupMenuAnwendung.PopupComponent AS TEdit DO BEGIN
    SelectAll;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.Anwendungwhlen1Click(Sender: TObject);
begin
  EditAnwendung1DblClick (PopupMenuAnwendung.PopupComponent);
end;

procedure TAllgEinstellDialog.LastHistoryEditChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF LastHistoryEdit.Text <> '' THEN
      LastHistory := StrToInt (LastHistoryEdit.Text);
end;

procedure TAllgEinstellDialog.CheckBoxKonfigSaveClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoSaveKonfig := CheckBoxKonfigSave.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxExplorerClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.NoExplorerTest := CheckBoxExplorer.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxAutoSyntaxHighlightClick(
  Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoSyntaxHighlight := CheckBoxAutoSyntaxHighlight.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxAutoTagAssistantClick(
  Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoTagAssistant := CheckBoxAutoTagAssistant.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxAutoUmlautClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoUmlaut := CheckBoxAutoUmlaut.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxAutoDateienClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoDateienMerken := CheckBoxAutoDateien.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxKeineDuplikateClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.KeineDuplikateLaden := CheckBoxKeineDuplikate.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckIncBackupClick(Sender: TObject);
begin
  WITH LRFrame.Konfig DO BEGIN
    IncBackup := CheckIncBackup.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.EditIncBackupChange(Sender: TObject);
begin
  IF EditIncBackup.Text <> '' THEN
    LRFrame.Konfig.NIncBackup := StrToInt (EditIncBackup.Text);
end;

procedure TAllgEinstellDialog.CheckBoxAutoWebfensterClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoWebfenster := CheckBoxAutoWebfenster.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxAutoHomepageClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoHomepage := CheckBoxAutoHomepage.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxAutoOnlineClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.AutoOnline := CheckBoxAutoOnline.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxWebMinimiertClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.WebMinimiert := CheckBoxWebMinimiert.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.ShowHisMenuEditChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF ShowHisMenuEdit.Text <> '' THEN
      AnzeigeHistory := StrToInt (ShowHisMenuEdit.Text);
end;

procedure TAllgEinstellDialog.ButtonNoBrowserUpdateClick(Sender: TObject);
begin
  EditBrowseTime.Text := '0';
end;

procedure TAllgEinstellDialog.ButtonNach1SekClick(Sender: TObject);
begin
  EditBrowseTime.Text := '1';
end;

procedure TAllgEinstellDialog.ButtonNach3SekClick(Sender: TObject);
begin
  EditBrowseTime.Text := '3';
end;

procedure TAllgEinstellDialog.ButtonNach5SekClick(Sender: TObject);
begin
  EditBrowseTime.Text := '5';
end;

procedure TAllgEinstellDialog.EditBrowseTimeChange(Sender: TObject);
begin
  IF EditBrowseTime.Text <> '' THEN
    LRFrame.Konfig.BrowserBackup := StrToInt (EditBrowseTime.Text);
end;

procedure TAllgEinstellDialog.ButtonNach10SekClick(Sender: TObject);
begin
  EditBrowseTime.Text := '10';
end;

procedure TAllgEinstellDialog.EditLeftMarginChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF EditLeftMargin.Text <> '' THEN
      LeftMargin := StrToInt (EditLeftMargin.Text);
end;

procedure TAllgEinstellDialog.EditRightMarginChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF EditRightMargin.Text <> '' THEN
      RightMargin := StrToInt (EditRightMargin.Text);
end;

procedure TAllgEinstellDialog.EditTopMarginChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF EditTopMargin.Text <> '' THEN
      TopMargin := StrToInt (EditTopMargin.Text);
end;

procedure TAllgEinstellDialog.EditBottomMarginChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF EditBottomMargin.Text <> '' THEN
      BottomMargin := StrToInt (EditBottomMargin.Text);
end;

procedure TAllgEinstellDialog.CheckBoxHeadlineClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.PrintHeadline := CheckBoxHeadline.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.CheckBoxPagenumberClick(Sender: TObject);
begin
  WITH LRFrame DO BEGIN
    Konfig.PrintPagenumber := CheckBoxPagenumber.Checked;
  END (* WITH *);
end;

procedure TAllgEinstellDialog.EditHeaderMarginChange(Sender: TObject);
begin
  WITH LRFrame.Konfig DO
    IF EditHeaderMargin.Text <> '' THEN
      HeaderMargin := StrToInt (EditHeaderMargin.Text);
end;

end.
