unit webbrowse;

{Benutzt fr LR 25. 8. 1996}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, ComCtrls, Buttons, ISP3,
  OleCtrls;

type
  TWebbrowser = class(TForm)
    HTML1: THTML;
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    Bevel1: TBevel;
    URLs: TComboBox;
    GoButton: TSpeedButton;
    View1: TMenuItem;
    DocumentSource1: TMenuItem;
    CancelBtn: TSpeedButton;
    Label1: TLabel;
    Merkliste1: TMenuItem;
    InMerkliste1: TMenuItem;
    N1: TMenuItem;
    OpenHTMLDialog: TOpenDialog;
    N2: TMenuItem;
    HTMLDateiladen1: TMenuItem;
    Drucken1: TMenuItem;
    N3: TMenuItem;
    SpeedButtonProperties: TSpeedButton;
    Hilfe1: TMenuItem;
    Eigenschaften1: TMenuItem;
    Ifno1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure GoButtonClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure DocumentSource1Click(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure HTML1BeginRetrieval(Sender: TObject);
    procedure HTML1EndRetrieval(Sender: TObject);
    procedure URLsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure Merkliste1Click(Sender: TObject);
    procedure InMerkliste1Click(Sender: TObject);
//    procedure HTML1DoRequestDoc(Sender: TObject; const URL: string;
//      const Element, DocInput: Variant; var EnableDefault: Wordbool);
    procedure GeheZuMerker(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure URLsChange(Sender: TObject);
    procedure HTMLDateiladen1Click(Sender: TObject);
    procedure HTML1DoRequestDoc(Sender: TObject; const URL: WideString;
      const Element: HTMLElement; const DocInput: DocInput;
      var EnableDefault: WordBool);
    procedure Drucken1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Merkliste: TStringList;
    SourceEditor: TForm;
  end;

var
  Webbrowser: TWebbrowser;

implementation

uses {DocSrc} SLREdit, SmallLittleFrame, SDateimanager, Printers;

{$R *.DFM}

CONST CMaxMerker = 25;

procedure TWebbrowser.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TWebbrowser.GoButtonClick(Sender: TObject);
begin
  IF URLs.text = '' THEN EXIT;
  if URLs.Items.IndexOf(URLs.Text) = -1 then
    URLs.Items.Add(URLs.Text);
  HTML1.RequestDoc(URLs.text);
  Statusbar1.Panels[0].Text := HTML1.RequestURL;
end;

procedure TWebbrowser.About1Click(Sender: TObject);
begin
  HTML1.AboutBox;
end;

function stripURL (CONST url: String): String;
VAR i, Slash, Punkt, Punkte, Bar: INTEGER;
BEGIN
  Slash := 0; Punkt := 0; Punkte := 0; Bar := 0;
  i := LENGTH (url);
  WHILE (i > 0) AND (Bar = 0) DO BEGIN
      IF url [i] = '|' THEN Bar := i;
      DEC (i);
  END (* WHILE *);
  IF Bar = 0 THEN BEGIN
    i := LENGTH (url);
    WHILE (i > 0) AND (Slash = 0) AND (Punkt = 0) DO BEGIN
      IF url [i] = '.' THEN BEGIN
        INC (Punkte);
        IF Punkte = 2 THEN Punkt := i;
      END (* IF *);
      IF url [i] = '/' THEN Slash := i;
      DEC (i);
    END (* WHILE *);
  END (* IF Bar = 0 *);
  IF Bar <> 0 THEN Slash := Bar
  ELSE IF Punkt > Slash THEN Slash := Punkt;
  Result := Copy (url, Slash + 1, LENGTH (url) - Slash);
  IF (Length (Result) > 2) AND (Result [2] = '|') THEN
    Result [2] := ':';
END (* stripURL *);

procedure TWebbrowser.DocumentSource1Click(Sender: TObject);
(* VAR SourceEditor: TEditForm; *)
begin
{  IF SourceEditor = NIL THEN BEGIN
    SourceEditor := TEditForm.Create (LRFrame);
    WITH SourceEditor AS TEditForm DO Hypertext := Self;
  END;
  WITH SourceEditor AS TEditForm DO BEGIN
    with Editor do begin
      SelText := HTML1.SourceText;
      SelStart := 0;
      PfadName := stripURL (URLs.text);
      Caption := PfadName;
      Modified := FALSE;
    END (* with Editor *);
    BringToFront;
  END (* WITH *);
  LRFrame.BringToFront;
  }
      {SendMessage(SourceEditor.Editor.Handle, EM_ScrollCaret, 0, 0);}
end;

procedure TWebbrowser.CancelBtnClick(Sender: TObject);
begin
  HTML1.Cancel('test');
  CancelBtn.Enabled := False;
end;

procedure TWebbrowser.HTML1BeginRetrieval(Sender: TObject);
begin
  CancelBtn.Enabled := True;
end;

procedure TWebbrowser.HTML1EndRetrieval(Sender: TObject);
begin
  CancelBtn.Enabled := False;
end;

procedure TWebbrowser.URLsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_Return then BEGIN
    GoButtonClick(nil);
    URLs.Text := HTML1.RequestURL;
  END;
end;

procedure TWebbrowser.FormCreate(Sender: TObject);
begin
  MerkListe := TStringList.Create;
  IF FileExists (ChangeFileExt (Application.Exename, '.BOK')) THEN BEGIN
    MerkListe.LoadFromFile (ChangeFileExt (Application.Exename, '.BOK'));
  END (* IF *);
  SourceEditor := NIL;
end;

procedure TWebbrowser.Merkliste1Click(Sender: TObject);
VAR i:       Integer;
    menitem: TMenuItem;
begin
  i := Merkliste1.Count;
  WHILE (Merkliste1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Merkliste1.Delete (i);
  END (* WHILE *);

    FOR i := 0 TO MerkListe.Count - 1 DO BEGIN
      menitem := TMenuItem.Create (MainMenu1);
      WITH menitem DO BEGIN
        Caption := MerkListe.Strings [i];
        OnClick := GeheZuMerker;
      END (* WITH *);
      Merkliste1.Add (menitem);
    END (* FOR *);
end;

procedure TWebbrowser.InMerkliste1Click(Sender: TObject);
VAR Index: Integer;
begin
  WITH MerkListe DO BEGIN
      Index := IndexOf (URLs.Text);
      IF Index <> -1 THEN Delete (Index);
      IF Count >= CMaxMerker THEN Delete (Count - 1);
      Insert (0, URLs.Text);
  END (* WITH *);
end;

procedure TWebbrowser.GeheZuMerker(Sender: TObject);
begin
  WITH Sender AS TMenuItem DO BEGIN
    HTML1.RequestDoc(Caption);
    Statusbar1.Panels[0].Text := Caption;
  END (* WIT *);
end;

procedure TWebbrowser.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  MerkListe.SaveToFile (ChangeFileExt (Application.ExeName, '.BOK'));
  MerkListe.Free;
  IF SourceEditor <> NIL THEN WITH SourceEditor AS TEditForm DO Hypertext := NIL;
end;

procedure TWebbrowser.URLsChange(Sender: TObject);
begin
{Sofort neu anzeigen, wenn URL in der Combobox angeklickt!?
 Geht so nicht, Eingabe mu erst abgeschlossen werden}
{IF URLs.text <> '' THEN
  HTML1.RequestDoc(URLs.text);}
end;

procedure TWebbrowser.HTMLDateiladen1Click(Sender: TObject);
VAR FileN:  String;
    mr:     TModalResult;
    DatMan: TDateiManagerForm;
begin
{  IF OpenHTMLDialog.Execute THEN BEGIN
    FileN := OpenHTMLDialog.FileName;
    IF (Length (FileN) > 2) AND (FileN [2] = ':') THEN
      FileN [2] := '|';
    HTML1.RequestDoc ('file:///' + FileN);
    Statusbar1.Panels[0].Text := HTML1.RequestURL;
  END (* IF *);}
  DatMan := TDateiManagerForm.Create (Self);
  WITH DatMan AS TDateiManagerForm DO BEGIN
    Caption := 'HTML-Datei laden';
    DateiFilterComboBox.ItemIndex := LRFrame.DateiFilterIndex;
    ButtonLaden.Enabled := TRUE; (* hm ... *)
    ButtonLaden.Default := TRUE;
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
//      DateiFilterIndex := DateiFilterComboBox.ItemIndex;
//showMessage (ComboBoxDateiauswahlHistory.Text);
//      WITH TEditForm.Create (Self) DO
//        Open (ComboBoxDateiauswahlHistory.Text);
      FileN := ComboBoxDateiauswahlHistory.Text;
      IF (Length (FileN) > 2) AND (FileN [2] = ':') THEN
        FileN [2] := '|';
      HTML1.RequestDoc ('file:///' + FileN);
      Statusbar1.Panels[0].Text := HTML1.RequestURL;
    END (* IF mrOk *);
  END (* WITH *);
end;

procedure TWebbrowser.HTML1DoRequestDoc(Sender: TObject;
  const URL: WideString; const Element: HTMLElement;
  const DocInput: DocInput; var EnableDefault: WordBool);
VAR Index: Integer;
begin
  WITH URLs.Items DO BEGIN
    Index := IndexOf (URL);
    IF Index <> - 1 THEN Delete (Index);
    Insert(0, URL);
  END (* WITH *);
  IF URL <> '' THEN URLs.Text := URL;
end;

{procedure TWebbrowser.HTML1DoRequestDoc(Sender: TObject; const URL: string;
  const Element, DocInput: Variant; var EnableDefault: Wordbool);
VAR Index: Integer;
begin
  WITH URLs.Items DO BEGIN
    Index := IndexOf (URL);
    IF Index <> - 1 THEN Delete (Index);
    Insert(0, URL);
  END (* WITH *);
  IF URL <> '' THEN URLs.Text := URL;
  (* URLs.Text := HTML1.RequestURL; *)
end;
}

procedure TWebbrowser.Drucken1Click(Sender: TObject);
begin
  WITH HTML1 DO BEGIN
    Printer.BeginDoc;
    AutoPrint (Printer.Handle);
    Printer.EndDoc;
  END (* WITH *);
end;

procedure TWebbrowser.Info1Click(Sender: TObject);
begin
  HTML1.AboutBox;
end;

procedure TWebbrowser.Properties1Click(Sender: TObject);
begin
  HTML1.BrowseProperties;
end;

end.
