import com.sun.java.swing.*;
import com.sun.java.swing.table.*;
import com.sun.java.swing.event.*;
import java.awt.*;
import java.sql.*;
import java.util.*;

public class Adressen extends JApplet
{
    private JTable tableAdressen;
    private JButton buttonNew;
    private JButton buttonDel;
    // Datenbank-Login
    private String username = "ct";
    private String password = "ct-pw";
    private String DB_URL = "jdbc:odbc:ct_Adressen";


    public final String tableHeaders[] = 
      {"ID", "Name", "Vorname", "Strasse", "PLZ", "Wohnort"};
    public final Vector tableData = new Vector(1);

    // Datenmodell fr die Adressen
    public class AddressModel extends AbstractTableModel 
        implements TableModel {

        // Diese Methoden mssen immer implementiert werden
        public int getColumnCount() { return tableHeaders.length; }
        public int getRowCount() { return tableData.size();}
        public Object getValueAt(int row, int col) {
            return ((Object[])tableData.elementAt(row))[col];
        }

        // Die Standardimplementierungen der folgenden Methoden in 
        // AbstractTableModel wrden reichen, aber eine eigene 
        // Implementierung macht oft Sinn
        public String getColumnName(int column) { 
            return tableHeaders[column];
        }
        public Class getColumnClass(int col) {
            return getValueAt(0,col).getClass();
        }
        public boolean isCellEditable(int row, int col) {
            return (col!=0 && getValueAt(row,0)!="");
        }

        // Diese Methode wird intern aufgerufen, wenn der Benutzer 
        // die Tabelle editiert hat. Sie wurde dahingehend erweitert, 
        // dass ein Ereignis erzeugt wird, welches den
        // TableModelListener dazu veranlasst, die neuen Daten 
        // in die DB zuschreiben  
        public void setValueAt(Object aValue, int row, int column) {
            ((Object[])tableData.elementAt(row))[column] = aValue;
            fireTableChanged(new TableModelEvent(this,row,row,column));
        }

        // Diese Methode wird von getData() benutzt, 
        // um neue Werte in die Tabelle zu schreiben, 
        // ohne da der TableModelListener in Aktion tritt
        public void appletSetValueAt(Object aValue, int row, int column) {
             ((Object[])tableData.elementAt(row))[column] = aValue; 
        }
    };

    AddressModel dataModel = new AddressModel();

    public void init()
    {
        System.out.println("Applet erfolgreich gestartet.");
        // Laden des Treibers fr die JDBC-ODBC-Bridge
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        } catch (java.lang.ClassNotFoundException e) {
            System.out.println("Fehler beim Laden des JDBC-Treibers: "
                               + e.getMessage());
            return;
        }

        // Initialisierung der GUI-Elemente
        getContentPane().setLayout(null);
        setVisible(false);
        setSize(750,390);
        setBackground(new Color(-3355444));

        buttonNew = new JButton("Neue Adresse");
        buttonNew.setBounds(24,24,150,20);
        getContentPane().add(buttonNew);

        buttonDel = new JButton("Adresse lschen");
        buttonDel.setBounds(250,24,150,20);
        getContentPane().add(buttonDel);

        tableAdressen = new com.sun.java.swing.JTable(dataModel);
        // Setzen grundlegender Formateigenschaften der JTable
        tableAdressen.setForeground(new Color(0));
        tableAdressen.setBackground(new Color(16777215));
        // der Benutzer soll jeweils nur eine Zeile 
        // gleichzeitig markieren knnen
        tableAdressen.setSelectionMode
            (ListSelectionModel.SINGLE_SELECTION);
        // der Benutzer soll die Spaltenbreite nicht ndern knnen
        tableAdressen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        // Festlegen der Spaltenbreiten
        for (int i=0; i<6; i++) {
            TableColumn column = 
                tableAdressen.getColumnModel().getColumn(i);
            if (i==0 || i==4) {
                column.setMinWidth(50);
                column.setMaxWidth(50);
            } else {
                column.setMinWidth(140);
                column.setMaxWidth(140);
            }
        }

        // Daten aus der Datenbank holen
        getData();
        // JScrollPane fr die JTable erzeugen
        JScrollPane scrPane = new JScrollPane(tableAdressen);
        scrPane.setBounds(24,84,684,209);
        scrPane.setFont(new Font("Dialog", Font.PLAIN, 10));
        scrPane.setForeground(new Color(0));
        scrPane.setBackground(new Color(-3355444));
        getContentPane().add(scrPane);
        
        // Registrieren der Listener fr die beiden Buttons...
        SymAction lSymAction = new SymAction();
        buttonNew.addActionListener(lSymAction);
        buttonDel.addActionListener(lSymAction);
        // und fr die JTable
            TL tl = new TL();
        dataModel.addTableModelListener(tl);
    }


    public void getData() {
        // Auslesen der aktuellen Daten aus der Datenbank
        String stringSelect = 
            "SELECT ID, Name, Vorname, Strasse, PLZ, Wohnort " +
            "FROM Adressen ORDER BY ID";
        try {
            Connection con = DriverManager.getConnection
                (DB_URL, username, password);
            Statement stmtSelect = con.createStatement();
            ResultSet rs = stmtSelect.executeQuery(stringSelect);

            int row = 0;
            // fr jeden Datensatz...
            while (rs.next()) {
                // Einfgen einer neuen Zeile in unsere JTable 
                Object[] newRow = new Object[7];
                for (int i=0; i<6; i++)
                    newRow[i] = new String();
                tableData.addElement(newRow);

                // und bertragen der Werte in die neue Zeile 
                // (""+ falls NULL-Wert in der DB)
                dataModel.appletSetValueAt
                    ("" + rs.getString("ID"), row, 0);
                dataModel.appletSetValueAt
                    ("" + rs.getString("Name"), row, 1);
                dataModel.appletSetValueAt
                    ("" + rs.getString("Vorname"), row, 2);
                dataModel.appletSetValueAt
                    ("" + rs.getString("Strasse"), row, 3);
                dataModel.appletSetValueAt
                    ("" + rs.getString("PLZ"), row, 4);
                dataModel.appletSetValueAt
                    ("" + rs.getString("Wohnort"), row, 5);
                row++;
            }
            con.close();
        } catch (java.sql.SQLException e) {
            System.out.println(e.getMessage());
        }
        return;
    }

    class SymAction implements java.awt.event.ActionListener
    {
        public void actionPerformed(java.awt.event.ActionEvent event)
        {
            Object object = event.getSource();
            if (object == buttonNew)
                buttonNew_actionPerformed(event);
            if (object == buttonDel)
                buttonDel_actionPerformed(event);
        }
    }
    
    void buttonNew_actionPerformed(java.awt.event.ActionEvent event)
    {
        try {
            Connection con = DriverManager.getConnection
                (DB_URL, username, password);
            Statement stmtSelect=con.createStatement();
            // Erfrage die hchste in der Datenbank vorliegende ID
            ResultSet rs = stmtSelect.executeQuery
                ("SELECT MAX(id) FROM Adressen");
            rs.next();
            int maxID=rs.getInt(1);
            // neue ID = hchste bisherige ID + 1
            maxID++;

            // Einfgen eines neuen, leeren Datensatzes
            // beachte: jeweils ein Leerzeichen 
            // zwischen den Anfhrungsstrichen!!
            Statement stmtInsert=con.createStatement();
            int rowCount = stmtInsert.executeUpdate
                ("INSERT INTO Adressen VALUES ("+maxID+
                 ", ' ', ' ', ' ', ' ', ' ')");
            con.close();
        } catch (java.sql.SQLException e) {
            System.out.println(e.getMessage());
            return;
        }

        //JTable leeren und dann die Daten erneut auslesen
        tableData.removeAllElements(); 
        getData();
        tableAdressen.revalidate();
        tableAdressen.repaint();
    }

    void buttonDel_actionPerformed(java.awt.event.ActionEvent event)
    {
        int rowNumber = tableAdressen.getSelectedRow();
        // falls keine Zeile markiert, tue nichts
        if (rowNumber >= tableAdressen.getRowCount() || 
            rowNumber == -1) 
            return;
        
        String rowID = (String) dataModel.getValueAt(rowNumber, 0);

        try {
            Connection con = DriverManager.getConnection
                (DB_URL, username, password);
            Statement stmtDelete=con.createStatement();
            int rowCount = stmtDelete.executeUpdate
                ("DELETE FROM Adressen WHERE id="+rowID);
            con.close();
        } catch (java.sql.SQLException e) {
            System.out.println(e.getMessage());
            return;
        }

        //JTable leeren und dann die Daten erneut auslesen
        tableData.removeAllElements();
        getData();
        tableAdressen.revalidate();
        tableAdressen.repaint();
    }

    ///////////////////////////
    //
    // Table Model Listener
    //
    ///////////////////////////

    class TL implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            // Index der editierten Zelle bestimmen
            int rowNumber = e.getFirstRow();
            int columnNumber = e.getColumn();
            // daraus ID des editierten Datensatzes bestimmen
            String rowID = new 
                String((String)dataModel.getValueAt(rowNumber, 0));
            // Spaltenname der editierten Zelle und Wert bestimmen
            String columnName = new String(tableHeaders[columnNumber]);
            String newValue = new String
                ((String)dataModel.getValueAt(rowNumber,columnNumber));
            // Aus den gewonnen Informationen SQL-Befehl 
            // zum Aktualisieren des Datensatzes erzeugen
            String stringUpdate = new 
                String("UPDATE Adressen SET "+columnName+" = '"+
                       newValue+"' WHERE id="+rowID);
            
            try {
                Connection con = DriverManager.getConnection
                    (DB_URL, username, password);
                Statement stmtUpdate = con.createStatement();
                int rowCount  = stmtUpdate.executeUpdate(stringUpdate);
                con.close();
            } catch (java.sql.SQLException event) {
                System.out.println(event.getMessage());
                return;
            }
        }
    }
}
