' DRAGDROP.VBS
' meldet Detailinfos ber Dateien und Ordner,
' die auf dem Skripticon abgeladen werden
' (C) Tobias Weltner, c't 21/99

set fs = CreateObject("Scripting.FileSystemObject")

' Argumente lesen
set args = WScript.Arguments
if args.Count=0 then
	MsgBox "Dieses Skript ist ein Drag&Drop-Ziel." _
	& " Ziehen Sie Dateien/Ordner auf das Skript-Icon!"
	WScript.Quit
else
	for x=0 to args.count-1
		GetInfo args(x)
	next
end if

sub GetInfo(path)
	' Datei oder Ordner?
	if Instr(path, ".")>0 then
		' von Datei ausgehen
		if fs.FileExists(path) then
			folder=false
			set file = fs.GetFile(path)
			muell = InputBox(GetDetails(file),_
			 "Datei-Info", file.path)
		else
			' doch ein Ordner?
			folder=true
		end if
	else
		' ein Ordner:
		folder = true
	end if
	
	if folder then
		if fs.FolderExists(path) then
			set folder = fs.GetFolder(path)
			muell = InputBox(GetDetails(folder),_
			"Info", folder.path)		
		else
			MsgBox """" & path & """ nicht gefunden!"
		end if
	end if
end sub

function GetDetails(obj)
	txt = "Name: " & obj.name & vbCr
	txt = txt & "Typ: " & obj.Type & vbCr
	txt = txt & "angelegt: " & _
		DateValue(obj.DateCreated) & vbCr
	txt = txt & "gendert: " & _
		DateValue(obj.DateLastModified) & vbCr
	txt = txt & "benutzt: " & _
		DateValue(obj.DateLastAccessed) & vbCr
	txt = txt & "DOS-Name: " & _
		obj.ShortName & vbCr
	GetDetails = txt & "Gre: " _
		& FormatNumber(obj.Size/1024,2) & " KB" & vbCr
end function

