' KOMMANDO.VBS
' Interaktive VBScript-Umgebung
' Skript mu auf DOS-Ebene mit CSCRIPT.EXE
' gestartet werden und akzeptiert dann
' VBScript-Befehle sowie Listingfunktionen
' (C) Tobias Weltner, c't 21/99

' Ein- und Ausgabe definieren
set prveingabe = WScript.StdIn
set prvausgabe = WScript.StdOut

' Zeilennummern definieren
redim prvlisting(1000)

prvprompt = "VBScript> "

' Hinweise ausgeben:
prvausgabe.WriteLine "Geben Sie VBScript-Befehle ein!"
prvausgabe.WriteLine "Geben Sie 'exit' ein, um zu beenden!"
prvausgabe.Write prvprompt

do while not prveingabe.atEndOfStream 
	' aktuelle Eingabe lesen:
	prvzeile = prveingabe.ReadLine

	' Kommandos herausfischen:
	if lcase(prvzeile)="exit" then 
		exit do	
	elseif lcase(prvzeile)="clear" then
		for x=1 to 25
			prvausgabe.WriteLine
		next
	elseif lcase(prvzeile)="list" then
		ShowListing
	elseif lcase(prvzeile)="run" then
		ExecuteListing
	elseif lcase(prvzeile)="delete" then
		redim prvlisting(1000)
	else
		' kein eigenes Kommando, also als
		' neue Programmzeile interpretieren:
		ManageLine prvzeile
	end if
	' Prompt ausgeben:
	prvausgabe.Write prvprompt
loop

prvausgabe.WriteLine "PROGRAMM BEENDET."

sub ShowListing
	' Listing lschen:
	prvlist = ""

	' alle nicht leeren Zeilen mit Zeilennummer
	' ausgaben:
	for prvx=0 to UBound(prvlisting)
		if not prvlisting(prvx)="" then
			prvlist = prvlist & prvx & vbTab _
				& prvlisting(prvx) & vbCrLf
		end if
	next
	prvausgabe.Write prvList
end sub

sub ExecuteListing
	' Listing ausfhren:
	for prvx=0 to UBound(prvlisting)
		' alle nicht leeren Zeilen zusammenfassen und
		' die speziellen Zeichen ?? und ??? durch die
		' Ausgabebefehle ersetzen:
		if not prvlisting(prvx)="" then
			prvlist = prvlist & prvlisting(prvx) & vbCr
		end if
	next
	prvList = Replace(prvList, "???", "prvausgabe.Write ")
	prvList = Replace(prvList, "??", "prvausgabe.WriteLine ")

	' ausfhren:
	on error resume next
	ExecuteGlobal prvList
	if not err.Number=0 then
		prvausgabe.WriteLine "FEHLER IM LISTING: " _
			& Convert(err.description)
		err.clear
	end if
end sub

sub ManageLine(prvzeile)
	' neue Zeile einfgen oder Zeile lschen:
	' wo ist das erste Leerzeichen?
	prvpos = Instr(prvzeile, " ")
	if prvpos>0 then
		' links davon ist Zeilennummer, rechts Code:
		prvnr = left(prvzeile, prvpos)
		prvcode = trim(mid(prvzeile, prvpos))
		if isNumeric(prvnr) then
			' wirklich eine Zeilennummer?
			prvnr = Fix(prvnr)
			' dann Code in Listing aufnehmen:
			prvlisting(prvnr) = prvcode
		else
			' direkt ausfhren
			ExecuteDirect
		end if
	else
		' nur Zeilennummer, aber kein Code?
		' dann Zeile lschen:
		if isNumeric(prvzeile) then
			prvlisting(Fix(prvzeile))=""
		else
			' Zeile soll direkt ausgefhrt werden:
			ExecuteDirect
		end if
	end if
end sub

sub ExecuteDirect
	prvzeile = Replace(prvzeile, "???", "prvausgabe.Write ")
	prvzeile = Replace(prvzeile, "??", "prvausgabe.WriteLine ")
	on error resume next
	ExecuteGlobal prvzeile
	if not err.Number=0 then
		prvausgabe.WriteLine "FEHLER: " _
			& Convert(err.description)
		err.clear
	end if
	on error goto 0
end sub		

function Convert(text)
	Convert = Replace(text, chr(228), chr(132))
	Convert = Replace(Convert, chr(252), chr(129))
	Convert = Replace(Convert, chr(196), chr(142))
	Convert = Replace(Convert, chr(220), chr(154))
	Convert = Replace(Convert, chr(214), chr(153))
	Convert = Replace(Convert, chr(246), chr(148))
	Convert = Replace(Convert, chr(223), chr(225))
end function
