unit ModeUnit;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TDisplayModeWindow = class(TForm)
    GroupBoxFrequencies: TGroupBox;
		LabelFreqHorz: TLabel;
    LabelFreqVert: TLabel;
		EditFreqHorz: TEdit;
		EditFreqVert: TEdit;
		LabelFreqHorzUnity: TLabel;
		LabelFreqVertUnity: TLabel;
		GroupBoxPolarisation: TGroupBox;
		GroupBoxPolHorz: TGroupBox;
		GroupBoxPoVert: TGroupBox;
		RadioButtonPolHorzPos: TRadioButton;
		RadioButtonPolHorzNeg: TRadioButton;
		RadioButtonPolVertPos: TRadioButton;
		RadioButtonPolVertNeg: TRadioButton;
		ButtonOK: TButton;
		ButtonCancel: TButton;
		GroupBoxResolution: TGroupBox;
		CheckBoxSpecialResolution: TCheckBox;
		LabelResUnity: TLabel;
		ComboBoxSpecialRes: TComboBox;
		procedure EditFreqChange(Sender: TObject);
		procedure SpecialResolutionClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure ComboBoxSpecialResChange(Sender: TObject);
	private
	public
		procedure UpdateRes;
	end;

var
	DisplayModeWindow: TDisplayModeWindow;

implementation

{$R *.DFM}

uses
	MainUnit;

{ TDisplayModeWindow }

procedure TDisplayModeWindow.EditFreqChange(Sender: TObject);
var
	S:    string;
	I,
	SelS,
	SelL: Integer;
	Sep:  Boolean;
begin
	with Sender as TEdit do begin
		S    := Text;
		SelS := SelStart;
		SelL := SelLength;
		I    := 1;
		Sep  := False;
		while I <= Length (S) do begin
			if not (S [I] in ['0'..'9', '.', ',', '-']) then begin
				Delete (S, I, 1);
				Dec (I);
			end;
			if S [I] = ',' then
				S [I] := '.';
			if S [I] = '-' then begin
				if Sep then begin
					Delete (S, I, 1);
					Dec (I);
				end else
					Sep := True;
			end;
			Inc (I);
		end;
		Text      := S;
		SelStart  := SelS;
		SelLength := SelL;
	end;
end;

procedure TDisplayModeWindow.SpecialResolutionClick(Sender: TObject);
begin
	UpdateRes;
end;

procedure TDisplayModeWindow.UpdateRes;
begin
	if ComboBoxSpecialRes.Enabled <> CheckBoxSpecialResolution.Checked then begin
		ComboBoxSpecialRes.Enabled := CheckBoxSpecialResolution.Checked;
		with ComboBoxSpecialRes do begin
			if Enabled then
				Text := '640x480'
			else
				Text := '';
		end;
	end;
end;

procedure TDisplayModeWindow.FormShow(Sender: TObject);
begin
	UpdateRes;
end;

procedure TDisplayModeWindow.ComboBoxSpecialResChange(Sender: TObject);
begin
	MainWindow.ComboBoxResChange (Sender);
end;

end.
