//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <printers.hpp>

#include "Bild.h"
#include "CLRFrame.h"
#include "CLREdit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TBildForm *BildForm;
//---------------------------------------------------------------------------
__fastcall TBildForm::TBildForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  Action = caFree;
  if (FrameForm->shutdown) return;
  if (FrameForm->MDIChildCount <= 1) {
    FrameForm->SpeedButtonClose->Enabled = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TBildForm::CheckBoxStretchedClick(TObject *Sender)
{
  if (CheckBoxStretched->Checked) {
    Image1->Stretch = true;
    HorzScrollBar->Range = 0;
    VertScrollBar->Range = 0;
  }
  else {
    Image1->Stretch = false;
    HorzScrollBar->Range = Image1->Picture->Width;
    VertScrollBar->Range = Image1->Picture->Height;
  }
}
//---------------------------------------------------------------------------
void __fastcall TBildForm::FormCreate(TObject *Sender)
{
  if (!FrameForm->SpeedButtonClose->Enabled) {
    FrameForm->SpeedButtonClose->Enabled = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TBildForm::Druckereinrichtung1Click(TObject *Sender)
{
  PrinterSetupDialog1->Execute (); // Dialogfeld "Druckereinrichtung" ausfhren
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Bilddrucken1Click(TObject *Sender)
{
  int cinch = 1440;
  float cZMM = 25.4;

  unsigned int          BitmapInfoSize, BitmapImageSize;
  long                  DIBWidth, DIBHeight;
  PChar                 BitmapImage;
  Windows::PBitmapInfo  BitmapInfo;
  Graphics::TBitmap     *Bitmap;
  float                 xfact, yfact;
//  int                   xPixel, yPixel;
  int                   xOffset;
  int                   yOffset;
  int                   rMargin;
  int                   bMargin;
// Get and calculate the user set mm values
  int oLeftMargin = FrameForm->Konfig.LeftMargin * cinch / cZMM;
  int oRightMargin = FrameForm->Konfig.RightMargin * cinch / cZMM;
  int oTopMargin = FrameForm->Konfig.TopMargin * cinch / cZMM;
  int oBottomMargin = FrameForm->Konfig.BottomMargin * cinch / cZMM;
// First, we get the size of a printed page in printer device units
//  int wPage = ::GetDeviceCaps (Printer()->Handle, PHYSICALWIDTH);
//  int hPage = ::GetDeviceCaps (Printer()->Handle, PHYSICALHEIGHT);
// Next, get the device units per inch for the printer
  int xPPI = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSX);
  int yPPI = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSY);

  xOffset = -::GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETX);
  yOffset = -::GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETY);
  rMargin = xOffset; bMargin = yOffset;
  xOffset += ::MulDiv (oLeftMargin, xPPI, cinch);
  yOffset += ::MulDiv (oTopMargin, yPPI, cinch);
  rMargin += ::MulDiv (oRightMargin, xPPI, cinch);
  bMargin += ::MulDiv (oBottomMargin, yPPI, cinch);

// Get the printer pixels per inch
//    int printerHorzUnitsPerInch = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSX);
//    int printerVertUnitsPerInch = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSY);

  int oLeftHeader = xOffset;
  int oTopHeader = - GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETY);
  int oHeaderMargin = FrameForm->Konfig.HeaderMargin * cinch / cZMM;
  oTopHeader = oTopHeader + MulDiv (oHeaderMargin, yPPI, cinch);
  if (oTopHeader < 0) oTopHeader = 0;


  if (PrintDialog1->Execute ()){
    Bitmap = new Graphics::TBitmap();
//    Bitmap->Assign (Image1->Picture);
    Bitmap->Assign (Image1->Picture->Graphic);
    GetDIBSizes (Bitmap->Handle, BitmapInfoSize, BitmapImageSize);
    BitmapInfo = (PBitmapInfo) new char [BitmapInfoSize];
    BitmapImage = (PChar) new char [BitmapImageSize];
    GetDIB (Bitmap->Handle, 0, BitmapInfo, BitmapImage);
    DIBWidth = BitmapInfo->bmiHeader.biWidth;
    DIBHeight = BitmapInfo->bmiHeader.biHeight;

    Printer()->BeginDoc();

    AnsiString header = "";
    AnsiString footer = "";
/*    if (FrameForm->Konfig.PrintHeadline)
      header = Caption;
*/
    header = FrameForm->Konfig.PrintHeader;
    footer = FrameForm->Konfig.PrintFooter;

      header = FrameForm->Konfig.PrintHeader;
      int pathpos = AnsiPos ("$", header);
      if (pathpos > 0) {
        header.Delete (pathpos, 1);
        header.Insert (Caption, pathpos);
      }
/*      int pagepos = AnsiPos ("#", header);
      if (pagepos > 0) {
        header.Delete (pagepos, 1);
        header.Insert (AnsiString (currPage + 1) + "/" + AnsiString (pageCount), pagepos);
      }
*/
      footer = FrameForm->Konfig.PrintFooter;
      pathpos = AnsiPos ("$", footer);
      if (pathpos > 0) {
        footer.Delete (pathpos, 1);
        footer.Insert (Caption, pathpos);
      }
/*      pagepos = AnsiPos ("#", footer);
      if (pagepos > 0) {
        footer.Delete (pagepos, 1);
        footer.Insert (AnsiString (currPage + 1) + "/" + AnsiString (pageCount), pagepos);
      }
*/
    Printer()->Canvas->Font = FrameForm->DefaultFont;
    Printer()->Canvas->TextOut (oLeftHeader, oTopHeader, header);

    if (FrameForm->Konfig.FitPicture) {
      xfact = (float)(Printer()->PageWidth - xOffset - rMargin) / (float)DIBWidth;
      yfact = (float)(Printer()->PageHeight - yOffset - bMargin) / (float)DIBHeight;
      if (xfact > yfact){
        xfact = yfact;
        xOffset = (Printer()->PageWidth - DIBWidth * xfact) / 2;
      }
      else{
        yfact = xfact;
        yOffset = (Printer()->PageHeight - DIBHeight * yfact) / 2;
      }
    }
    else {xfact = 1.0; yfact = 1.0;}
    StretchDIBits (Printer ()->Canvas->Handle,
                xOffset, yOffset, DIBWidth * xfact, DIBHeight * yfact,
                0, 0, DIBWidth, DIBHeight,
                BitmapImage, BitmapInfo,
                DIB_RGB_COLORS, SRCCOPY);
    delete [] BitmapImage;
    delete [] BitmapInfo;
    delete Bitmap;

    Printer()->EndDoc ();
  }
}
//---------------------------------------------------------------------------
void __fastcall TBildForm::InitInfo()
{
  if (initialisiert) return;
  initialisiert = true;
//ShowMessage ("InitInfo");
  ClientHeight = BildForm->Image1->Picture->Height + Panel1->Height;

  if (BildForm->Image1->Picture->Width > 274)
    ClientWidth = BildForm->Image1->Picture->Width;
  else ClientWidth = 300;

  if (Height > FrameForm->ClientHeight - 100) Height = FrameForm->ClientHeight - 100;
  if (Width > FrameForm->ClientWidth - 10) Width = FrameForm->ClientWidth - 10;

  ScrollBoxPicture->HorzScrollBar->Range = Image1->Picture->Width;
  ScrollBoxPicture->VertScrollBar->Range = Image1->Picture->Height;
  LabelBildmasse->Caption =
    "Breite: " + IntToStr (BildForm->Image1->Picture->Height) +
    ", Hhe: " + IntToStr (BildForm->Image1->Picture->Width);
}
//---------------------------------------------------------------------------
void __fastcall TBildForm::FormPaint(TObject *Sender)
{
//ShowMessage ("FormPaint");
  InitInfo();
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::FormActivate(TObject *Sender)
{
  // ------------------- Speed-Buttons enable -------------------
//  if (!FrameForm->SpeedButtonSave->Enabled){
    FrameForm->SpeedButtonSave->Enabled = false;
    FrameForm->SpeedButtonClose->Enabled = true;
    FrameForm->SpeedButtonLoadFromCursor->Enabled = false;
    FrameForm->SpeedButtonFind->Enabled = false;
    FrameForm->SpeedButtonReplace->Enabled = false;
    FrameForm->SpeedButtonCut->Enabled = false;
    FrameForm->SpeedButtonCopy->Enabled = false;
    FrameForm->SpeedButtonPaste->Enabled = false;
    FrameForm->SpeedButtonUndo->Enabled = false;
    FrameForm->SpeedButtonPrint->Enabled = true;
    FrameForm->SpeedButtonPrevious->Enabled = true;
    FrameForm->SpeedButtonNext->Enabled = true;

    FrameForm->SpeedButtonBold->Enabled = false;
    FrameForm->SpeedButtonItalic->Enabled = false;
    FrameForm->SpeedButtonUnderline->Enabled = false;
//    FrameForm->SpeedButtonLeft->Enabled = false;
//    FrameForm->SpeedButtonCenter->Enabled = false;
//    FrameForm->SpeedButtonRight->Enabled = false;
    FrameForm->SpeedButtonBullets->Enabled = false;

//  } // if SpeedButtonSave
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::FormResize(TObject *Sender)
{
  InitInfo();
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::SpeedButtonInitClick(TObject *Sender)
{
  InitInfo();
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::FormDestroy(TObject *Sender)
{
  if (FrameForm->shutdown) return;
  if (FrameForm->MDIChildCount <= 1)
    FrameForm->SpeedButtonClose->Enabled = false;
  // ------------------- Speed-Buttons disable -------------------
  if (!FrameForm->SpeedButtonClose->Enabled){
    FrameForm->SpeedButtonSave->Enabled = false;
//    FrameForm->SpeedButtonClose->Enabled = false;
    FrameForm->SpeedButtonLoadFromCursor->Enabled = false;
    FrameForm->SpeedButtonFind->Enabled = false;
    FrameForm->SpeedButtonReplace->Enabled = false;
    FrameForm->SpeedButtonCut->Enabled = false;
    FrameForm->SpeedButtonCopy->Enabled = false;
    FrameForm->SpeedButtonPaste->Enabled = false;
    FrameForm->SpeedButtonUndo->Enabled = false;
    FrameForm->SpeedButtonPrint->Enabled = false;
    FrameForm->SpeedButtonPrevious->Enabled = false;
    FrameForm->SpeedButtonNext->Enabled = false;

    FrameForm->SpeedButtonBold->Enabled = false;
    FrameForm->SpeedButtonItalic->Enabled = false;
    FrameForm->SpeedButtonUnderline->Enabled = false;
//    FrameForm->SpeedButtonLeft->Enabled = false;
//    FrameForm->SpeedButtonCenter->Enabled = false;
//    FrameForm->SpeedButtonRight->Enabled = false;
    FrameForm->SpeedButtonBullets->Enabled = false;
  } // if SpeedButtonSave
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Neu1Click(TObject *Sender)
{
  FrameForm->New1Click (Sender); // Behandlungsroutine des Rahmenformulars aufrufen
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Oeffnen1Click(TObject *Sender)
{
  FrameForm->Open1Click (Sender);
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::LetztenTextwiederoeffnen1Click(TObject *Sender)
{
  FrameForm->OpenLastDocument1Click (Sender);
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Allespeichern1Click(TObject *Sender)
{
  int i;
  TEditForm *EdForm;
  for (i=0; i <= FrameForm->MDIChildCount - 1; i++){
    if (EdForm = dynamic_cast <TEditForm*> (FrameForm->MDIChildren [i])){
      EdForm->Save1Click (Sender);
    } // if
  } // for
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Schliessen1Click(TObject *Sender)
{
  Close ();
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Alleschliessen1Click(TObject *Sender)
{
  FrameForm->AlleSchliessen();
}
//---------------------------------------------------------------------------

void __fastcall TBildForm::Editorbeenden1Click(TObject *Sender)
{
  FrameForm->CloseProgram1Click (Sender); // Beenden des Rahmenformulars aufrufen
}
//---------------------------------------------------------------------------

